/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.Nest;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.entity.NestChickenModel;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class NestRenderer
extends TileEntityRenderer<NestTileEntity> {
    private static final NestChickenModel<ChickenEntity> chickenModel = new NestChickenModel();
    private static final Minecraft mc = Minecraft.func_71410_x();

    public NestRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(NestTileEntity tileEntity, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        Direction direction = (Direction)tileEntity.func_195044_w().func_177229_b((Property)Nest.FACING);
        if (tileEntity.entityCaptured != null) {
            RenderType renderType = chickenModel.func_228282_a_(tileEntity.chickenTexture);
            IVertexBuilder vertexBuilder = buffer.getBuffer(renderType);
            NestRenderer.chickenModel.field_217114_e = tileEntity.chickenAge < 0;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, NestRenderer.chickenModel.field_217114_e ? (double)1.4f : (double)1.32f, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(direction.func_185119_l()));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            chickenModel.func_225598_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            vertexBuilder.func_181675_d();
            matrixStack.func_227865_b_();
            if (((Boolean)ResourceChickens.CONFIGURATION.renderLabels.get()).booleanValue() && tileEntity.entityCustomName != null && this.field_228858_b_.field_217666_g.func_216785_c().func_186679_c((double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p()) < 64.0) {
                NestRenderer.renderLabel(matrixStack, buffer, combinedLight, tileEntity.entityCustomName);
            }
        }
        if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue() && this.field_228858_b_.field_217666_g.func_216785_c().func_186679_c((double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p()) < 64.0) {
            for (int a = 0; a < 4; ++a) {
                if (tileEntity.STORED_ITEMS.getStackInSlot(a).func_190926_b()) continue;
                NestRenderer.renderItem(tileEntity.STORED_ITEMS.getStackInSlot(a), NestRenderer.getTranslation(a, direction), Vector3f.field_229181_d_.func_229187_a_(180.0f + direction.func_185119_l()), matrixStack, buffer, combinedOverlay, combinedLight);
            }
        }
    }

    private static void renderLabel(MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightLevel, ITextComponent text) {
        FontRenderer fontRenderer = NestRenderer.mc.field_71466_p;
        matrixStack.func_227860_a_();
        float scale = 0.02f;
        int opacity = 0x66000000;
        float offset = -fontRenderer.func_238414_a_((ITextProperties)text) / 2;
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        matrixStack.func_227861_a_(0.5, 1.0, 0.5);
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227863_a_(mc.func_175598_ae().func_229098_b_());
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        fontRenderer.func_243247_a(text, offset, 0.0f, 0, false, matrix4f, buffer, true, opacity, lightLevel);
        fontRenderer.func_243247_a(text, offset, 0.0f, -1, false, matrix4f, buffer, false, 0, lightLevel);
        matrixStack.func_227865_b_();
    }

    private static double[] getTranslation(int index, Direction direction) {
        switch (direction) {
            default: {
                switch (index) {
                    case 0: {
                        return new double[]{0.25, 0.15, 0.25};
                    }
                    case 1: {
                        return new double[]{0.75, 0.15, 0.25};
                    }
                    case 2: {
                        return new double[]{0.75, 0.15, 0.75};
                    }
                }
                return new double[]{0.25, 0.15, 0.75};
            }
            case SOUTH: {
                switch (index) {
                    case 0: {
                        return new double[]{0.75, 0.15, 0.75};
                    }
                    case 1: {
                        return new double[]{0.25, 0.15, 0.75};
                    }
                    case 2: {
                        return new double[]{0.25, 0.15, 0.25};
                    }
                }
                return new double[]{0.75, 0.15, 0.25};
            }
            case WEST: {
                switch (index) {
                    case 0: {
                        return new double[]{0.25, 0.15, 0.75};
                    }
                    case 1: {
                        return new double[]{0.25, 0.15, 0.25};
                    }
                    case 2: {
                        return new double[]{0.75, 0.15, 0.25};
                    }
                }
                return new double[]{0.75, 0.15, 0.75};
            }
            case EAST: 
        }
        switch (index) {
            case 0: {
                return new double[]{0.75, 0.15, 0.25};
            }
            case 1: {
                return new double[]{0.75, 0.15, 0.75};
            }
            case 2: {
                return new double[]{0.25, 0.15, 0.75};
            }
        }
        return new double[]{0.25, 0.15, 0.25};
    }

    private static void renderItem(ItemStack stack, double[] translation, Quaternion rotation, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedOverlay, int lightLevel) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(translation[0], translation[1], translation[2]);
        matrixStack.func_227863_a_(rotation);
        matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        IBakedModel iBakedModel = mc.func_175599_af().func_184393_a(stack, null, null);
        mc.func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.GROUND, true, matrixStack, buffer, lightLevel, combinedOverlay, iBakedModel);
        matrixStack.func_227865_b_();
    }
}

