/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import com.google.gson.JsonParseException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestItemStackHandler;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.json.ChickenData;

public class NestTileEntity
extends TileEntity
implements ITickableTileEntity {
    public final NestItemStackHandler STORED_ITEMS = new NestItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue()) {
                NestTileEntity.this.sendRenderUpdates();
            }
        }
    };
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> this.STORED_ITEMS);
    private LazyOptional<IItemHandler> outputItemHandlerCached = null;
    public ChickenData chickenData = null;
    public ResourceLocation chickenTexture = null;
    public CompoundNBT entityCaptured = null;
    public StringTextComponent entityDescription = null;
    public ITextComponent entityCustomName = null;
    public int eggLayTime;
    public int chickenAge;
    public int chickenGrowth;
    public int chickenGain;
    public int chickenStrength;

    public NestTileEntity() {
        super((TileEntityType)initTiles.NEST_BLOCK_TILE.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (!this.func_145837_r() && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        this.func_189515_b(compound);
        return compound;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("Inventory")) {
            this.STORED_ITEMS.contents().clear();
            this.STORED_ITEMS.deserializeNBT(compound.func_74775_l("Inventory"));
        }
        if (compound.func_74764_b("entityCaptured")) {
            this.entitySet(compound.func_74775_l("entityCaptured"), compound.func_74779_i("entityDescription"), false);
        } else {
            this.entityRemove(false);
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("Inventory", (INBT)this.STORED_ITEMS.serializeNBT());
        if (this.entityCaptured != null) {
            this.entityCaptured.func_74768_a("EggLayTime", this.eggLayTime);
            this.entityCaptured.func_74768_a("Age", this.chickenAge);
            compound.func_218657_a("entityCaptured", (INBT)this.entityCaptured);
            compound.func_74778_a("entityDescription", this.entityDescription.getString());
        }
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.entityCaptured == null) {
            return;
        }
        if (this.chickenData.eggLayTime == 0) {
            return;
        }
        boolean isDirty = false;
        if (this.chickenAge < 0) {
            ++this.chickenAge;
            if (this.chickenAge >= 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, this.field_145850_b.field_73012_v.nextBoolean() ? SoundEvents.field_187665_Y : (this.chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.field_187660_W), SoundCategory.PLAYERS, 1.0f, 1.0f);
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.func_195044_w()), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.2, (double)this.field_174879_c.func_177952_p() + 0.5, 20, 0.3, 0.2, 0.3, 0.0);
                this.sendRenderUpdates();
                isDirty = true;
                this.eggLayTime = ResourceChickens.calcNewEggLayTime(this.field_145850_b.field_73012_v, this.chickenData, this.chickenGrowth);
            }
        }
        if (this.chickenAge >= 0 && !this.STORED_ITEMS.getStackInSlot(0).func_190926_b()) {
            --this.eggLayTime;
            if (this.eggLayTime == 0) {
                this.eggLayTime = ResourceChickens.calcNewEggLayTime(this.field_145850_b.field_73012_v, this.chickenData, this.chickenGrowth);
                this.STORED_ITEMS.getStackInSlot(0).func_190918_g(1);
                isDirty = true;
                for (int slot = 1; slot < this.STORED_ITEMS.getSlots(); ++slot) {
                    ItemStack itemStack2 = this.STORED_ITEMS.getStackInSlot(slot);
                    ItemStack result = this.getCachedItemHandler().map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)itemStack2, (boolean)false)).orElse(itemStack2);
                    this.STORED_ITEMS.setStackInSlot(slot, result);
                }
                List<ItemStack> DROPS = ResourceChickens.calcDrops(this.chickenGain, this.chickenData, 0);
                DROPS.replaceAll(itemStack -> this.getCachedItemHandler().map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)itemStack, (boolean)false)).orElse(itemStack));
                DROPS.forEach(this.STORED_ITEMS::insertItemAnySlot);
                if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue()) {
                    this.sendRenderUpdates();
                }
            }
        }
        if (isDirty) {
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        this.inventory.invalidate();
        super.func_145843_s();
    }

    public void updateCachedItemHandler() {
        LazyOptional lazyOptional;
        TileEntity tileEntity;
        TileEntity tileEntity2 = tileEntity = this.field_145850_b != null && this.field_145850_b.func_195588_v(this.field_174879_c.func_177977_b()) ? this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b()) : null;
        if (tileEntity != null && (lazyOptional = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP)).isPresent() && this.outputItemHandlerCached != lazyOptional) {
            this.outputItemHandlerCached = lazyOptional;
            this.outputItemHandlerCached.addListener(lazy -> this.updateCachedItemHandler());
            return;
        }
        this.outputItemHandlerCached = LazyOptional.empty();
    }

    private LazyOptional<IItemHandler> getCachedItemHandler() {
        if (this.outputItemHandlerCached == null) {
            this.updateCachedItemHandler();
        }
        return this.outputItemHandlerCached;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public void entityRemove(boolean sendRenderUpdates) {
        this.chickenAge = 0;
        this.chickenGrowth = 0;
        this.chickenGain = 0;
        this.chickenStrength = 0;
        this.eggLayTime = 0;
        this.chickenData = null;
        this.chickenTexture = null;
        this.entityCaptured = null;
        this.entityDescription = null;
        this.entityCustomName = null;
        if (sendRenderUpdates) {
            this.sendRenderUpdates();
        }
        this.func_70296_d();
    }

    public void entitySet(CompoundNBT entityCaptured, String desc, boolean sendRenderUpdates) {
        this.entityCaptured = entityCaptured.func_74737_b();
        this.entityDescription = new StringTextComponent(desc);
        this.chickenData = initRegistry.getChickenDataFromLongID(this.entityCaptured.func_74779_i("id"));
        this.chickenTexture = ResourceChickens.getTexture(this.chickenData, entityCaptured.func_186857_a("UUID"));
        if (entityCaptured.func_74764_b("CustomName")) {
            this.entityCustomName = ITextComponent.Serializer.func_240643_a_((String)this.entityCaptured.func_74779_i("CustomName"));
        }
        this.eggLayTime = entityCaptured.func_74762_e("EggLayTime");
        this.chickenAge = entityCaptured.func_74762_e("Age");
        this.chickenGrowth = entityCaptured.func_74762_e("growth");
        this.chickenGain = entityCaptured.func_74762_e("gain");
        this.chickenStrength = entityCaptured.func_74762_e("strength");
        if (sendRenderUpdates) {
            this.sendRenderUpdates();
        }
        this.func_70296_d();
    }

    public void sendRenderUpdates() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void entitySetCustomName(CompoundNBT compound) {
        if (this.entityCaptured != null) {
            if (compound != null && compound.func_150297_b("Name", 8)) {
                try {
                    String name = compound.func_74779_i("Name");
                    IFormattableTextComponent iTextComponent = ITextComponent.Serializer.func_240643_a_((String)name);
                    if (iTextComponent != null) {
                        this.entityCaptured.func_74778_a("CustomName", name);
                        this.entityCustomName = iTextComponent;
                        this.func_70296_d();
                        return;
                    }
                }
                catch (JsonParseException e) {
                    compound.func_82580_o("Name");
                }
            }
            this.entityCaptured.func_82580_o("CustomName");
            this.entityCustomName = null;
            this.func_70296_d();
        }
    }
}

