/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JEI;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.JEI.EntityIngredient;
import wallywhip.resourcechickens.compat.JEI.JEIPlugin;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.json.ChickenData;

public class JEIChickenBreedingCategory
implements IRecipeCategory<Recipe> {
    private static final ResourceLocation GUI_BACK = new ResourceLocation("resourcechickens", "textures/gui/jei.png");
    private static final ResourceLocation ICONS = new ResourceLocation("resourcechickens", "textures/gui/icons.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcechickens", "jei.breeding");
    private final IDrawable background;
    private final IDrawable icon;
    private final String title;

    public JEIChickenBreedingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 19, 109, 18).build();
        this.icon = guiHelper.createDrawable(ICONS, 0, 0, 16, 16);
        this.title = new TranslationTextComponent("jei.resourcechickens.category.breeding").getString();
    }

    public static List<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (((Boolean)ResourceChickens.CONFIGURATION.allowCrossBreeding.get()).booleanValue()) {
            initRegistry.DATA.forEach((id, chickenData) -> {
                if (!chickenData.parentA.equals("") || !chickenData.parentB.equals("")) {
                    recipes.add(new Recipe(initRegistry.getChickenDataFromLongID(chickenData.parentA), initRegistry.getChickenDataFromLongID(chickenData.parentB), (ChickenData)chickenData));
                }
            });
        }
        return recipes;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ArrayList<EntityIngredient> entities = new ArrayList<EntityIngredient>();
        entities.add(new EntityIngredient(((Recipe)recipe).parentA.name));
        entities.add(new EntityIngredient(((Recipe)recipe).parentB.name));
        ingredients.setInputs(JEIPlugin.ENTITY_INGREDIENT, entities);
        ingredients.setOutput(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(((Recipe)recipe).child.name));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, @Nonnull Recipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEIPlugin.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 1, 1);
        ingredientStacks.init(1, true, 38, 1);
        ingredientStacks.init(2, false, 92, 1);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEIPlugin.ENTITY_INGREDIENT).get(0));
        ingredientStacks.set(1, (List)ingredients.getInputs(JEIPlugin.ENTITY_INGREDIENT).get(1));
        ingredientStacks.set(2, (List)ingredients.getOutputs(JEIPlugin.ENTITY_INGREDIENT).get(0));
    }

    public static class Recipe {
        private final ChickenData parentA;
        private final ChickenData parentB;
        private final ChickenData child;

        public Recipe(ChickenData parentA, ChickenData parentB, ChickenData child) {
            this.parentA = parentA;
            this.parentB = parentB;
            this.child = child;
        }
    }
}

