/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JEI;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.JEI.EntityIngredient;
import wallywhip.resourcechickens.compat.JEI.JEIPlugin;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.json.ChickenData;

public class JEIChickenDropsCategory
implements IRecipeCategory<Recipe> {
    private static final ResourceLocation GUI_BACK = new ResourceLocation("resourcechickens", "textures/gui/jei.png");
    private static final ResourceLocation ICONS = new ResourceLocation("resourcechickens", "textures/gui/icons.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcechickens", "jei.drops");
    private final IDrawable background;
    private final IDrawable icon;
    private final String title;

    public JEIChickenDropsCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 72, 18).build();
        this.icon = guiHelper.createDrawable(ICONS, 16, 0, 16, 16);
        this.title = new TranslationTextComponent("jei.resourcechickens.category.drops").getString();
    }

    public static List<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        initRegistry.DATA.forEach((id, chickenData) -> {
            ItemStack itemStack;
            if (chickenData.eggLayTime > 0 && !(itemStack = ResourceChickens.getDropItem(chickenData.dropItemItem)).func_190926_b()) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                itemStack.func_77982_d(chickenData.dropItemNBT);
                items.add(itemStack);
                items.add(new ItemStack((IItemProvider)(chickenData.hasTrait == 1 ? (IItemProvider)initItems.FEATHER_DUCK.get() : Items.field_151008_G)));
                recipes.add(new Recipe((ChickenData)chickenData, (List<ItemStack>)items));
            }
        });
        return recipes;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ArrayList<List> items = new ArrayList<List>();
        items.add(recipe.dropItems);
        ingredients.setOutputLists(VanillaTypes.ITEM, items);
        ingredients.setInput(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.name));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, @Nonnull Recipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(1, false, 54, 0);
        itemStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEIPlugin.ENTITY_INGREDIENT);
        ingredientStacks.init(0, false, 1, 1);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEIPlugin.ENTITY_INGREDIENT).get(0));
    }

    public static class Recipe {
        private final String name;
        private final List<ItemStack> dropItems;

        public Recipe(ChickenData chickenData, @Nullable List<ItemStack> dropItems) {
            this.name = chickenData.name;
            this.dropItems = dropItems;
        }
    }
}

