/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.entity;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.fml.RegistryObject;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.TOP.ITOPInfoEntityProvider;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.json.ChickenData;

@ParametersAreNonnullByDefault
public class ResourceChickenEntity
extends ChickenEntity
implements ITOPInfoEntityProvider {
    public static final Ingredient FOOD_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    public static final DataParameter<Boolean> ANALYZED = EntityDataManager.func_187226_a(ResourceChickenEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> GROWTH = EntityDataManager.func_187226_a(ResourceChickenEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> GAIN = EntityDataManager.func_187226_a(ResourceChickenEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> STRENGTH = EntityDataManager.func_187226_a(ResourceChickenEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public ChickenData chickenData;
    public String conversionType = "";
    public String conversionDescID = "";
    public int conversionRequired = 0;
    public int conversionCount = 0;
    private int noJumpDelay;

    public ResourceChickenEntity(EntityType<? extends ChickenEntity> type, World world, ChickenData chickenData) {
        super(type, world);
        this.chickenData = chickenData;
        this.field_70887_j = ResourceChickens.calcNewEggLayTime(this.field_70146_Z, this.chickenData, 1);
    }

    public static AttributeModifierMap.MutableAttribute createChickenAttributes(String name) {
        ChickenData chickenData = initRegistry.DATA.get(name);
        return ResourceChickenEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, chickenData.baseHealth).func_233815_a_(Attributes.field_233821_d_, chickenData.baseSpeed);
    }

    public int func_70641_bl() {
        return 2;
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.func_145818_k_() ? this.func_200201_e() : (this.chickenData == null ? new StringTextComponent("Chicken") : this.chickenData.displayName);
    }

    public float func_205022_a(BlockPos p_205022_1_, IWorldReader p_205022_2_) {
        return 10.0f;
    }

    public boolean func_213380_a(IWorld p_213380_1_, SpawnReason p_213380_2_) {
        return true;
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends AnimalEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random, ChickenData chickenData) {
        ResourceLocation blockName;
        boolean light;
        boolean bl = chickenData.spawnLight <= 0 ? world.func_226659_b_(blockPos, 0) <= -chickenData.spawnLight : (light = world.func_226659_b_(blockPos, 0) >= chickenData.spawnLight);
        if (light && chickenData.spawnBlocks != null && chickenData.spawnBlocks.size() != 0 && (blockName = world.func_180495_p(blockPos.func_177977_b()).func_177230_c().getRegistryName()) != null) {
            String ss = blockName.toString();
            for (JsonElement w : chickenData.spawnBlocks) {
                if (!w.getAsString().equals(ss)) continue;
                return true;
            }
        }
        return false;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_175503_c > 0) {
                if (this.field_175503_c % 4 == 0) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
                }
                --this.field_175503_c;
            }
        } else if (this.func_70089_S()) {
            int i = this.func_70874_b();
            if (i < 0) {
                this.func_70873_a(++i);
            } else if (i > 0) {
                this.func_70873_a(--i);
            }
        }
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.func_184186_bw()) {
            this.field_70716_bi = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.field_70716_bi > 0) {
            double d0 = this.func_226277_ct_() + (this.field_184623_bh - this.func_226277_ct_()) / (double)this.field_70716_bi;
            double d2 = this.func_226278_cu_() + (this.field_184624_bi - this.func_226278_cu_()) / (double)this.field_70716_bi;
            double d4 = this.func_226281_cx_() + (this.field_184625_bj - this.func_226281_cx_()) / (double)this.field_70716_bi;
            double d6 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d6 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d0, d2, d4);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
        if (this.field_208002_br > 0) {
            this.field_70759_as = (float)((double)this.field_70759_as + MathHelper.func_76138_g((double)(this.field_208001_bq - (double)this.field_70759_as)) / (double)this.field_208002_br);
            --this.field_208002_br;
        }
        Vector3d vector3d = this.func_213322_ci();
        double d1 = vector3d.field_72450_a;
        double d3 = vector3d.field_72448_b;
        double d5 = vector3d.field_72449_c;
        if (Math.abs(vector3d.field_72450_a) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vector3d.field_72448_b) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vector3d.field_72449_c) < 0.003) {
            d5 = 0.0;
        }
        this.func_213293_j(d1, d3, d5);
        this.field_70170_p.func_217381_Z().func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        } else if (this.func_70613_aW()) {
            this.field_70170_p.func_217381_Z().func_76320_a("newAi");
            this.func_70626_be();
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("jump");
        if (this.field_70703_bu && this.func_241208_cS_()) {
            double d7 = this.func_180799_ab() ? this.func_233571_b_((ITag)FluidTags.field_206960_b) : this.func_233571_b_((ITag)FluidTags.field_206959_a);
            boolean flag = this.func_70090_H() && d7 > 0.0;
            double d8 = this.func_233579_cu_();
            if (!flag || this.field_70122_E && !(d7 > d8)) {
                if (!this.func_180799_ab() || this.field_70122_E && !(d7 > d8)) {
                    if ((this.field_70122_E || flag && d7 <= d8) && this.noJumpDelay == 0) {
                        this.func_70664_aZ();
                        this.noJumpDelay = 10;
                    }
                } else {
                    this.func_180466_bG((ITag)FluidTags.field_206960_b);
                }
            } else {
                this.func_180466_bG((ITag)FluidTags.field_206959_a);
            }
        } else {
            this.noJumpDelay = 0;
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("travel");
        this.field_70702_br *= 0.98f;
        this.field_191988_bg *= 0.98f;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_213352_e(new Vector3d((double)this.field_70702_br, (double)this.field_70701_bs, (double)this.field_191988_bg));
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("push");
        if (this.field_204807_bs > 0) {
            --this.field_204807_bs;
            this.func_204801_a(axisalignedbb, this.func_174813_aQ());
        }
        this.func_85033_bc();
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.field_70170_p.field_72995_K && this.func_230270_dK_() && this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        this.field_70888_h = this.field_70886_e;
        this.field_70884_g = this.field_70883_f;
        this.field_70883_f = (float)((double)this.field_70883_f + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.field_70883_f = MathHelper.func_76131_a((float)this.field_70883_f, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.field_70889_i < 1.0f) {
            this.field_70889_i = 1.0f;
        }
        this.field_70889_i = (float)((double)this.field_70889_i * 0.9);
        vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.field_70886_e += this.field_70889_i * 2.0f;
        if (((Boolean)ResourceChickens.CONFIGURATION.allowInWorldDrops.get()).booleanValue() && this.chickenData.eggLayTime != 0 && !this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && !this.field_152118_bv && --this.field_70887_j <= 0) {
            ResourceChickens.calcDrops((Integer)this.field_70180_af.func_187225_a(GAIN), this.chickenData, 0).forEach(arg_0 -> ((ResourceChickenEntity)this).func_199701_a_(arg_0));
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.field_70887_j = ResourceChickens.calcNewEggLayTime(this.field_70146_Z, this.chickenData, (Integer)this.field_70180_af.func_187225_a(GROWTH));
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.chickenData.hasTrait == 2) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                if (this.field_70146_Z.nextInt(100) == 0 && !this.func_174814_R()) {
                    this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187810_eg, SoundCategory.NEUTRAL, 0.5f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f, false);
                }
            } else if (this.chickenData.hasTrait == 5) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(0.5), this.func_226279_cv_() + 0.7, this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226282_d_(0.5), this.func_226279_cv_() + 0.7, this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
                if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                    this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187597_B, SoundCategory.NEUTRAL, 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
                }
            }
        }
    }

    public boolean func_70878_b(AnimalEntity entityIn) {
        if ((Integer)ResourceChickens.CONFIGURATION.masterSwitchBreeding.get() == 0) {
            return false;
        }
        if (this.func_70880_s() && entityIn.func_70880_s()) {
            ResourceChickenEntity rce = null;
            if (entityIn instanceof ResourceChickenEntity) {
                rce = (ResourceChickenEntity)entityIn;
            }
            if (rce == null) {
                return false;
            }
            if ((Integer)ResourceChickens.CONFIGURATION.masterSwitchBreeding.get() == 2) {
                if (!this.chickenData.canBreed) {
                    return false;
                }
                if (!rce.chickenData.canBreed) {
                    return false;
                }
            }
            if (this.chickenData.hasTrait == 1 && rce.chickenData.hasTrait == 1) {
                return true;
            }
            if (this.chickenData.hasTrait == 1 || rce.chickenData.hasTrait == 1) {
                return false;
            }
            if (this.chickenData.name.equals(rce.chickenData.name)) {
                return true;
            }
            if (this.chickenData.name.equals("chicken") || rce.chickenData.name.equals("chicken")) {
                return (Integer)ResourceChickens.CONFIGURATION.allowBreedingWithVanilla.get() > 0;
            }
            return (Boolean)ResourceChickens.CONFIGURATION.allowCrossBreeding.get();
        }
        return false;
    }

    public ChickenEntity func_241840_a(ServerWorld worldIn, AgeableEntity ageableEntity) {
        ResourceChickenEntity rce = null;
        if (ageableEntity instanceof ResourceChickenEntity) {
            rce = (ResourceChickenEntity)ageableEntity;
        }
        if (rce != null) {
            if (this.chickenData.name.equals(rce.chickenData.name)) {
                ResourceChickenEntity newChicken = (ResourceChickenEntity)((EntityType)this.chickenData.entityType.get()).func_200721_a((World)worldIn);
                if (newChicken != null) {
                    ResourceChickenEntity.increaseStats(newChicken, this, rce, worldIn.field_73012_v);
                }
                return newChicken;
            }
            if (this.chickenData.hasTrait == 1 && rce.chickenData.hasTrait == 1) {
                if (worldIn.field_73012_v.nextBoolean()) {
                    return (ChickenEntity)((EntityType)this.chickenData.entityType.get()).func_200721_a((World)worldIn);
                }
                return (ChickenEntity)((EntityType)rce.chickenData.entityType.get()).func_200721_a((World)worldIn);
            }
            if (this.chickenData.name.equals("chicken")) {
                int r = worldIn.field_73012_v.nextInt(100);
                if (r < (Integer)ResourceChickens.CONFIGURATION.allowBreedingWithVanilla.get()) {
                    return (ChickenEntity)((EntityType)rce.chickenData.entityType.get()).func_200721_a((World)worldIn);
                }
                return (ChickenEntity)((EntityType)this.chickenData.entityType.get()).func_200721_a((World)worldIn);
            }
            if (rce.chickenData.name.equals("chicken")) {
                int r = worldIn.field_73012_v.nextInt(100);
                if (r < (Integer)ResourceChickens.CONFIGURATION.allowBreedingWithVanilla.get()) {
                    return (ChickenEntity)((EntityType)this.chickenData.entityType.get()).func_200721_a((World)worldIn);
                }
                return (ChickenEntity)((EntityType)rce.chickenData.entityType.get()).func_200721_a((World)worldIn);
            }
            if (((Boolean)ResourceChickens.CONFIGURATION.allowCrossBreeding.get()).booleanValue()) {
                String parentA = this.chickenData.entityType.getId().toString();
                String parentB = rce.chickenData.entityType.getId().toString();
                ArrayList<RegistryObject<EntityType<? extends ResourceChickenEntity>>> lst = new ArrayList<RegistryObject<EntityType<? extends ResourceChickenEntity>>>();
                lst.add(this.chickenData.entityType);
                lst.add(rce.chickenData.entityType);
                for (Map.Entry<String, ChickenData> entry : initRegistry.DATA.entrySet()) {
                    boolean b;
                    ChickenData chickenData = entry.getValue();
                    boolean a = Objects.equals(chickenData.parentA, parentA) && Objects.equals(chickenData.parentB, parentB);
                    boolean bl = b = Objects.equals(chickenData.parentA, parentB) && Objects.equals(chickenData.parentB, parentA);
                    if (!a && !b) continue;
                    lst.add(chickenData.entityType);
                    break;
                }
                worldIn.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return (ChickenEntity)((EntityType)((RegistryObject)lst.get(worldIn.field_73012_v.nextInt(lst.size()))).get()).func_200721_a((World)worldIn);
            }
            return null;
        }
        return null;
    }

    public boolean func_70877_b(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (((Boolean)ResourceChickens.CONFIGURATION.dropAsBreedingItem.get()).booleanValue()) {
            if (stack.func_77942_o() && !this.chickenData.dropItemNBT.isEmpty()) {
                return this.chickenData.dropItemNBT == stack.func_77978_p();
            }
            return stack.func_77973_b().toString().equals(this.chickenData.dropItemItem);
        }
        return FOOD_ITEMS.test(stack);
    }

    public void func_146082_f(@Nullable PlayerEntity player) {
        if (player instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerBreeding.get()).booleanValue()) {
            return;
        }
        super.func_146082_f(player);
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (damageSource.func_76346_g() instanceof FakePlayer) {
            return;
        }
        if (this.chickenData.name.equals("grave")) {
            if (!(damageSource.func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity playerIn = (PlayerEntity)damageSource.func_76346_g();
            PlayerInventory playerInv = playerIn.field_71071_by;
            ListNBT lst = this.getPersistentData().func_150295_c("Inventory", 10);
            for (int i = 0; i < lst.size(); ++i) {
                CompoundNBT compoundnbt = lst.func_150305_b(i);
                int j = compoundnbt.func_74771_c("Slot") & 0xFF;
                ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compoundnbt);
                if (itemstack.func_190926_b()) continue;
                if (j < playerInv.field_70462_a.size()) {
                    if (!((ItemStack)playerInv.field_70462_a.get(j)).func_190926_b()) {
                        playerIn.func_71019_a((ItemStack)playerInv.field_70462_a.get(j), false);
                    }
                    playerInv.field_70462_a.set(j, (Object)itemstack);
                    continue;
                }
                if (j >= 100 && j < playerInv.field_70460_b.size() + 100) {
                    if (!((ItemStack)playerInv.field_70460_b.get(j - 100)).func_190926_b()) {
                        playerIn.func_71019_a((ItemStack)playerInv.field_70460_b.get(j - 100), false);
                    }
                    playerInv.field_70460_b.set(j - 100, (Object)itemstack);
                    continue;
                }
                if (j < 150 || j >= playerInv.field_184439_c.size() + 150) continue;
                if (!((ItemStack)playerInv.field_184439_c.get(j - 150)).func_190926_b()) {
                    playerIn.func_71019_a((ItemStack)playerInv.field_184439_c.get(j - 150), false);
                }
                playerInv.field_184439_c.set(j - 150, (Object)itemstack);
            }
        }
        if (this.chickenData.hasTrait == 3) {
            Explosion.Mode explosion$mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            this.field_70170_p.func_230546_a_((Entity)this, new DamageSource("chicken.explode"), (ExplosionContext)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0f + (float)((Integer)this.field_70180_af.func_187225_a(STRENGTH)).intValue() / 2.0f, true, explosion$mode);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (damageSource.func_76346_g() instanceof ResourceChickenEntity) {
            ChickenData damageChickenData = ((ResourceChickenEntity)damageSource.func_76346_g()).chickenData;
            if (this.chickenData.hasTrait == damageChickenData.hasTrait) {
                return false;
            }
        }
        if (this.chickenData.hasTrait == 4 && !this.field_70170_p.field_72995_K) {
            if (damageSource == DamageSource.field_76367_g) {
                return false;
            }
            if (damageSource.func_76346_g() != null) {
                damageSource.func_76346_g().func_70097_a(new DamageSource("chicken.thorns"), 1.0f + (float)((Integer)this.field_70180_af.func_187225_a(STRENGTH)).intValue() / 2.0f);
            }
        }
        boolean wasHurt = super.func_70097_a(damageSource, amount);
        if (damageSource.func_76346_g() instanceof FakePlayer) {
            return wasHurt;
        }
        if (this.func_70089_S() && this.chickenData.hasTrait == 2 && !this.field_70170_p.func_201670_d() && damageSource.func_76346_g() instanceof LivingEntity && this.field_70146_Z.nextInt(10) != 0) {
            for (int i = 0; i < 64 && !this.teleport(); ++i) {
            }
        }
        return wasHurt;
    }

    protected boolean teleport() {
        double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleport(d0, d1, d2);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        if (flag) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected void func_213354_a(DamageSource damageSource, boolean applyLuckFromLastHurtByPlayer) {
        if (damageSource.func_76346_g() instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerLootDrops.get()).booleanValue()) {
            return;
        }
        ResourceLocation resourcelocation = !this.func_213346_cF().func_110624_b().equals("resourcechickens") ? this.func_213346_cF() : (this.chickenData.hasTrait == 1 ? new ResourceLocation("resourcechickens", "entities/duck") : new ResourceLocation("resourcechickens", "entities/chicken"));
        LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        if (loottable != LootTable.field_186464_a) {
            LootContext.Builder lootcontext$builder = this.func_213363_a(applyLuckFromLastHurtByPlayer, damageSource);
            LootContext ctx = lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d);
            loottable.func_216113_a(ctx).forEach(arg_0 -> ((ResourceChickenEntity)this).func_199701_a_(arg_0));
        }
    }

    protected void func_213333_a(DamageSource damageSource, int fortune, boolean allowDrops) {
        if (damageSource.func_76346_g() instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerLootDrops.get()).booleanValue()) {
            return;
        }
        if (!allowDrops || !this.func_213346_cF().func_110624_b().equals("resourcechickens")) {
            return;
        }
        int r = new Random().nextInt(100);
        if (r < (Integer)ResourceChickens.CONFIGURATION.allowDeathDropResource.get()) {
            ResourceChickens.calcDrops((Integer)this.field_70180_af.func_187225_a(GAIN), this.chickenData, fortune).forEach(arg_0 -> ((ResourceChickenEntity)this).func_199701_a_(arg_0));
        }
    }

    protected SoundEvent func_184639_G() {
        if (this.chickenData.hasTrait == 1) {
            return (SoundEvent)initSounds.DUCK_AMBIENT.get();
        }
        if (this.chickenData.hasTrait == 9) {
            return (SoundEvent)initSounds.RADIATION.get();
        }
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        switch (this.chickenData.hasTrait) {
            default: {
                return SoundEvents.field_187666_Z;
            }
            case 1: {
                return (SoundEvent)initSounds.DUCK_DEATH.get();
            }
            case 5: {
                return SoundEvents.field_187603_D;
            }
            case 6: {
                return SoundEvents.field_187565_bO;
            }
            case 7: {
                return SoundEvents.field_187555_bJ;
            }
            case 8: 
        }
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        switch (this.chickenData.hasTrait) {
            default: {
                return SoundEvents.field_187663_X;
            }
            case 1: {
                return (SoundEvent)initSounds.DUCK_DEATH.get();
            }
            case 5: {
                return SoundEvents.field_187600_C;
            }
            case 6: {
                return SoundEvents.field_187561_bM;
            }
            case 7: {
                return SoundEvents.field_187553_bI;
            }
            case 8: 
        }
        return SoundEvents.field_187856_fd;
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, Entity entity, IProbeHitEntityData data) {
        if (((Boolean)this.field_70180_af.func_187225_a(ANALYZED)).booleanValue()) {
            probeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.growth", new Object[]{this.field_70180_af.func_187225_a(GROWTH)}));
            probeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.gain", new Object[]{this.field_70180_af.func_187225_a(GAIN)}));
            probeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.strength", new Object[]{this.field_70180_af.func_187225_a(STRENGTH)}));
        }
        if (((Boolean)ResourceChickens.CONFIGURATION.allowInWorldDrops.get()).booleanValue() && !this.func_70631_g_() && this.chickenData.eggLayTime != 0) {
            probeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.egg", new Object[]{ResourceChickens.formatTime(this.field_70887_j)}));
        }
        if (this.conversionCount != 0) {
            probeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.conv", new Object[]{new TranslationTextComponent(this.conversionDescID)}));
            probeInfo.progress(this.conversionCount, this.conversionRequired);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANALYZED, (Object)true);
        this.field_70180_af.func_187214_a(GROWTH, (Object)1);
        this.field_70180_af.func_187214_a(GAIN, (Object)1);
        this.field_70180_af.func_187214_a(STRENGTH, (Object)1);
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_74764_b("analyzed")) {
            this.field_70180_af.func_187227_b(ANALYZED, (Object)compoundNBT.func_74767_n("analyzed"));
            this.field_70180_af.func_187227_b(GROWTH, (Object)compoundNBT.func_74762_e("growth"));
            this.field_70180_af.func_187227_b(GAIN, (Object)compoundNBT.func_74762_e("gain"));
            this.field_70180_af.func_187227_b(STRENGTH, (Object)compoundNBT.func_74762_e("strength"));
        }
        if (compoundNBT.func_74764_b("Mutation")) {
            CompoundNBT nbt = compoundNBT.func_74775_l("Mutation");
            this.conversionCount = nbt.func_74762_e("count");
            this.conversionRequired = nbt.func_74762_e("req");
            this.conversionType = nbt.func_74779_i("type");
            this.conversionDescID = ResourceChickens.getDropItem(this.conversionType).func_77977_a();
        }
        if (!compoundNBT.func_74764_b("EggLayTime")) {
            this.field_70887_j = ResourceChickens.calcNewEggLayTime(this.field_70146_Z, this.chickenData, (Integer)this.field_70180_af.func_187225_a(GROWTH));
        }
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74757_a("analyzed", ((Boolean)this.field_70180_af.func_187225_a(ANALYZED)).booleanValue());
        compoundNBT.func_74768_a("growth", ((Integer)this.field_70180_af.func_187225_a(GROWTH)).intValue());
        compoundNBT.func_74768_a("gain", ((Integer)this.field_70180_af.func_187225_a(GAIN)).intValue());
        compoundNBT.func_74768_a("strength", ((Integer)this.field_70180_af.func_187225_a(STRENGTH)).intValue());
        if (this.conversionCount != 0) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("count", this.conversionCount);
            nbt.func_74768_a("req", this.conversionRequired);
            nbt.func_74778_a("type", this.conversionType);
            compoundNBT.func_218657_a("Mutation", (INBT)nbt);
        }
    }

    private static void increaseStats(ResourceChickenEntity child, ResourceChickenEntity parentA, ResourceChickenEntity parentB, Random rand) {
        int strengthA = (Integer)parentA.field_70180_af.func_187225_a(STRENGTH);
        int strengthB = (Integer)parentB.field_70180_af.func_187225_a(STRENGTH);
        child.field_70180_af.func_187227_b(GROWTH, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, (Integer)parentA.field_70180_af.func_187225_a(GROWTH), (Integer)parentB.field_70180_af.func_187225_a(GROWTH), rand));
        child.field_70180_af.func_187227_b(GAIN, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, (Integer)parentB.field_70180_af.func_187225_a(GAIN), (Integer)parentB.field_70180_af.func_187225_a(GAIN), rand));
        child.field_70180_af.func_187227_b(STRENGTH, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, strengthA, strengthB, rand));
    }

    private static int calculateNewStat(int thisStrength, int mateStrength, int stat1, int stat2, Random rand) {
        int mutation = rand.nextInt(2) + 1;
        int newStatValue = (stat1 * thisStrength + stat2 * mateStrength) / (thisStrength + mateStrength) + mutation;
        return Math.min(newStatValue, 10);
    }

    private static void inheritStats(ResourceChickenEntity child, ResourceChickenEntity parent) {
        child.field_70180_af.func_187227_b(GROWTH, parent.field_70180_af.func_187225_a(GROWTH));
        child.field_70180_af.func_187227_b(GAIN, parent.field_70180_af.func_187225_a(GAIN));
        child.field_70180_af.func_187227_b(STRENGTH, parent.field_70180_af.func_187225_a(STRENGTH));
    }

    public void func_70873_a(int age) {
        super.func_70873_a(this.calcNewAge(age, (Integer)this.field_70180_af.func_187225_a(GROWTH)));
    }

    public int calcNewAge(int age, int growth) {
        int loveAge;
        boolean resetLoveAfterBreeding;
        boolean resetToChild;
        int childAge = -24000;
        boolean bl = resetToChild = age == childAge;
        if (resetToChild) {
            age = Math.min(-1, childAge * (10 - growth + 1) / 10);
        }
        boolean bl2 = resetLoveAfterBreeding = age == (loveAge = 6000);
        if (resetLoveAfterBreeding) {
            age = Math.max(1, loveAge * (10 - growth + 1) / 10);
        }
        return age;
    }

    protected void func_82167_n(Entity entity) {
        entity.func_70108_f((Entity)this);
        if (!this.field_70170_p.field_72995_K) {
            int dmg = (int)(1.0f + (float)((Integer)this.field_70180_af.func_187225_a(STRENGTH)).intValue() / 2.0f);
            if (this.chickenData.hasTrait == 4) {
                entity.func_70097_a(new DamageSource("chicken.thorns"), (float)dmg);
            }
            if (this.chickenData.hasTrait == 5) {
                entity.func_70015_d(dmg);
            }
            if (this.chickenData.hasTrait == 9) {
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, dmg * 20));
                entity.func_70097_a(new DamageSource("chicken.radiation"), (float)dmg);
            }
        }
    }

    @Nonnull
    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand handIn) {
        ItemStack itemStack;
        if (!playerIn.field_70170_p.field_72995_K && playerIn.func_184600_cs() == handIn && !(itemStack = playerIn.func_184614_ca()).func_190926_b()) {
            if (FOOD_ITEMS.test(itemStack)) {
                return super.func_230254_b_(playerIn, handIn);
            }
            if (itemStack.func_77973_b() instanceof ShearsItem) {
                if (((Boolean)ResourceChickens.CONFIGURATION.allowShearingChickens.get()).booleanValue()) {
                    itemStack.func_222118_a(1, (LivingEntity)playerIn, playr -> playerIn.func_213334_d(handIn));
                    this.func_70097_a(new DamageSource("shears"), 1.0f);
                    World world = playerIn.field_70170_p;
                    Vector3d pos = this.func_213303_ch();
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197614_g, pos.field_72450_a, pos.field_72448_b + (double)this.func_70047_e(), pos.field_72449_c, 10, 0.5, 0.5, 0.5, 0.0);
                    world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187763_eJ, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    world.func_217376_c((Entity)new ItemEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.chickenData.hasTrait == 1 ? new ItemStack((IItemProvider)initItems.FEATHER_DUCK.get()) : new ItemStack((IItemProvider)Items.field_151008_G)));
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.FAIL;
            }
            if (!((Boolean)ResourceChickens.CONFIGURATION.allowConvertingVanilla.get()).booleanValue()) {
                return ActionResultType.FAIL;
            }
            if (!this.chickenData.name.equals("chicken")) {
                return ActionResultType.FAIL;
            }
            for (Map.Entry<String, ChickenData> entry : initRegistry.DATA.entrySet()) {
                ChickenData chickenData = entry.getValue();
                boolean isMatched = ResourceChickens.getDropItem(chickenData.dropItemItem).func_77973_b() == itemStack.func_77973_b();
                if (!isMatched) continue;
                if (!playerIn.func_184812_l_()) {
                    itemStack.func_190918_g(1);
                }
                ((ServerWorld)playerIn.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197632_y, this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + 0.5, this.func_213303_ch().field_72449_c, 20, 0.5, 0.5, 0.5, 0.0);
                if (!chickenData.dropItemItem.equals(this.conversionType)) {
                    CompoundNBT nbt = new CompoundNBT();
                    this.func_70039_c(nbt);
                    nbt.func_82580_o("Mutation");
                    this.func_70020_e(nbt);
                    this.conversionCount = 1;
                    this.conversionRequired = chickenData.conversion;
                    this.conversionType = chickenData.dropItemItem;
                    this.conversionDescID = itemStack.func_77977_a();
                } else {
                    ++this.conversionCount;
                }
                if (this.conversionCount >= chickenData.conversion) {
                    this.func_70106_y();
                    playerIn.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    ((ServerWorld)playerIn.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + 0.5, this.func_213303_ch().field_72449_c, 100, 0.5, 0.5, 0.5, 0.0);
                    ResourceChickenEntity newChick = (ResourceChickenEntity)((EntityType)chickenData.entityType.get()).func_200721_a(playerIn.field_70170_p);
                    if (newChick != null) {
                        CompoundNBT nbt = this.func_189511_e(new CompoundNBT());
                        nbt.func_82580_o("Dimension");
                        nbt.func_82580_o("Mutation");
                        nbt.func_82580_o("UUID");
                        newChick.func_70020_e(nbt);
                        playerIn.field_70170_p.func_217376_c((Entity)newChick);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return super.func_230254_b_(playerIn, handIn);
    }
}

