/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.init;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.filefilter.FileFilterUtils;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.json.ChickenData;
import wallywhip.resourcechickens.json.Serializers;

public class initChickenConfigs {
    private static final Path MOD_ROOT = ModList.get().getModFileById("resourcechickens").getFile().getFilePath();

    public static void loadConfigs() {
        File dir = FMLPaths.CONFIGDIR.get().resolve("resourcechickens").toFile();
        if (!dir.exists() && dir.mkdir()) {
            initChickenConfigs.copyDefaultConfigs("/data/resourcechickens/configs/vanilla", Paths.get(dir.toString(), "vanilla"));
            initChickenConfigs.copyDefaultConfigs("/data/resourcechickens/configs/modded", Paths.get(dir.toString(), "modded"));
        }
        initChickenConfigs.loadChickenConfigs(dir.toString(), "vanilla");
        initChickenConfigs.loadChickenConfigs(dir.toString(), "modded");
        initChickenConfigs.loadChickenConfigs(dir.toString(), "custom");
    }

    private static void loadChickenConfigs(String root, String folder) {
        Path path = Paths.get(root, folder);
        File[] files = path.toFile().listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        Gson gson = Serializers.initGson();
        for (File file : files) {
            try {
                FileReader reader = new FileReader(file);
                ChickenData chickenData = (ChickenData)gson.fromJson((Reader)reader, ChickenData.class);
                reader.close();
                if (!chickenData.enabled) continue;
                String name = file.getName();
                chickenData.name = name = name.substring(0, name.length() - 5);
                initRegistry.registerChicken(name, chickenData);
                chickenData.chickenTexture = new ResourceLocation("resourcechickens:textures/entity/" + folder + "/" + name + ".png");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void copyDefaultConfigs(String dataPath, Path targetPath) {
        if (!Files.exists(targetPath, new LinkOption[0])) {
            targetPath.toFile().mkdir();
        }
        if (Files.isRegularFile(MOD_ROOT, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(MOD_ROOT, (ClassLoader)null);){
                Path path = fileSystem.getPath(dataPath, new String[0]);
                initChickenConfigs.copyFiles(path, targetPath);
            }
            catch (IOException e) {
                ResourceChickens.LOGGER.error("Could not load source {}!!", (Object)MOD_ROOT);
                e.printStackTrace();
            }
        } else if (Files.isDirectory(MOD_ROOT, new LinkOption[0])) {
            initChickenConfigs.copyFiles(Paths.get(MOD_ROOT.toString(), dataPath), targetPath);
        }
    }

    private static void copyFiles(Path sourcePath, Path targetPath) {
        try (Stream<Path> sourceStream = Files.walk(sourcePath, new FileVisitOption[0]);){
            sourceStream.filter(files -> files.getFileName().toString().endsWith(".json")).forEach(file -> {
                File targetFile = new File(Paths.get(targetPath.toString(), file.getFileName().toString()).toString());
                try {
                    Files.copy(file, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    ResourceChickens.LOGGER.error("Could not copy file: {}, Target: {}", file, (Object)targetPath);
                }
            });
        }
        catch (IOException e) {
            ResourceChickens.LOGGER.error("Could not stream source files: {}", (Object)sourcePath);
        }
    }
}

