/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.entity.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.json.ChickenData;

public class AnimalNet
extends Item {
    public AnimalNet() {
        super(new Item.Properties().func_200916_a(ResourceChickens.TAB).func_200918_c(16));
    }

    @Nonnull
    public ActionResultType func_111207_a(@Nonnull ItemStack itemStack, PlayerEntity playerIn, @Nonnull LivingEntity entityIn, @Nonnull Hand handIn) {
        if (playerIn.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("entityCaptured")) {
            return ActionResultType.CONSUME;
        }
        ChickenData chickenData = null;
        if (entityIn instanceof ResourceChickenEntity) {
            chickenData = ((ResourceChickenEntity)entityIn).chickenData;
            if (chickenData.name.equals("grave")) {
                return ActionResultType.CONSUME;
            }
            if (chickenData.name.equals("angry")) {
                return ActionResultType.CONSUME;
            }
        } else {
            if (entityIn.func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
                return ActionResultType.CONSUME;
            }
            if (entityIn instanceof PlayerEntity) {
                return ActionResultType.CONSUME;
            }
        }
        CompoundNBT compoundStack = itemStack.func_196082_o();
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("id", EntityType.func_200718_a((EntityType)entityIn.func_200600_R()).toString());
        entityIn.func_189511_e(compound);
        compound.func_82580_o("Motion");
        compound.func_82580_o("Rotation");
        compound.func_82580_o("Pos");
        compoundStack.func_74768_a("CustomModelData", 1);
        compoundStack.func_218657_a("entityCaptured", (INBT)compound);
        if (entityIn instanceof ResourceChickenEntity) {
            compoundStack.func_74778_a("entityDescription", chickenData.displayName.getString());
        } else {
            compoundStack.func_74778_a("entityDescription", entityIn.func_200200_C_().getString());
        }
        playerIn.func_184611_a(handIn, itemStack);
        playerIn.func_184810_cG();
        playerIn.field_70170_p.func_184133_a(null, playerIn.func_233580_cy_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 1.0f, 1.0f);
        entityIn.func_70106_y();
        return ActionResultType.SUCCESS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        Entity entity;
        if (context.func_195999_j() == null) {
            return ActionResultType.CONSUME;
        }
        if (context.func_195999_j().field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        CompoundNBT compound = context.func_195996_i().func_179543_a("entityCaptured");
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == initBlocks.NEST_BLOCK.get()) {
            NestTileEntity te = (NestTileEntity)context.func_195991_k().func_175625_s(context.func_195995_a());
            if (te == null) {
                return ActionResultType.CONSUME;
            }
            if (te.entityCaptured != null && compound == null) {
                context.func_195996_i().func_196082_o().func_74768_a("CustomModelData", 1);
                te.entityCaptured.func_74768_a("EggLayTime", te.eggLayTime);
                te.entityCaptured.func_74768_a("Age", te.chickenAge);
                context.func_195996_i().func_77978_p().func_218657_a("entityCaptured", (INBT)te.entityCaptured);
                context.func_195996_i().func_77978_p().func_74778_a("entityDescription", te.entityDescription.getString());
                te.entityRemove(true);
                context.func_195991_k().func_184133_a(null, context.func_195999_j().func_233580_cy_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                context.func_195999_j().func_184810_cG();
            } else {
                if (te.entityCaptured != null || compound == null) return ActionResultType.CONSUME;
                ChickenData chickenData = initRegistry.getChickenDataFromLongID(compound.func_74779_i("id"));
                if (chickenData == null) return ActionResultType.CONSUME;
                te.entitySet(compound, context.func_195996_i().func_196082_o().func_74779_i("entityDescription"), true);
                context.func_195991_k().func_184133_a(null, context.func_195999_j().func_233580_cy_(), context.func_195991_k().field_73012_v.nextBoolean() ? SoundEvents.field_187665_Y : (chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.field_187660_W), SoundCategory.BLOCKS, 1.0f, 1.0f);
                context.func_195996_i().func_196083_e("entityCaptured");
                context.func_195996_i().func_196083_e("entityDescription");
                context.func_195996_i().func_196083_e("CustomModelData");
                context.func_195996_i().func_222118_a(1, (LivingEntity)context.func_195999_j(), player -> player.func_213334_d(context.func_221531_n()));
            }
            ((ServerWorld)context.func_195991_k()).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, ((BlockItem)initItems.NEST_BLOCK_ITEM.get()).func_179223_d().func_176223_P()), (double)context.func_195995_a().func_177958_n() + 0.5, (double)context.func_195995_a().func_177956_o() + 0.2, (double)context.func_195995_a().func_177952_p() + 0.5, 20, 0.3, 0.2, 0.3, 0.0);
            return ActionResultType.SUCCESS;
        }
        if (compound == null) {
            return ActionResultType.CONSUME;
        }
        EntityType et = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(compound.func_74779_i("id")));
        if (et == null || (entity = et.func_200721_a(context.func_195991_k())) == null) return ActionResultType.FAIL;
        BlockPos pos = context.func_195995_a().func_177971_a(context.func_196000_l().func_176730_m());
        int yPos = pos.func_177956_o();
        if (context.func_196000_l() != Direction.UP) {
            yPos = (int)((double)yPos + 0.5);
        }
        entity.func_70020_e(compound);
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)yPos, (double)pos.func_177952_p() + 0.5);
        context.func_195991_k().func_217376_c(entity);
        context.func_195996_i().func_196083_e("entityCaptured");
        context.func_195996_i().func_196083_e("entityDescription");
        context.func_195996_i().func_196083_e("CustomModelData");
        context.func_195991_k().func_184133_a(null, context.func_195999_j().func_233580_cy_(), SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, 1.0f);
        context.func_195996_i().func_222118_a(1, (LivingEntity)context.func_195999_j(), player -> player.func_213334_d(context.func_221531_n()));
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, worldIn, tooltip, tooltipFlag);
        CompoundNBT compound = itemStack.func_179543_a("entityCaptured");
        if (compound != null) {
            IFormattableTextComponent name;
            tooltip.add((ITextComponent)new StringTextComponent(itemStack.func_196082_o().func_74779_i("entityDescription")));
            if (compound.func_150297_b("CustomName", 8) && (name = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"))) != null) {
                tooltip.add((ITextComponent)name.func_240699_a_(TextFormatting.ITALIC));
            }
            if (compound.func_74767_n("analyzed")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tip.crimsonchickens.growth", new Object[]{compound.func_74762_e("growth")}).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new TranslationTextComponent("tip.crimsonchickens.gain", new Object[]{compound.func_74762_e("gain")}).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new TranslationTextComponent("tip.crimsonchickens.strength", new Object[]{compound.func_74762_e("strength")}).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }
}

