/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.EggItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import wallywhip.resourcechickens.ResourceChickens;

public class LiquidEgg
extends EggItem {
    private final Fluid fluidType;

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        FluidHandlerItemStack fluidHandlerItemStack = new FluidHandlerItemStack(stack, 1000){

            @Nonnull
            public ItemStack getContainer() {
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public FluidStack getFluid() {
                return new FluidStack(LiquidEgg.this.fluidType, 1000);
            }

            public int getTanks() {
                return 1;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return false;
            }

            public boolean canFillFluidType(FluidStack fluid) {
                return false;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (maxDrain < 1000) {
                    return FluidStack.EMPTY;
                }
                return super.drain(maxDrain, action);
            }
        };
        fluidHandlerItemStack.fill(new FluidStack(this.fluidType, 1000), IFluidHandler.FluidAction.EXECUTE);
        return fluidHandlerItemStack;
    }

    public LiquidEgg(Fluid p_i49025_1_) {
        super(new Item.Properties().func_200916_a(ResourceChickens.TAB).func_200917_a(16));
        this.fluidType = p_i49025_1_;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BlockPos blockPos2;
        BlockRayTraceResult rayTraceResult;
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)itemStack, (RayTraceResult)(rayTraceResult = LiquidEgg.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE)));
        if (ret != null) {
            return ret;
        }
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        BlockPos blockPos = rayTraceResult.func_216350_a();
        Direction direction = rayTraceResult.func_216354_b();
        BlockPos blockPos1 = blockPos.func_177972_a(direction);
        BlockState blockState = worldIn.func_180495_p(blockPos);
        BlockPos blockPos3 = blockPos2 = this.canBlockContainFluid(worldIn, blockPos, blockState) ? blockPos : blockPos1;
        if (worldIn.func_230315_m_().func_236040_e_() && this.fluidType.func_207185_a((ITag)FluidTags.field_206959_a)) {
            worldIn.func_184133_a(playerIn, blockPos2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            for (int a = 0; a < 8; ++a) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)blockPos2.func_177958_n() + Math.random(), (double)blockPos2.func_177956_o() + Math.random(), (double)blockPos2.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_233538_a_((Object)itemStack, (boolean)worldIn.func_201670_d());
        }
        if (worldIn.func_175656_a(blockPos2, this.fluidType.func_207188_f().func_206883_i())) {
            if (playerIn instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockPos2, itemStack);
            }
            this.playEmptySound(playerIn, (IWorld)worldIn, blockPos2);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_233538_a_((Object)itemStack, (boolean)worldIn.func_201670_d());
        }
        return ActionResult.func_226251_d_((Object)itemStack);
    }

    private boolean canBlockContainFluid(World worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, this.fluidType);
    }

    protected void playEmptySound(@Nullable PlayerEntity p_203791_1_, IWorld p_203791_2_, BlockPos p_203791_3_) {
        SoundEvent emptySound = this.fluidType.getAttributes().getEmptySound();
        if (emptySound == null) {
            emptySound = this.fluidType.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        p_203791_2_.func_184133_a(p_203791_1_, p_203791_3_, emptySound, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

