/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.entity.EntityClassification;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.text.StringTextComponent;
import wallywhip.resourcechickens.json.BaseSerializer;
import wallywhip.resourcechickens.json.ChickenData;

public class Serializers {
    public static final BaseSerializer<ChickenData> DATA = new BaseSerializer<ChickenData>(){

        @Override
        public ChickenData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            ChickenData mt = new ChickenData();
            mt.displayName = new StringTextComponent(obj.get("displayName").getAsString());
            mt.eggLayTime = obj.get("eggLayTime").getAsInt();
            mt.canBreed = obj.get("canBreed").getAsBoolean();
            mt.dropItemItem = obj.get("dropItem").getAsString();
            String st = obj.get("dropItemNBT").getAsString();
            if (st.length() != 0) {
                try {
                    mt.dropItemNBT = new JsonToNBT(new StringReader(st)).func_193593_f();
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            mt.baseHealth = obj.get("baseHealth").getAsDouble();
            mt.baseSpeed = obj.get("baseSpeed").getAsDouble();
            mt.isFireImmune = obj.get("isFireImmune").getAsBoolean();
            mt.conversion = obj.get("conversion").getAsInt();
            mt.eggPrimaryColor = obj.get("eggColorForeground").getAsInt();
            mt.eggSecondaryColor = obj.get("eggColorBackground").getAsInt();
            mt.hasTrait = obj.get("hasTrait").getAsInt();
            JsonArray element = obj.getAsJsonArray("biomesWhitelist");
            if (element != null && element.size() != 0) {
                mt.biomesWhitelist = element;
            }
            if ((element = obj.getAsJsonArray("biomesBlacklist")) != null && element.size() != 0) {
                mt.biomesBlacklist = element;
            }
            mt.spawnNaturally = obj.get("spawnNaturally").getAsBoolean();
            mt.spawnType = EntityClassification.values()[obj.get("spawnType").getAsInt()];
            mt.spawnWeight = obj.get("spawnWeight").getAsInt();
            mt.spawnLight = obj.get("spawnLight").getAsInt();
            element = obj.getAsJsonArray("spawnBlocks");
            if (element != null) {
                mt.spawnBlocks = element;
            }
            mt.parentA = obj.get("parentA").getAsString();
            mt.parentB = obj.get("parentB").getAsString();
            mt.enabled = obj.get("enabled").getAsBoolean();
            return mt;
        }

        @Override
        public JsonElement serialize(ChickenData src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("displayName", src.displayName.getString());
            obj.addProperty("dropItem", src.dropItemItem);
            obj.addProperty("dropItemNBT", src.dropItemNBT == null ? "" : src.dropItemNBT.toString());
            obj.addProperty("eggLayTime", (Number)src.eggLayTime);
            obj.addProperty("canBreed", Boolean.valueOf(src.canBreed));
            obj.addProperty("baseHealth", (Number)src.baseHealth);
            obj.addProperty("baseSpeed", (Number)src.baseSpeed);
            obj.addProperty("isFireImmune", Boolean.valueOf(src.isFireImmune));
            obj.addProperty("conversion", (Number)src.conversion);
            obj.addProperty("eggColorForeground", (Number)src.eggPrimaryColor);
            obj.addProperty("eggColorBackground", (Number)src.eggSecondaryColor);
            obj.addProperty("hasTrait", (Number)src.hasTrait);
            if (src.biomesWhitelist != null) {
                obj.add("biomesWhitelist", (JsonElement)src.biomesWhitelist);
            }
            if (src.biomesBlacklist != null) {
                obj.add("biomesBlacklist", (JsonElement)src.biomesBlacklist);
            }
            obj.addProperty("spawnNaturally", Boolean.valueOf(src.spawnNaturally));
            obj.addProperty("spawnWeight", (Number)src.spawnWeight);
            obj.addProperty("spawnType", (Number)src.spawnType.ordinal());
            obj.addProperty("spawnLight", (Number)src.spawnLight);
            if (src.spawnBlocks != null) {
                obj.add("spawnBlocks", (JsonElement)src.spawnBlocks);
            }
            obj.addProperty("parentA", src.parentA);
            obj.addProperty("parentB", src.parentB);
            obj.addProperty("enabled", Boolean.valueOf(src.enabled));
            return obj;
        }

        @Override
        public Type getType() {
            return ChickenData.class;
        }
    };

    public static Gson initGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.setPrettyPrinting();
        gson.serializeNulls();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(DATA.getType(), DATA);
        return gson.create();
    }
}

