/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import wallywhip.resourcechickens.compat.TOP.compatTOP;
import wallywhip.resourcechickens.entity.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initChickenConfigs;
import wallywhip.resourcechickens.init.initConfigs;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.json.ChickenData;

@Mod(value="resourcechickens")
public class ResourceChickens {
    public static final String MOD_ID = "resourcechickens";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final initConfigs CONFIGURATION = new initConfigs();
    private static final ResourceLocation FOOLISH_LOC = new ResourceLocation("resourcechickens:textures/entity/vanilla/chicken_fool.png");
    private static final ResourceLocation[] FESTIVE_LOC = new ResourceLocation[]{new ResourceLocation("resourcechickens:textures/entity/vanilla/chicken_fest1.png"), new ResourceLocation("resourcechickens:textures/entity/vanilla/chicken_fest2.png")};
    public static boolean isFestive = false;
    public static boolean isFoolish = false;
    public static final CreativeModeTab TAB = new CreativeModeTab("resourcechickens"){

        @OnlyIn(value=Dist.CLIENT)
        @NotNull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Items.f_42552_);
        }
    };

    public ResourceChickens() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ResourceChickens.CONFIGURATION.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ResourceChickens.CONFIGURATION.CLIENT);
        IEventBus MOD_EVENTBUS = FMLJavaModLoadingContext.get().getModEventBus();
        initSounds.SOUNDS.register(MOD_EVENTBUS);
        initItems.ITEMS.register(MOD_EVENTBUS);
        initBlocks.BLOCKS.register(MOD_EVENTBUS);
        initTiles.TILES.register(MOD_EVENTBUS);
        initRegistry.ENTITY_TYPES.register(MOD_EVENTBUS);
        initChickenConfigs.loadConfigs();
        MOD_EVENTBUS.addListener(this::onInterModEnqueueEvent);
        MOD_EVENTBUS.addListener(this::onModConfigEvent);
        MOD_EVENTBUS.addListener(initRegistry::onEntityAttributeCreationEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoadingEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getModId().equals(MOD_ID) && event.getConfig().getType() == ModConfig.Type.CLIENT) {
            if (((Boolean)ResourceChickens.CONFIGURATION.allowEventTextures.get()).booleanValue()) {
                LocalDate date = LocalDate.now();
                int dd = date.getDayOfMonth();
                int mm = date.getMonthValue();
                isFestive = dd > 20 && mm == 12;
                isFoolish = dd == 1 && mm == 4;
            } else {
                isFoolish = false;
                isFestive = false;
            }
        }
    }

    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (event.getName() != null) {
            String biomeString = event.getName().toString();
            initRegistry.DATA.forEach((id, chickenData) -> {
                if (chickenData.spawnNaturally) {
                    if (chickenData.biomesWhitelist != null && !chickenData.biomesWhitelist.isEmpty()) {
                        for (JsonElement w : chickenData.biomesWhitelist) {
                            if (!w.getAsString().equals(biomeString)) continue;
                            event.getSpawns().getSpawner(chickenData.spawnType).add(new MobSpawnSettings.SpawnerData((EntityType)chickenData.entityType.get(), chickenData.spawnWeight, 1, 2));
                            break;
                        }
                    } else if (chickenData.biomesBlacklist != null && !chickenData.biomesBlacklist.isEmpty()) {
                        for (JsonElement b : chickenData.biomesBlacklist) {
                            if (!b.getAsString().equals(biomeString)) continue;
                            event.getSpawns().getSpawner(chickenData.spawnType).add(new MobSpawnSettings.SpawnerData((EntityType)chickenData.entityType.get(), chickenData.spawnWeight, 1, 2));
                            break;
                        }
                    } else {
                        List spawns = event.getSpawns().getSpawner(MobCategory.CREATURE);
                        if (spawns.stream().anyMatch(spawn -> spawn.f_48404_ == EntityType.f_20555_)) {
                            spawns.add(new MobSpawnSettings.SpawnerData((EntityType)chickenData.entityType.get(), chickenData.spawnWeight, 1, 2));
                        }
                    }
                }
            });
        }
        List spawns = event.getSpawns().getSpawner(MobCategory.CREATURE);
        spawns.removeIf(spawn -> spawn.f_48404_ == EntityType.f_20555_);
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        ChickenData chickenData;
        if (event.getEntity() instanceof ResourceChickenEntity) {
            return;
        }
        if (event.getEntity().m_6095_() == EntityType.f_20555_ && (chickenData = initRegistry.DATA.get("chicken")) != null && chickenData.enabled) {
            event.setCanceled(true);
            ResourceChickenEntity newChicken = (ResourceChickenEntity)((EntityType)chickenData.entityType.get()).m_20615_(event.getWorld());
            if (newChicken != null) {
                CompoundTag compound = event.getEntity().m_20240_(new CompoundTag());
                compound.m_128379_("analyzed", true);
                compound.m_128405_("growth", 1);
                compound.m_128405_("gain", 1);
                compound.m_128405_("strength", 1);
                newChicken.m_20258_(compound);
                event.getWorld().m_7967_((Entity)newChicken);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        ResourceChickenEntity newChicken;
        if (!event.getEntity().f_19853_.f_46443_ && event.getEntity() instanceof Player && initRegistry.DATA.containsKey("grave") && (newChicken = (ResourceChickenEntity)((EntityType)initRegistry.DATA.get((Object)"grave").entityType.get()).m_20615_(event.getEntity().f_19853_)) != null) {
            Player playerIn = (Player)event.getEntity();
            newChicken.m_6593_((Component)playerIn.m_5446_().m_6881_().m_130946_(": Death #").m_130946_("" + ((ServerPlayer)playerIn).m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_))));
            newChicken.m_20359_(event.getEntity());
            newChicken.m_21530_();
            newChicken.getPersistentData().m_128365_("Inventory", (Tag)playerIn.m_150109_().m_36026_(new ListTag()));
            event.getEntity().f_19853_.m_7967_((Entity)newChicken);
            playerIn.m_150109_().f_35974_.clear();
            playerIn.m_150109_().f_35975_.clear();
            playerIn.m_150109_().f_35976_.clear();
        }
    }

    private void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            compatTOP.register();
        }
    }

    public static int calcNewEggLayTime(Random r, ChickenData chickenData, int growth) {
        if (chickenData.eggLayTime == 0) {
            return 0;
        }
        int egg = r.nextInt(chickenData.eggLayTime) + chickenData.eggLayTime;
        return (int)Math.max(1.0f, (float)egg * (10.0f - (float)growth + 1.0f) / 10.0f);
    }

    public static int calcDropQuantity(int gain) {
        if (gain < 5) {
            return 1;
        }
        if (gain < 10) {
            return 2;
        }
        return 3;
    }

    public static List<ItemStack> calcDrops(int gain, ChickenData chickenData, int fortune) {
        Random r;
        ItemStack itemStack;
        ArrayList<ItemStack> lst = new ArrayList<ItemStack>();
        if (!chickenData.dropItemItem.equals("") && !(itemStack = ResourceChickens.getDropItem(chickenData.dropItemItem)).m_41619_()) {
            if (chickenData.dropItemNBT != null) {
                itemStack.m_41751_(chickenData.dropItemNBT.m_6426_());
            }
            int dropQuantity = ResourceChickens.calcDropQuantity(gain) + fortune;
            if (itemStack.m_41753_()) {
                itemStack.m_41764_(dropQuantity);
                lst.add(itemStack);
            } else {
                for (int a = 0; a < dropQuantity; ++a) {
                    ItemStack itm = itemStack.m_41777_();
                    lst.add(itm);
                }
            }
        }
        if ((r = new Random()).nextInt(8) == 0) {
            lst.add(chickenData.hasTrait == 1 ? new ItemStack((ItemLike)initItems.FEATHER_DUCK.get()) : new ItemStack((ItemLike)Items.f_42402_));
        }
        return lst;
    }

    public static String formatTime(int milli) {
        int secs = milli / 20;
        int mins = secs / 60;
        int hours = mins / 60;
        if (hours == 0) {
            return String.format("%02d:%02d", mins, secs % 60);
        }
        return String.format("%02d:%02d:%02d", hours, mins, secs % 60);
    }

    public static ItemStack getDropItem(String dropItem) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (dropItem.startsWith("items:")) {
            Iterator tag = Registry.f_122827_.m_206058_(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(dropItem.substring(6)))).iterator();
            if (tag.hasNext()) {
                itemStack = new ItemStack((ItemLike)((Holder)tag.next()).m_203334_());
            }
        } else {
            itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(dropItem)));
        }
        return itemStack;
    }

    public static ResourceLocation getTexture(ResourceChickenEntity entityIn) {
        if (isFestive && entityIn.chickenData.name.equals("chicken")) {
            long l = entityIn.m_142081_().getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && entityIn.chickenData.name.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return entityIn.chickenData.chickenTexture;
    }

    public static ResourceLocation getTexture(ChickenData chickenData, UUID uuid) {
        if (isFestive && chickenData.name.equals("chicken")) {
            long l = uuid.getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && chickenData.name.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return chickenData.chickenTexture;
    }
}

