/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.compat.TOP.ITOPInfoProvider;
import wallywhip.resourcechickens.init.initTiles;

public class Nest
extends BaseEntityBlock
implements ITOPInfoProvider {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape NEST_SHAPE = Stream.of(Block.m_49796_((double)12.0, (double)2.1, (double)5.0, (double)13.0, (double)3.1, (double)7.0), Block.m_49796_((double)5.0, (double)0.1, (double)5.0, (double)11.0, (double)1.1, (double)11.0), Block.m_49796_((double)12.0, (double)1.1, (double)7.0, (double)13.0, (double)2.1, (double)9.0), Block.m_49796_((double)3.0, (double)1.1, (double)7.0, (double)4.0, (double)2.1, (double)9.0), Block.m_49796_((double)4.0, (double)0.1, (double)7.0, (double)5.0, (double)1.1, (double)9.0), Block.m_49796_((double)11.0, (double)0.1, (double)7.0, (double)12.0, (double)1.1, (double)9.0), Block.m_49796_((double)7.0, (double)1.1, (double)3.0, (double)9.0, (double)2.1, (double)4.0), Block.m_49796_((double)7.0, (double)0.1, (double)4.0, (double)9.0, (double)1.1, (double)5.0), Block.m_49796_((double)7.0, (double)0.1, (double)11.0, (double)9.0, (double)1.1, (double)12.0), Block.m_49796_((double)7.0, (double)1.1, (double)12.0, (double)9.0, (double)2.1, (double)13.0), Block.m_49796_((double)4.0, (double)1.1, (double)9.0, (double)5.0, (double)2.1, (double)11.0), Block.m_49796_((double)11.0, (double)1.1, (double)9.0, (double)12.0, (double)2.1, (double)11.0), Block.m_49796_((double)11.0, (double)2.1, (double)11.0, (double)12.0, (double)3.1, (double)12.0), Block.m_49796_((double)11.0, (double)2.1, (double)4.0, (double)12.0, (double)3.1, (double)5.0), Block.m_49796_((double)4.0, (double)2.1, (double)4.0, (double)5.0, (double)3.1, (double)5.0), Block.m_49796_((double)4.0, (double)2.1, (double)11.0, (double)5.0, (double)3.1, (double)12.0), Block.m_49796_((double)11.0, (double)1.1, (double)5.0, (double)12.0, (double)2.1, (double)7.0), Block.m_49796_((double)4.0, (double)1.1, (double)5.0, (double)5.0, (double)2.1, (double)7.0), Block.m_49796_((double)13.0, (double)2.1, (double)7.0, (double)14.0, (double)3.1, (double)9.0), Block.m_49796_((double)2.0, (double)2.1, (double)7.0, (double)3.0, (double)3.1, (double)9.0), Block.m_49796_((double)7.0, (double)2.1, (double)2.0, (double)9.0, (double)3.1, (double)3.0), Block.m_49796_((double)7.0, (double)2.1, (double)13.0, (double)9.0, (double)3.1, (double)14.0), Block.m_49796_((double)12.0, (double)2.1, (double)9.0, (double)13.0, (double)3.1, (double)11.0), Block.m_49796_((double)9.0, (double)2.1, (double)12.0, (double)11.0, (double)3.1, (double)13.0), Block.m_49796_((double)5.0, (double)2.1, (double)12.0, (double)7.0, (double)3.1, (double)13.0), Block.m_49796_((double)5.0, (double)1.1, (double)11.0, (double)7.0, (double)2.1, (double)12.0), Block.m_49796_((double)5.0, (double)1.1, (double)4.0, (double)7.0, (double)2.1, (double)5.0), Block.m_49796_((double)9.0, (double)1.1, (double)4.0, (double)11.0, (double)2.1, (double)5.0), Block.m_49796_((double)9.0, (double)1.1, (double)11.0, (double)11.0, (double)2.1, (double)12.0), Block.m_49796_((double)3.0, (double)2.1, (double)9.0, (double)4.0, (double)3.1, (double)11.0), Block.m_49796_((double)3.0, (double)2.1, (double)5.0, (double)4.0, (double)3.1, (double)7.0), Block.m_49796_((double)5.0, (double)2.1, (double)3.0, (double)7.0, (double)3.1, (double)4.0), Block.m_49796_((double)9.0, (double)2.1, (double)3.0, (double)11.0, (double)3.1, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public Nest() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76315_, (MaterialColor)MaterialColor.f_76416_).m_60978_(0.5f).m_60918_(SoundType.f_56740_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return NEST_SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : Nest.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)initTiles.NEST_BLOCK_TILE.get()), NestTileEntity::serverTick);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new NestTileEntity(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (world.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
            if (tile.storedItems.isItemValid(0, itemStack)) {
                int transferred = tile.storedItems.getStackInSlot(0).m_41613_();
                ItemStack returned = ItemHandlerHelper.insertItem((IItemHandler)tile.storedItems, (ItemStack)itemStack.m_41777_(), (boolean)false);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, returned);
                }
                if (transferred != tile.storedItems.getStackInSlot(0).m_41613_() && tile.entityCaptured != null) {
                    for (int a = 0; a < 4; ++a) {
                        double d0 = this.RANDOM.nextGaussian() * 0.2;
                        double d1 = this.RANDOM.nextGaussian() * 0.2;
                        double d2 = this.RANDOM.nextGaussian() * 0.2;
                        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, d0, d1, d2, 0.0);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41720_() instanceof NameTagItem) {
                tile.entitySetCustomName(itemStack.m_41737_("display"));
                tile.sendRenderUpdates();
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hitResult);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean notify) {
        BlockEntity blockEntity;
        if (pos.m_7495_().equals((Object)fromPos) && (blockEntity = world.m_7702_(pos)) instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            tile.updateCachedOutputItemHandler();
        }
    }

    public void m_6810_(BlockState state, @NotNull Level world, @NotNull BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof NestTileEntity) {
                Entity entity;
                EntityType et;
                NestTileEntity tile = (NestTileEntity)blockEntity;
                tile.storedItems.getStacks().forEach(item -> Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)item));
                if (tile.entityCaptured != null && (et = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tile.entityCaptured.m_128461_("id")))) != null && (entity = et.m_20615_(world)) != null) {
                    entity.m_20258_(tile.entityCaptured);
                    entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                    world.m_7967_(entity);
                    world.m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player playerEntity, Level world, BlockState blockState, IProbeHitData iProbeHitData) {
        BlockEntity blockEntity = world.m_7702_(iProbeHitData.getPos());
        if (blockEntity instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            if (tile.entityCaptured != null) {
                iProbeInfo.text((Component)new TextComponent(tile.entityDescription));
                if (tile.entityCustomName != null) {
                    iProbeInfo.text(tile.entityCustomName);
                }
                if (tile.entityCaptured.m_128471_("analyzed")) {
                    iProbeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.growth", new Object[]{tile.chickenGrowth}));
                    iProbeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.gain", new Object[]{tile.chickenGain}));
                    iProbeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.strength", new Object[]{tile.chickenStrength}));
                }
                if (tile.chickenData.eggLayTime != 0) {
                    if (tile.chickenAge < 0) {
                        iProbeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.growing", new Object[]{ResourceChickens.formatTime(-tile.chickenAge)}));
                    } else if (tile.storedItems.getStackInSlot(0).m_41619_()) {
                        iProbeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text((Component)new TranslatableComponent("tip.resourcechickens.seeds")));
                    } else {
                        iProbeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.egg", new Object[]{ResourceChickens.formatTime(tile.eggLayTime)}));
                    }
                } else {
                    iProbeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text((Component)new TranslatableComponent("tip.resourcechickens.nodrop")));
                }
            }
        }
    }
}

