/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class NestItemStackHandler
extends ItemStackHandler {
    public NestItemStackHandler(int slots) {
        this.setSize(slots);
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public boolean isEmpty() {
        return this.stacks.stream().allMatch(ItemStack::m_41619_);
    }

    @Nonnull
    public ItemStack insertItemDrop(@Nonnull ItemStack stack) {
        for (int slot = 1; slot < this.getSlots() && (stack = this.insertItemDrop(slot, stack, false)) != ItemStack.f_41583_; ++slot) {
        }
        return stack;
    }

    @Nonnull
    public ItemStack insertItemDrop(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }
}

