/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.Nest;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.entity.NestChickenModel;
import wallywhip.resourcechickens.entity.ResourceChickenEntity;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class NestRenderer
implements BlockEntityRenderer<NestTileEntity> {
    private static final NestChickenModel<ResourceChickenEntity> chickenModel = new NestChickenModel(NestChickenModel.createBodyLayer().m_171564_());
    private static final Minecraft mc = Minecraft.m_91087_();

    public NestRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(NestTileEntity tileEntity, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = (Direction)tileEntity.m_58900_().m_61143_((Property)Nest.FACING);
        if (tileEntity.entityCaptured != null) {
            RenderType renderType = chickenModel.m_103119_(tileEntity.chickenTexture);
            VertexConsumer vertexBuilder = buffer.m_6299_(renderType);
            NestRenderer.chickenModel.f_102610_ = tileEntity.chickenAge < 0;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, NestRenderer.chickenModel.f_102610_ ? (double)1.4f : (double)1.32f, 0.5);
            matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(direction.m_122435_()));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            chickenModel.m_7695_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            vertexBuilder.m_5752_();
            if (((Boolean)ResourceChickens.CONFIGURATION.renderLabels.get()).booleanValue() && tileEntity.entityCustomName != null && NestRenderer.mc.f_91063_.m_109153_().m_90583_().m_82531_((double)tileEntity.m_58899_().m_123341_(), (double)tileEntity.m_58899_().m_123342_(), (double)tileEntity.m_58899_().m_123343_()) < 64.0) {
                NestRenderer.renderLabel(matrixStack, buffer, combinedLight, tileEntity.entityCustomName);
            }
        }
        if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue() && NestRenderer.mc.f_91063_.m_109153_().m_90583_().m_82531_((double)tileEntity.m_58899_().m_123341_(), (double)tileEntity.m_58899_().m_123342_(), (double)tileEntity.m_58899_().m_123343_()) < 64.0) {
            for (int a = 0; a < 4; ++a) {
                if (tileEntity.storedItems.getStackInSlot(a).m_41619_()) continue;
                NestRenderer.renderItem(tileEntity.storedItems.getStackInSlot(a), NestRenderer.getTranslation(a, direction), Vector3f.f_122225_.m_122240_(180.0f + direction.m_122435_()), matrixStack, buffer, combinedOverlay, combinedLight);
            }
        }
    }

    private static void renderLabel(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, Component text) {
        Font fontRenderer = NestRenderer.mc.f_91062_;
        matrixStack.m_85836_();
        float scale = 0.02f;
        int opacity = 0x66000000;
        float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        matrixStack.m_85837_(0.5, 1.0, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(mc.m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        fontRenderer.m_92841_(text, offset, 0.0f, 0, false, matrix4f, buffer, true, opacity, lightLevel);
        fontRenderer.m_92841_(text, offset, 0.0f, -1, false, matrix4f, buffer, false, 0, lightLevel);
        matrixStack.m_85849_();
    }

    private static void renderItem(ItemStack stack, double[] translation, Quaternion rotation, PoseStack matrixStack, MultiBufferSource buffer, int combinedOverlay, int lightLevel) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(translation[0], translation[1], translation[2]);
        matrixStack.m_85845_(rotation);
        matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
        BakedModel bakedModel = mc.m_91291_().m_174264_(stack, null, null, 0);
        mc.m_91291_().m_115143_(stack, ItemTransforms.TransformType.GROUND, true, matrixStack, buffer, lightLevel, combinedOverlay, bakedModel);
        matrixStack.m_85849_();
    }

    private static double[] getTranslation(int index, Direction direction) {
        double[] dArray;
        block0 : switch (direction) {
            default: {
                switch (index) {
                    case 0: {
                        double[] dArray2 = new double[3];
                        dArray2[0] = 0.25;
                        dArray2[1] = 0.15;
                        dArray = dArray2;
                        dArray2[2] = 0.25;
                        break block0;
                    }
                    case 1: {
                        double[] dArray3 = new double[3];
                        dArray3[0] = 0.75;
                        dArray3[1] = 0.15;
                        dArray = dArray3;
                        dArray3[2] = 0.25;
                        break block0;
                    }
                    case 2: {
                        double[] dArray4 = new double[3];
                        dArray4[0] = 0.75;
                        dArray4[1] = 0.15;
                        dArray = dArray4;
                        dArray4[2] = 0.75;
                        break block0;
                    }
                }
                double[] dArray5 = new double[3];
                dArray5[0] = 0.25;
                dArray5[1] = 0.15;
                dArray = dArray5;
                dArray5[2] = 0.75;
                break;
            }
            case SOUTH: {
                switch (index) {
                    case 0: {
                        double[] dArray6 = new double[3];
                        dArray6[0] = 0.75;
                        dArray6[1] = 0.15;
                        dArray = dArray6;
                        dArray6[2] = 0.75;
                        break block0;
                    }
                    case 1: {
                        double[] dArray7 = new double[3];
                        dArray7[0] = 0.25;
                        dArray7[1] = 0.15;
                        dArray = dArray7;
                        dArray7[2] = 0.75;
                        break block0;
                    }
                    case 2: {
                        double[] dArray8 = new double[3];
                        dArray8[0] = 0.25;
                        dArray8[1] = 0.15;
                        dArray = dArray8;
                        dArray8[2] = 0.25;
                        break block0;
                    }
                }
                double[] dArray9 = new double[3];
                dArray9[0] = 0.75;
                dArray9[1] = 0.15;
                dArray = dArray9;
                dArray9[2] = 0.25;
                break;
            }
            case WEST: {
                switch (index) {
                    case 0: {
                        double[] dArray10 = new double[3];
                        dArray10[0] = 0.25;
                        dArray10[1] = 0.15;
                        dArray = dArray10;
                        dArray10[2] = 0.75;
                        break block0;
                    }
                    case 1: {
                        double[] dArray11 = new double[3];
                        dArray11[0] = 0.25;
                        dArray11[1] = 0.15;
                        dArray = dArray11;
                        dArray11[2] = 0.25;
                        break block0;
                    }
                    case 2: {
                        double[] dArray12 = new double[3];
                        dArray12[0] = 0.75;
                        dArray12[1] = 0.15;
                        dArray = dArray12;
                        dArray12[2] = 0.25;
                        break block0;
                    }
                }
                double[] dArray13 = new double[3];
                dArray13[0] = 0.75;
                dArray13[1] = 0.15;
                dArray = dArray13;
                dArray13[2] = 0.75;
                break;
            }
            case EAST: {
                switch (index) {
                    case 0: {
                        double[] dArray14 = new double[3];
                        dArray14[0] = 0.75;
                        dArray14[1] = 0.15;
                        dArray = dArray14;
                        dArray14[2] = 0.25;
                        break block0;
                    }
                    case 1: {
                        double[] dArray15 = new double[3];
                        dArray15[0] = 0.75;
                        dArray15[1] = 0.15;
                        dArray = dArray15;
                        dArray15[2] = 0.75;
                        break block0;
                    }
                    case 2: {
                        double[] dArray16 = new double[3];
                        dArray16[0] = 0.25;
                        dArray16[1] = 0.15;
                        dArray = dArray16;
                        dArray16[2] = 0.75;
                        break block0;
                    }
                }
                double[] dArray17 = new double[3];
                dArray17[0] = 0.25;
                dArray17[1] = 0.15;
                dArray = dArray17;
                dArray17[2] = 0.25;
            }
        }
        return dArray;
    }
}

