/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestItemStackHandler;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.json.ChickenData;

public class NestTileEntity
extends BlockEntity
implements EntityBlock {
    public NestItemStackHandler storedItems = new NestItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            NestTileEntity.this.m_6596_();
            if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue()) {
                NestTileEntity.this.sendRenderUpdates();
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return Chicken.f_28233_.test(stack);
            }
            return false;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> this.storedItems);
    private LazyOptional<IItemHandler> outputItemHandlerCached = null;
    public ChickenData chickenData = null;
    public CompoundTag entityCaptured = null;
    public String entityDescription = "";
    public Component entityCustomName = null;
    public ResourceLocation chickenTexture = null;
    public int eggLayTime;
    public int chickenAge;
    public int chickenGrowth;
    public int chickenGain;
    public int chickenStrength;

    public NestTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)initTiles.NEST_BLOCK_TILE.get(), pos, state);
    }

    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new NestTileEntity(blockPos, blockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        this.inventory.invalidate();
        super.m_7651_();
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.m_183515_(compound);
        return compound;
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Inventory")) {
            this.storedItems.setSize(4);
            this.storedItems.deserializeNBT(compound.m_128469_("Inventory"));
        }
        if (compound.m_128441_("entityCaptured")) {
            this.entitySet(compound.m_128469_("entityCaptured"), compound.m_128461_("entityDescription"), false);
        } else {
            this.entityRemove(false);
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.storedItems.serializeNBT());
        if (this.entityCaptured != null) {
            this.entityCaptured.m_128405_("EggLayTime", this.eggLayTime);
            this.entityCaptured.m_128405_("Age", this.chickenAge);
            compound.m_128365_("entityCaptured", (Tag)this.entityCaptured);
            compound.m_128359_("entityDescription", this.entityDescription);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void entityRemove(boolean sendUpdates) {
        this.chickenAge = 0;
        this.chickenGrowth = 0;
        this.chickenGain = 0;
        this.chickenStrength = 0;
        this.eggLayTime = 0;
        this.chickenData = null;
        this.entityCaptured = null;
        this.entityDescription = "";
        this.entityCustomName = null;
        if (sendUpdates) {
            this.sendRenderUpdates();
        }
        this.m_6596_();
    }

    public void entitySet(CompoundTag compound, String desc, boolean sendUpdates) {
        MutableComponent name;
        this.entityCaptured = compound.m_6426_();
        this.entityDescription = desc;
        this.chickenData = initRegistry.getChickenDataFromLongID(compound.m_128461_("id"));
        this.chickenTexture = ResourceChickens.getTexture(this.chickenData, compound.m_128342_("UUID"));
        if (compound.m_128441_("CustomName") && (name = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"))) != null) {
            this.entityCustomName = name.m_130940_(ChatFormatting.ITALIC);
        }
        this.eggLayTime = compound.m_128451_("EggLayTime");
        this.chickenAge = compound.m_128451_("Age");
        this.chickenGrowth = compound.m_128451_("growth");
        this.chickenGain = compound.m_128451_("gain");
        this.chickenStrength = compound.m_128451_("strength");
        if (sendUpdates) {
            this.sendRenderUpdates();
        }
        this.m_6596_();
    }

    public void sendRenderUpdates() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void entitySetCustomName(CompoundTag compound) {
        if (this.entityCaptured != null) {
            if (compound != null && compound.m_128425_("Name", 8)) {
                try {
                    String name = compound.m_128461_("Name");
                    MutableComponent component = Component.Serializer.m_130701_((String)name);
                    if (component != null) {
                        this.entityCaptured.m_128359_("CustomName", name);
                        this.entityCustomName = component.m_6881_().m_130940_(ChatFormatting.ITALIC);
                        this.m_6596_();
                        return;
                    }
                }
                catch (JsonParseException e) {
                    compound.m_128473_("Name");
                }
            }
            this.entityCaptured.m_128473_("CustomName");
            this.entityCustomName = null;
            this.m_6596_();
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NestTileEntity tileEntity) {
        if (tileEntity.entityCaptured == null) {
            return;
        }
        if (tileEntity.chickenData.eggLayTime == 0) {
            return;
        }
        boolean isDirty = false;
        if (tileEntity.chickenAge < 0) {
            ++tileEntity.chickenAge;
            if (tileEntity.chickenAge >= 0) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
                level.m_5594_(null, pos, level.f_46441_.nextBoolean() ? SoundEvents.f_11752_ : (tileEntity.chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.f_11750_), SoundSource.PLAYERS, 1.0f, 1.0f);
                tileEntity.sendRenderUpdates();
                tileEntity.eggLayTime = ResourceChickens.calcNewEggLayTime(level.f_46441_, tileEntity.chickenData, tileEntity.chickenGrowth);
                isDirty = true;
            }
        }
        if (tileEntity.chickenAge >= 0 && !tileEntity.storedItems.getStackInSlot(0).m_41619_()) {
            --tileEntity.eggLayTime;
            if (tileEntity.eggLayTime == 0) {
                tileEntity.eggLayTime = ResourceChickens.calcNewEggLayTime(level.f_46441_, tileEntity.chickenData, tileEntity.chickenGrowth);
                tileEntity.storedItems.getStackInSlot(0).m_41774_(1);
                isDirty = true;
                for (int slot = 1; slot < tileEntity.storedItems.getSlots(); ++slot) {
                    ItemStack itemStack2 = tileEntity.storedItems.getStackInSlot(slot);
                    ItemStack result = tileEntity.getCachedOutputItemHandler().map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)itemStack2, (boolean)false)).orElse(itemStack2);
                    tileEntity.storedItems.setStackInSlot(slot, result);
                }
                List<ItemStack> DROPS = ResourceChickens.calcDrops(tileEntity.chickenGain, tileEntity.chickenData, 0);
                DROPS.replaceAll(itemStack -> tileEntity.getCachedOutputItemHandler().map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)itemStack, (boolean)false)).orElse(itemStack));
                DROPS.forEach(tileEntity.storedItems::insertItemDrop);
                if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue()) {
                    tileEntity.sendRenderUpdates();
                }
            }
        }
        if (isDirty) {
            tileEntity.m_6596_();
        }
    }

    public void updateCachedOutputItemHandler() {
        LazyOptional lazyOptional;
        BlockEntity tileEntity;
        BlockEntity blockEntity = tileEntity = this.f_58857_ != null && this.f_58857_.m_46749_(this.f_58858_.m_7495_()) ? this.f_58857_.m_7702_(this.f_58858_.m_7495_()) : null;
        if (tileEntity != null && (lazyOptional = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP)).isPresent() && this.outputItemHandlerCached != lazyOptional) {
            this.outputItemHandlerCached = lazyOptional;
            this.outputItemHandlerCached.addListener(lazy -> this.updateCachedOutputItemHandler());
            return;
        }
        this.outputItemHandlerCached = LazyOptional.empty();
    }

    private LazyOptional<IItemHandler> getCachedOutputItemHandler() {
        if (this.outputItemHandlerCached == null) {
            this.updateCachedOutputItemHandler();
        }
        return this.outputItemHandlerCached;
    }
}

