/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JEI;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.JEI.EntityIngredient;
import wallywhip.resourcechickens.compat.JEI.JEIBaseCategory;
import wallywhip.resourcechickens.compat.JEI.JEIPlugin;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.json.ChickenData;

public class JEIChickenBreedingCategory
extends JEIBaseCategory<Recipe> {
    public static final ResourceLocation ID = new ResourceLocation("resourcechickens", "jei.breeding");

    public JEIChickenBreedingCategory(IGuiHelper guiHelper) {
        super(ID, (Component)new TranslatableComponent("jei.resourcechickens.category.breeding"), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, 0, 19, 109, 18).build(), (IDrawable)guiHelper.createDrawable(ICONS, 0, 0, 16, 16), Recipe.class);
    }

    public static List<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (((Boolean)ResourceChickens.CONFIGURATION.allowCrossBreeding.get()).booleanValue()) {
            initRegistry.DATA.forEach((id, chickenData) -> {
                if (!chickenData.parentA.equals("") || !chickenData.parentB.equals("")) {
                    recipes.add(new Recipe(initRegistry.getChickenDataFromLongID(chickenData.parentA), initRegistry.getChickenDataFromLongID(chickenData.parentB), (ChickenData)chickenData));
                }
            });
        }
        return recipes;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, @NotNull Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredient(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.parentA.name));
        builder.addSlot(RecipeIngredientRole.INPUT, 38, 1).addIngredient(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.parentB.name));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 1).addIngredient(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.child.name));
    }

    public static class Recipe {
        private final ChickenData parentA;
        private final ChickenData parentB;
        private final ChickenData child;

        public Recipe(ChickenData parentA, ChickenData parentB, ChickenData child) {
            this.parentA = parentA;
            this.parentB = parentB;
            this.child = child;
        }
    }
}

