/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JEI;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.JEI.EntityIngredient;
import wallywhip.resourcechickens.compat.JEI.JEIBaseCategory;
import wallywhip.resourcechickens.compat.JEI.JEIPlugin;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.json.ChickenData;

public class JEIChickenDropsCategory
extends JEIBaseCategory<Recipe> {
    public static final ResourceLocation ID = new ResourceLocation("resourcechickens", "jei.drops");

    public JEIChickenDropsCategory(IGuiHelper guiHelper) {
        super(ID, (Component)new TranslatableComponent("jei.resourcechickens.category.drops"), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, 0, 0, 72, 18).build(), (IDrawable)guiHelper.createDrawable(ICONS, 16, 0, 16, 16), Recipe.class);
    }

    public static List<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        initRegistry.DATA.forEach((id, chickenData) -> {
            ItemStack itemStack;
            if (chickenData.eggLayTime > 0 && !(itemStack = ResourceChickens.getDropItem(chickenData.dropItemItem)).m_41619_()) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                itemStack.m_41751_(chickenData.dropItemNBT);
                items.add(itemStack);
                items.add(new ItemStack((ItemLike)(chickenData.hasTrait == 1 ? (ItemLike)initItems.FEATHER_DUCK.get() : Items.f_42402_)));
                recipes.add(new Recipe((ChickenData)chickenData, (List<ItemStack>)items));
            }
        });
        return recipes;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 1).addIngredients(VanillaTypes.ITEM, recipe.dropItems);
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredient(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.name));
    }

    public static class Recipe {
        private final String name;
        private final List<ItemStack> dropItems;

        public Recipe(ChickenData chickenData, @Nullable List<ItemStack> dropItems) {
            this.name = chickenData.name;
            this.dropItems = dropItems;
        }
    }
}

