/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JEI;

import com.google.gson.JsonArray;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.JEI.EntityIngredient;
import wallywhip.resourcechickens.compat.JEI.EntityIngredientFactory;
import wallywhip.resourcechickens.compat.JEI.EntityIngredientHelper;
import wallywhip.resourcechickens.compat.JEI.EntityRenderer;
import wallywhip.resourcechickens.compat.JEI.JEIChickenBreedingCategory;
import wallywhip.resourcechickens.compat.JEI.JEIChickenDropsCategory;
import wallywhip.resourcechickens.json.ChickenData;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final IIngredientType<EntityIngredient> ENTITY_INGREDIENT = () -> EntityIngredient.class;

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIChickenBreedingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIChickenDropsCategory(helper)});
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("resourcechickens", "jei");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JEIChickenBreedingCategory.getRecipes(), JEIChickenBreedingCategory.ID);
        registration.addRecipes(JEIChickenDropsCategory.getRecipes(), JEIChickenDropsCategory.ID);
        this.registerInfoDesc(registration);
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        List<EntityIngredient> entityIngredients = EntityIngredientFactory.create();
        registration.register(ENTITY_INGREDIENT, entityIngredients, (IIngredientHelper)new EntityIngredientHelper(), (IIngredientRenderer)new EntityRenderer());
    }

    private void registerInfoDesc(IRecipeRegistration registration) {
        for (EntityIngredient chicken : EntityIngredientFactory.create()) {
            ChickenData chickenData = chicken.chickenData;
            StringBuilder stringInformation = new StringBuilder();
            String aqua = ChatFormatting.DARK_AQUA.toString();
            String purple = ChatFormatting.DARK_PURPLE.toString();
            stringInformation.append(aqua).append("Name: ").append(purple).append(chickenData.displayName.getString()).append("\n");
            stringInformation.append(aqua).append("Base Health: ").append(purple).append(chickenData.baseHealth).append("\n");
            stringInformation.append(aqua).append("Base Speed: ").append(purple).append(chickenData.baseSpeed);
            if (chickenData.eggLayTime > 0) {
                stringInformation.append("\n").append(aqua).append("Drop Time: ").append(purple).append(ResourceChickens.formatTime(chickenData.eggLayTime));
            }
            stringInformation.append("\n").append(aqua).append("Conv. Quantity: ").append(purple).append(chickenData.conversion);
            stringInformation.append("\n").append(aqua).append("Can Breed: ").append(purple);
            switch ((Integer)ResourceChickens.CONFIGURATION.masterSwitchBreeding.get()) {
                default: {
                    stringInformation.append("false");
                    break;
                }
                case 1: {
                    stringInformation.append("true");
                    break;
                }
                case 2: {
                    stringInformation.append(chickenData.canBreed);
                }
            }
            if (chickenData.biomesWhitelist == null && chickenData.biomesBlacklist == null) {
                stringInformation.append("\n").append(aqua).append("Spawns Naturally: ").append(purple).append(chickenData.spawnNaturally);
            } else if (chickenData.spawnNaturally) {
                if (chickenData.biomesWhitelist != null && !chickenData.biomesWhitelist.isEmpty()) {
                    stringInformation.append("\n").append(aqua).append("Spawns In: ").append(purple).append(this.formatBiomeNames(chickenData.biomesWhitelist));
                }
                if (chickenData.biomesBlacklist != null && !chickenData.biomesBlacklist.isEmpty()) {
                    stringInformation.append("\n").append(aqua).append("Spawns Outside: ").append(purple).append(this.formatBiomeNames(chickenData.biomesBlacklist));
                }
            }
            registration.addIngredientInfo((Object)chicken, ENTITY_INGREDIENT, new Component[]{new TextComponent(stringInformation.toString())});
        }
    }

    private String formatBiomeNames(JsonArray biomeArray) {
        StringBuilder biome = new StringBuilder();
        for (int a = 0; a < biomeArray.size(); ++a) {
            String n = biomeArray.get(a).toString().replace("\"", "").replace(":", ".");
            biome.append(new TranslatableComponent("biome." + n).getString());
            if (a >= biomeArray.size() - 1) continue;
            biome.append(", ");
        }
        return biome.toString();
    }
}

