/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.WAILA_JADE;

import java.util.ArrayList;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.VanillaPlugin;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;

public class NestComponentProvider
implements IComponentProvider {
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            if (tile.entityCaptured != null) {
                int chickenAge;
                CompoundTag data = accessor.getServerData();
                tooltip.add((Component)new TextComponent(tile.entityDescription));
                if (tile.entityCustomName != null) {
                    tooltip.add(tile.entityCustomName);
                }
                if (tile.entityCaptured.m_128471_("analyzed")) {
                    tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.growth", new Object[]{tile.chickenGrowth}));
                    tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.gain", new Object[]{tile.chickenGain}));
                    tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.strength", new Object[]{tile.chickenStrength}));
                }
                if ((chickenAge = data.m_128451_("chickenAge")) < 0) {
                    tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.growing", new Object[]{ResourceChickens.formatTime(-chickenAge)}));
                } else if (data.m_128451_("eggLayTime") != 0) {
                    if (data.m_128471_("requiresSeeds")) {
                        tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.seeds").m_130940_(ChatFormatting.YELLOW));
                    } else {
                        tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.egg", new Object[]{ResourceChickens.formatTime(data.m_128451_("eggTime"))}));
                    }
                } else {
                    tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.nodrop").m_130940_(ChatFormatting.YELLOW));
                }
            }
            if (!tile.storedItems.isEmpty()) {
                IElementHelper helper = tooltip.getElementHelper();
                ArrayList elements = new ArrayList();
                tile.storedItems.getStacks().forEach(item -> {
                    if (!item.m_41619_()) {
                        elements.add(helper.item(item).tag(VanillaPlugin.INVENTORY));
                        if (!((Boolean)ResourceChickens.CONFIGURATION.renderNestContentsIconsOnly.get()).booleanValue()) {
                            elements.add(helper.text(item.m_41786_()).translate(new Vec2(0.0f, 4.0f)).tag(VanillaPlugin.INVENTORY));
                            tooltip.add(elements);
                            elements.clear();
                        }
                    }
                });
                if (((Boolean)ResourceChickens.CONFIGURATION.renderNestContentsIconsOnly.get()).booleanValue()) {
                    tooltip.add(elements);
                }
            }
        }
    }
}

