/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.entity;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.TOP.ITOPInfoEntityProvider;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.json.ChickenData;

@ParametersAreNonnullByDefault
public class ResourceChickenEntity
extends Chicken
implements ITOPInfoEntityProvider {
    public static final EntityDataAccessor<Boolean> ANALYZED = SynchedEntityData.m_135353_(ResourceChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GROWTH = SynchedEntityData.m_135353_(ResourceChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GAIN = SynchedEntityData.m_135353_(ResourceChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> STRENGTH = SynchedEntityData.m_135353_(ResourceChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public ChickenData chickenData;
    public String conversionType = "";
    public String conversionDescID = "";
    public int conversionRequired = 0;
    public int conversionCount = 0;
    private int noJumpDelay;

    public ResourceChickenEntity(EntityType<? extends Chicken> type, Level world, ChickenData chickenData) {
        super(type, world);
        this.chickenData = chickenData;
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        return 10.0f;
    }

    public boolean m_5545_(LevelAccessor accessor, MobSpawnType spawnType) {
        return true;
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> type, LevelAccessor accessor, MobSpawnType spawnType, BlockPos pos, Random random, ChickenData data) {
        ResourceLocation blockName;
        boolean light;
        if (spawnType == MobSpawnType.SPAWNER) {
            return true;
        }
        boolean bl = data.spawnLight <= 0 ? accessor.m_45524_(pos, 0) <= -data.spawnLight : (light = accessor.m_45524_(pos, 0) >= data.spawnLight);
        if (data.spawnBlocks != null && !data.spawnBlocks.isEmpty() && (blockName = accessor.m_8055_(pos.m_7495_()).m_60734_().getRegistryName()) != null) {
            return data.spawnBlocks.toString().contains("\"" + blockName.toString() + "\"") && light;
        }
        return light;
    }

    public static AttributeSupplier.Builder createChickenAttributes(String name) {
        ChickenData chickenData = initRegistry.DATA.get(name);
        return ResourceChickenEntity.m_21552_().m_22268_(Attributes.f_22276_, chickenData.baseHealth).m_22268_(Attributes.f_22279_, chickenData.baseSpeed);
    }

    public int m_5792_() {
        return 2;
    }

    @NotNull
    public Component m_7755_() {
        return this.m_8077_() ? this.m_7770_() : (this.chickenData == null ? new TextComponent("Chicken") : this.chickenData.displayName);
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            if (this.f_146735_ > 0) {
                if (this.f_146735_ % 4 == 0) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                --this.f_146735_;
            }
        } else if (this.m_6084_()) {
            int i = this.m_146764_();
            if (i < 0) {
                this.m_146762_(++i);
            } else if (i > 0) {
                this.m_146762_(--i);
            }
        }
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.m_6109_()) {
            this.f_20903_ = 0;
            this.m_20167_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.f_20903_ > 0) {
            double d0 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
            double d2 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
            double d4 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
            double d6 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d6 / (float)this.f_20903_);
            this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
            --this.f_20903_;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        } else if (!this.m_6142_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
        if (this.f_20934_ > 0) {
            this.f_20885_ = (float)((double)this.f_20885_ + Mth.m_14175_((double)(this.f_20933_ - (double)this.f_20885_)) / (double)this.f_20934_);
            --this.f_20934_;
        }
        Vec3 vec3 = this.m_20184_();
        double d1 = vec3.f_82479_;
        double d3 = vec3.f_82480_;
        double d5 = vec3.f_82481_;
        if (Math.abs(vec3.f_82479_) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3.f_82480_) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vec3.f_82481_) < 0.003) {
            d5 = 0.0;
        }
        this.m_20334_(d1, d3, d5);
        this.f_19853_.m_46473_().m_6180_("ai");
        if (this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        } else if (this.m_6142_()) {
            this.f_19853_.m_46473_().m_6180_("newAi");
            this.m_6140_();
            this.f_19853_.m_46473_().m_7238_();
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("jump");
        if (this.f_20899_ && this.m_6129_()) {
            double d7 = this.m_20077_() ? this.m_204036_(FluidTags.f_13132_) : this.m_204036_(FluidTags.f_13131_);
            boolean flag1 = this.m_20069_() && d7 > 0.0;
            double d8 = this.m_20204_();
            if (!flag1 || this.f_19861_ && !(d7 > d8)) {
                if (!this.m_20077_() || this.f_19861_ && !(d7 > d8)) {
                    if ((this.f_19861_ || flag1 && d7 <= d8) && this.noJumpDelay == 0) {
                        this.m_6135_();
                        this.noJumpDelay = 10;
                    }
                } else {
                    this.m_203347_(FluidTags.f_13132_);
                }
            } else {
                this.m_203347_(FluidTags.f_13131_);
            }
        } else {
            this.noJumpDelay = 0;
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("travel");
        this.f_20900_ *= 0.98f;
        this.f_20902_ *= 0.98f;
        AABB aabb = this.m_142469_();
        this.m_7023_(new Vec3((double)this.f_20900_, (double)this.f_20901_, (double)this.f_20902_));
        this.f_19853_.m_46473_().m_7238_();
        if (this.chickenData.hasTrait == 10) {
            this.f_19853_.m_46473_().m_6180_("freezing");
            boolean flag = this.m_6095_().m_204039_(EntityTypeTags.f_144295_);
            if (!this.f_19853_.f_46443_ && !this.m_21224_()) {
                int i = this.m_146888_();
                if (this.f_146808_ && this.m_142079_()) {
                    this.m_146917_(Math.min(this.m_146891_(), i + 1));
                } else {
                    this.m_146917_(Math.max(0, i - 2));
                }
            }
            this.m_147225_();
            this.m_147226_();
            if (!this.f_19853_.f_46443_ && this.f_19797_ % 40 == 0 && this.m_146890_() && this.m_142079_()) {
                int j = flag ? 5 : 1;
                this.m_6469_(DamageSource.f_146701_, j);
            }
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("push");
        if (this.f_20938_ > 0) {
            --this.f_20938_;
            this.m_21071_(aabb, this.m_142469_());
        }
        this.m_6138_();
        this.f_19853_.m_46473_().m_7238_();
        if (!this.f_19853_.f_46443_ && this.m_6126_() && this.m_20071_()) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
        }
        this.f_28229_ = this.f_28226_;
        this.f_28228_ = this.f_28227_;
        this.f_28227_ = (float)((double)this.f_28227_ + (double)(this.f_19861_ ? -1 : 4) * 0.3);
        this.f_28227_ = Mth.m_14036_((float)this.f_28227_, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.f_28230_ < 1.0f) {
            this.f_28230_ = 1.0f;
        }
        this.f_28230_ = (float)((double)this.f_28230_ * 0.9);
        vec3 = this.m_20184_();
        if (!this.f_19861_ && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.f_28226_ += this.f_28230_ * 2.0f;
        if (((Boolean)ResourceChickens.CONFIGURATION.allowInWorldDrops.get()).booleanValue() && this.chickenData.eggLayTime != 0 && !this.f_19853_.f_46443_ && this.m_6084_() && !this.m_6162_() && !this.f_28232_ && --this.f_28231_ <= 0) {
            ResourceChickens.calcDrops((Integer)this.f_19804_.m_135370_(GAIN), this.chickenData, 0).forEach(arg_0 -> ((ResourceChickenEntity)this).m_19983_(arg_0));
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            }
            this.f_28231_ = ResourceChickens.calcNewEggLayTime(this.f_19796_, this.chickenData, (Integer)this.f_19804_.m_135370_(GROWTH));
        }
        if (this.f_19853_.f_46443_) {
            if (this.chickenData.hasTrait == 2) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
                if (!this.m_20067_() && this.f_19796_.nextInt(100) == 0) {
                    this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_12286_, SoundSource.NEUTRAL, 0.5f, this.f_19796_.nextFloat() * 0.4f + 0.8f, false);
                }
            } else if (this.chickenData.hasTrait == 5) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_() + 0.7, this.m_20262_(0.5), 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_() + 0.7, this.m_20262_(0.5), 0.0, 0.0, 0.0);
                if (!this.m_20067_() && this.f_19796_.nextInt(24) == 0) {
                    this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, SoundSource.NEUTRAL, 1.0f + this.f_19796_.nextFloat(), this.f_19796_.nextFloat() * 0.7f + 0.3f, false);
                }
            }
        }
    }

    public boolean m_7848_(Animal entityIn) {
        if ((Integer)ResourceChickens.CONFIGURATION.masterSwitchBreeding.get() == 0) {
            return false;
        }
        if (this.m_27593_() && entityIn.m_27593_() && entityIn instanceof ResourceChickenEntity) {
            ResourceChickenEntity rce = (ResourceChickenEntity)entityIn;
            if ((Integer)ResourceChickens.CONFIGURATION.masterSwitchBreeding.get() == 2) {
                if (!this.chickenData.canBreed) {
                    return false;
                }
                if (!rce.chickenData.canBreed) {
                    return false;
                }
            }
            if (this.chickenData.hasTrait == 1 && rce.chickenData.hasTrait == 1) {
                return true;
            }
            if (this.chickenData.hasTrait == 1 || rce.chickenData.hasTrait == 1) {
                return false;
            }
            if (this.chickenData.name.equals(rce.chickenData.name)) {
                return true;
            }
            if (this.chickenData.name.equals("chicken") || rce.chickenData.name.equals("chicken")) {
                return (Integer)ResourceChickens.CONFIGURATION.allowBreedingWithVanilla.get() > 0;
            }
            return (Boolean)ResourceChickens.CONFIGURATION.allowCrossBreeding.get();
        }
        return false;
    }

    public Chicken m_142606_(ServerLevel worldIn, AgeableMob ageableEntity) {
        if (ageableEntity instanceof ResourceChickenEntity) {
            ResourceChickenEntity rce = (ResourceChickenEntity)ageableEntity;
            if (this.chickenData.name.equals(rce.chickenData.name)) {
                ResourceChickenEntity newChicken = (ResourceChickenEntity)((EntityType)this.chickenData.entityType.get()).m_20615_((Level)worldIn);
                if (newChicken != null) {
                    ResourceChickenEntity.increaseStats(newChicken, this, rce, worldIn.f_46441_);
                }
                return newChicken;
            }
            if (this.chickenData.hasTrait == 1 && rce.chickenData.hasTrait == 1) {
                if (worldIn.f_46441_.nextBoolean()) {
                    return (Chicken)((EntityType)this.chickenData.entityType.get()).m_20615_((Level)worldIn);
                }
                return (Chicken)((EntityType)rce.chickenData.entityType.get()).m_20615_((Level)worldIn);
            }
            if (this.chickenData.name.equals("chicken")) {
                int r = worldIn.f_46441_.nextInt(100);
                if (r < (Integer)ResourceChickens.CONFIGURATION.allowBreedingWithVanilla.get()) {
                    return (Chicken)((EntityType)rce.chickenData.entityType.get()).m_20615_((Level)worldIn);
                }
                return (Chicken)((EntityType)this.chickenData.entityType.get()).m_20615_((Level)worldIn);
            }
            if (rce.chickenData.name.equals("chicken")) {
                int r = worldIn.f_46441_.nextInt(100);
                if (r < (Integer)ResourceChickens.CONFIGURATION.allowBreedingWithVanilla.get()) {
                    return (Chicken)((EntityType)this.chickenData.entityType.get()).m_20615_((Level)worldIn);
                }
                return (Chicken)((EntityType)rce.chickenData.entityType.get()).m_20615_((Level)worldIn);
            }
            if (((Boolean)ResourceChickens.CONFIGURATION.allowCrossBreeding.get()).booleanValue()) {
                String parentA = this.chickenData.entityType.getId().toString();
                String parentB = rce.chickenData.entityType.getId().toString();
                ArrayList<RegistryObject<EntityType<? extends ResourceChickenEntity>>> lst = new ArrayList<RegistryObject<EntityType<? extends ResourceChickenEntity>>>();
                lst.add(this.chickenData.entityType);
                lst.add(rce.chickenData.entityType);
                for (Map.Entry<String, ChickenData> entry : initRegistry.DATA.entrySet()) {
                    boolean b;
                    ChickenData chickenData = entry.getValue();
                    boolean a = Objects.equals(chickenData.parentA, parentA) && Objects.equals(chickenData.parentB, parentB);
                    boolean bl = b = Objects.equals(chickenData.parentA, parentB) && Objects.equals(chickenData.parentB, parentA);
                    if (!a && !b) continue;
                    lst.add(chickenData.entityType);
                    break;
                }
                worldIn.m_5594_(null, this.m_142538_(), SoundEvents.f_11752_, SoundSource.AMBIENT, 1.0f, 1.0f);
                return (Chicken)((EntityType)((RegistryObject)lst.get(worldIn.f_46441_.nextInt(lst.size()))).get()).m_20615_((Level)worldIn);
            }
            return null;
        }
        return null;
    }

    public void m_27595_(@Nullable Player player) {
        if (player instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerBreeding.get()).booleanValue()) {
            return;
        }
        super.m_27595_(player);
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (damageSource.m_7639_() instanceof FakePlayer) {
            return;
        }
        if (this.chickenData.hasTrait == 3) {
            Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            this.f_19853_.m_7703_((Entity)this, new DamageSource("chicken.explode"), (ExplosionDamageCalculator)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f + (float)((Integer)this.f_19804_.m_135370_(STRENGTH)).intValue() / 2.0f, true, explosion$blockinteraction);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof ResourceChickenEntity) {
            ResourceChickenEntity rce = (ResourceChickenEntity)entity;
            if (this.chickenData.hasTrait == rce.chickenData.hasTrait) {
                return false;
            }
        }
        if (this.chickenData.hasTrait == 4 && !this.f_19853_.f_46443_) {
            if (damageSource == DamageSource.f_19314_) {
                return false;
            }
            if (damageSource.m_7639_() != null) {
                damageSource.m_7639_().m_6469_(new DamageSource("chicken.thorns"), 1.0f + (float)((Integer)this.f_19804_.m_135370_(STRENGTH)).intValue() / 2.0f);
            }
        }
        boolean wasHurt = super.m_6469_(damageSource, amount);
        if (this.m_6084_() && this.chickenData.hasTrait == 2 && !this.f_19853_.m_5776_() && damageSource.m_7639_() instanceof LivingEntity && this.f_19796_.nextInt(10) != 0) {
            for (int i = 0; i < 64 && !this.teleport(); ++i) {
            }
        }
        return wasHurt;
    }

    protected boolean teleport() {
        double d0 = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 64.0;
        double d1 = this.m_20186_() + (double)(this.f_19796_.nextInt(64) - 32);
        double d2 = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 64.0;
        return this.teleport(d0, d1, d2);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
        boolean flag = blockstate.m_60767_().m_76334_();
        if (flag) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected void m_7625_(DamageSource damageSource, boolean hurtByPlayer) {
        if (damageSource.m_7639_() instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerLootDrops.get()).booleanValue()) {
            return;
        }
        ResourceLocation resourcelocation = !this.m_5743_().m_135827_().equals("resourcechickens") ? this.m_5743_() : (this.chickenData.hasTrait == 1 ? new ResourceLocation("resourcechickens", "entities/duck") : new ResourceLocation("resourcechickens", "entities/chicken"));
        LootTable loottable = this.f_19853_.m_142572_().m_129898_().m_79217_(resourcelocation);
        LootContext.Builder lootcontext$builder = this.m_7771_(hurtByPlayer, damageSource);
        LootContext ctx = lootcontext$builder.m_78975_(LootContextParamSets.f_81415_);
        loottable.m_79129_(ctx).forEach(arg_0 -> ((ResourceChickenEntity)this).m_19983_(arg_0));
    }

    protected void m_7472_(DamageSource damageSource, int fortune, boolean allowDrops) {
        if (damageSource.m_7639_() instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerLootDrops.get()).booleanValue()) {
            return;
        }
        if (!allowDrops || !this.m_5743_().m_135827_().equals("resourcechickens")) {
            return;
        }
        if (this.chickenData.name.equals("grave")) {
            Entity entity = damageSource.m_7639_();
            if (!(entity instanceof Player)) {
                return;
            }
            Player playerIn = (Player)entity;
            Inventory playerInv = playerIn.m_150109_();
            ListTag lst = this.getPersistentData().m_128437_("Inventory", 10);
            for (int i = 0; i < lst.size(); ++i) {
                CompoundTag compoundnbt = lst.m_128728_(i);
                int j = compoundnbt.m_128445_("Slot") & 0xFF;
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundnbt);
                if (itemstack.m_41619_()) continue;
                if (j < playerInv.f_35974_.size()) {
                    if (!((ItemStack)playerInv.f_35974_.get(j)).m_41619_()) {
                        playerIn.m_36176_((ItemStack)playerInv.f_35974_.get(j), false);
                    }
                    playerInv.f_35974_.set(j, (Object)itemstack);
                    continue;
                }
                if (j >= 100 && j < playerInv.f_35975_.size() + 100) {
                    if (!((ItemStack)playerInv.f_35975_.get(j - 100)).m_41619_()) {
                        playerIn.m_36176_((ItemStack)playerInv.f_35975_.get(j - 100), false);
                    }
                    playerInv.f_35975_.set(j - 100, (Object)itemstack);
                    continue;
                }
                if (j < 150 || j >= playerInv.f_35976_.size() + 150) continue;
                if (!((ItemStack)playerInv.f_35976_.get(j - 150)).m_41619_()) {
                    playerIn.m_36176_((ItemStack)playerInv.f_35976_.get(j - 150), false);
                }
                playerInv.f_35976_.set(j - 150, (Object)itemstack);
            }
        } else {
            int r = new Random().nextInt(100);
            if (r < (Integer)ResourceChickens.CONFIGURATION.allowDeathDropResource.get()) {
                ResourceChickens.calcDrops((Integer)this.f_19804_.m_135370_(GAIN), this.chickenData, fortune).forEach(arg_0 -> ((ResourceChickenEntity)this).m_19983_(arg_0));
            }
        }
    }

    protected SoundEvent m_7515_() {
        return switch (this.chickenData.hasTrait) {
            default -> SoundEvents.f_11750_;
            case 1 -> (SoundEvent)initSounds.DUCK_AMBIENT.get();
            case 9 -> (SoundEvent)initSounds.RADIATION.get();
        };
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return switch (this.chickenData.hasTrait) {
            default -> SoundEvents.f_11753_;
            case 1 -> (SoundEvent)initSounds.DUCK_DEATH.get();
            case 5 -> SoundEvents.f_11704_;
            case 6 -> SoundEvents.f_11985_;
            case 7 -> SoundEvents.f_11921_;
            case 8 -> SoundEvents.f_12381_;
        };
    }

    protected SoundEvent m_5592_() {
        return switch (this.chickenData.hasTrait) {
            default -> SoundEvents.f_11751_;
            case 1 -> (SoundEvent)initSounds.DUCK_DEATH.get();
            case 5 -> SoundEvents.f_11703_;
            case 6 -> SoundEvents.f_11983_;
            case 7 -> SoundEvents.f_11920_;
            case 8 -> SoundEvents.f_12424_;
        };
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, Entity entity, IProbeHitEntityData data) {
        if (((Boolean)this.f_19804_.m_135370_(ANALYZED)).booleanValue()) {
            probeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.growth", new Object[]{this.f_19804_.m_135370_(GROWTH)}));
            probeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.gain", new Object[]{this.f_19804_.m_135370_(GAIN)}));
            probeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.strength", new Object[]{this.f_19804_.m_135370_(STRENGTH)}));
        }
        if (((Boolean)ResourceChickens.CONFIGURATION.allowInWorldDrops.get()).booleanValue() && !this.m_6162_() && this.chickenData.eggLayTime != 0) {
            probeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.egg", new Object[]{ResourceChickens.formatTime(this.f_28231_)}));
        }
        if (this.conversionCount != 0) {
            probeInfo.text((Component)new TranslatableComponent("tip.resourcechickens.conv", new Object[]{new TranslatableComponent(this.conversionDescID)}));
            probeInfo.progress(this.conversionCount, this.conversionRequired);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANALYZED, (Object)true);
        this.f_19804_.m_135372_(GROWTH, (Object)1);
        this.f_19804_.m_135372_(GAIN, (Object)1);
        this.f_19804_.m_135372_(STRENGTH, (Object)1);
    }

    public void m_7378_(@NotNull CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        if (compoundNBT.m_128441_("analyzed")) {
            this.f_19804_.m_135381_(ANALYZED, (Object)compoundNBT.m_128471_("analyzed"));
            this.f_19804_.m_135381_(GROWTH, (Object)compoundNBT.m_128451_("growth"));
            this.f_19804_.m_135381_(GAIN, (Object)compoundNBT.m_128451_("gain"));
            this.f_19804_.m_135381_(STRENGTH, (Object)compoundNBT.m_128451_("strength"));
        }
        if (compoundNBT.m_128441_("Mutation")) {
            CompoundTag nbt = compoundNBT.m_128469_("Mutation");
            this.conversionCount = nbt.m_128451_("count");
            this.conversionRequired = nbt.m_128451_("req");
            this.conversionType = nbt.m_128461_("type");
            this.conversionDescID = ResourceChickens.getDropItem(this.conversionType).m_41778_();
        }
        if (!compoundNBT.m_128441_("EggLayTime")) {
            this.f_28231_ = ResourceChickens.calcNewEggLayTime(this.f_19796_, this.chickenData, (Integer)this.f_19804_.m_135370_(GROWTH));
        }
    }

    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128379_("analyzed", ((Boolean)this.f_19804_.m_135370_(ANALYZED)).booleanValue());
        compoundNBT.m_128405_("growth", ((Integer)this.f_19804_.m_135370_(GROWTH)).intValue());
        compoundNBT.m_128405_("gain", ((Integer)this.f_19804_.m_135370_(GAIN)).intValue());
        compoundNBT.m_128405_("strength", ((Integer)this.f_19804_.m_135370_(STRENGTH)).intValue());
        if (this.conversionCount != 0) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("count", this.conversionCount);
            nbt.m_128405_("req", this.conversionRequired);
            nbt.m_128359_("type", this.conversionType);
            compoundNBT.m_128365_("Mutation", (Tag)nbt);
        }
    }

    private static void increaseStats(ResourceChickenEntity child, ResourceChickenEntity parentA, ResourceChickenEntity parentB, Random rand) {
        int strengthA = (Integer)parentA.f_19804_.m_135370_(STRENGTH);
        int strengthB = (Integer)parentB.f_19804_.m_135370_(STRENGTH);
        child.f_19804_.m_135381_(GROWTH, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, (Integer)parentA.f_19804_.m_135370_(GROWTH), (Integer)parentB.f_19804_.m_135370_(GROWTH), rand));
        child.f_19804_.m_135381_(GAIN, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, (Integer)parentB.f_19804_.m_135370_(GAIN), (Integer)parentB.f_19804_.m_135370_(GAIN), rand));
        child.f_19804_.m_135381_(STRENGTH, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, strengthA, strengthB, rand));
    }

    private static int calculateNewStat(int thisStrength, int mateStrength, int stat1, int stat2, Random rand) {
        int mutation = rand.nextInt(2) + 1;
        int newStatValue = (stat1 * thisStrength + stat2 * mateStrength) / (thisStrength + mateStrength) + mutation;
        return Math.min(newStatValue, 10);
    }

    private static void inheritStats(ResourceChickenEntity child, ResourceChickenEntity parent) {
        child.f_19804_.m_135381_(GROWTH, (Object)((Integer)parent.f_19804_.m_135370_(GROWTH)));
        child.f_19804_.m_135381_(GAIN, (Object)((Integer)parent.f_19804_.m_135370_(GAIN)));
        child.f_19804_.m_135381_(STRENGTH, (Object)((Integer)parent.f_19804_.m_135370_(STRENGTH)));
    }

    public void m_146762_(int age) {
        super.m_146762_(this.calcNewAge(age, (Integer)this.f_19804_.m_135370_(GROWTH)));
    }

    public int calcNewAge(int age, int growth) {
        int loveAge;
        boolean resetLoveAfterBreeding;
        boolean resetToChild;
        int childAge = -24000;
        boolean bl = resetToChild = age == childAge;
        if (resetToChild) {
            age = Math.min(-1, childAge * (10 - growth + 1) / 10);
        }
        boolean bl2 = resetLoveAfterBreeding = age == (loveAge = 6000);
        if (resetLoveAfterBreeding) {
            age = Math.max(1, loveAge * (10 - growth + 1) / 10);
        }
        return age;
    }

    protected void m_7324_(Entity entity) {
        entity.m_7334_((Entity)this);
        if (!this.f_19853_.f_46443_) {
            int dmg = (int)(1.0f + (float)((Integer)this.f_19804_.m_135370_(STRENGTH)).intValue() / 2.0f);
            if (this.chickenData.hasTrait == 4) {
                entity.m_6469_(new DamageSource("chicken.thorns"), (float)dmg);
            }
            if (this.chickenData.hasTrait == 5) {
                entity.m_20254_(dmg);
            }
            if (this.chickenData.hasTrait == 9) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, dmg * 20));
                entity.m_6469_(new DamageSource("chicken.radiation"), (float)dmg);
            }
            if (this.chickenData.hasTrait == 10) {
                entity.m_6469_(DamageSource.f_146701_, (float)dmg);
                entity.m_146917_(dmg * 20);
            }
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player playerIn, InteractionHand handIn) {
        ItemStack itemStack;
        if (!playerIn.f_19853_.f_46443_ && playerIn.m_7655_() == handIn && !(itemStack = playerIn.m_21205_()).m_41619_()) {
            if (f_28233_.test(itemStack)) {
                return super.m_6071_(playerIn, handIn);
            }
            if (itemStack.m_41720_() instanceof ShearsItem) {
                if (((Boolean)ResourceChickens.CONFIGURATION.allowShearingChickens.get()).booleanValue()) {
                    Level world = playerIn.f_19853_;
                    Vec3 pos = this.m_20182_();
                    itemStack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                    this.m_6469_(new DamageSource("shears"), 1.0f);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_ + (double)this.m_20192_(), pos.f_82481_, 10, 0.5, 0.5, 0.5, 0.0);
                    world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.m_5552_(new ItemStack((ItemLike)(this.chickenData.hasTrait == 1 ? (ItemLike)initItems.FEATHER_DUCK.get() : Items.f_42402_)), 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            if (!((Boolean)ResourceChickens.CONFIGURATION.allowConvertingVanilla.get()).booleanValue()) {
                return InteractionResult.FAIL;
            }
            if (!this.chickenData.name.equals("chicken")) {
                return InteractionResult.FAIL;
            }
            for (Map.Entry<String, ChickenData> entry : initRegistry.DATA.entrySet()) {
                ChickenData chickenData = entry.getValue();
                boolean isMatched = ResourceChickens.getDropItem(chickenData.dropItemItem).m_41720_() == itemStack.m_41720_();
                if (!isMatched) continue;
                if (!playerIn.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                ((ServerLevel)playerIn.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 20, 0.5, 0.5, 0.5, 0.0);
                if (!chickenData.dropItemItem.equals(this.conversionType)) {
                    CompoundTag tag = new CompoundTag();
                    this.m_20223_(tag);
                    tag.m_128473_("Mutation");
                    this.m_20258_(tag);
                    this.conversionCount = 1;
                    this.conversionRequired = chickenData.conversion;
                    this.conversionType = chickenData.dropItemItem;
                    this.conversionDescID = itemStack.m_41778_();
                } else {
                    ++this.conversionCount;
                }
                if (this.conversionCount >= chickenData.conversion) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    playerIn.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_11913_, SoundSource.AMBIENT, 1.0f, 1.0f);
                    ((ServerLevel)playerIn.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 100, 1.0, 1.0, 1.0, 0.0);
                    ResourceChickenEntity newChick = (ResourceChickenEntity)((EntityType)chickenData.entityType.get()).m_20615_(playerIn.f_19853_);
                    if (newChick != null) {
                        CompoundTag tag = this.m_20240_(new CompoundTag());
                        tag.m_128473_("Dimension");
                        tag.m_128473_("Mutation");
                        tag.m_128473_("UUID");
                        newChick.m_20258_(tag);
                        playerIn.f_19853_.m_7967_((Entity)newChick);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.m_6071_(playerIn, handIn);
    }
}

