/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.init;

import net.minecraftforge.common.ForgeConfigSpec;

public class initConfigs {
    public final ForgeConfigSpec COMMON;
    public final ForgeConfigSpec CLIENT;
    public ForgeConfigSpec.IntValue masterSwitchBreeding;
    public ForgeConfigSpec.BooleanValue dropAsBreedingItem;
    public ForgeConfigSpec.IntValue allowBreedingWithVanilla;
    public ForgeConfigSpec.IntValue allowDeathDropResource;
    public ForgeConfigSpec.BooleanValue allowConvertingVanilla;
    public ForgeConfigSpec.BooleanValue allowCrossBreeding;
    public ForgeConfigSpec.BooleanValue allowFakeplayerBreeding;
    public ForgeConfigSpec.BooleanValue allowFakeplayerLootDrops;
    public ForgeConfigSpec.BooleanValue allowShearingChickens;
    public ForgeConfigSpec.BooleanValue analyseChickens;
    public ForgeConfigSpec.BooleanValue renderLabels;
    public ForgeConfigSpec.BooleanValue renderItems;
    public ForgeConfigSpec.BooleanValue renderJEIAnim;
    public ForgeConfigSpec.BooleanValue allowInWorldDrops;
    public ForgeConfigSpec.BooleanValue allowEventTextures;
    public ForgeConfigSpec.BooleanValue renderNestContentsIconsOnly;

    public initConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Resource Chickens");
        this.masterSwitchBreeding = builder.comment("Allow resource chickens to breed.  0=no breeding, 1=all can breed, 2=set by individual configs.  Default: 2").defineInRange("masterSwitchBreeding", 2, 0, 2);
        this.allowCrossBreeding = builder.comment("Allow resource chickens to cross breed.  false=Can only breed with same type.  Default: true").define("allowCrossBreeding", true);
        this.dropAsBreedingItem = builder.comment("Resource chickens require their drop item for food/breeding.  Default: false").define("dropAsBreedingItem", false);
        this.allowBreedingWithVanilla = builder.comment("% Chance that breeding with vanilla chickens produce resource chickens. 0=Don't produce resource chickens.  Default: 80").defineInRange("allowBreedingWithVanilla", 80, 0, 100);
        this.allowConvertingVanilla = builder.comment("Allow conversion of vanilla chickens to resource chickens.  Default: true").define("allowConvertingVanilla", true);
        this.allowDeathDropResource = builder.comment("% Chance that resource is dropped upon death. 0=No resource dropped.  Default: 80").defineInRange("allowDeathDropResource", 80, 0, 100);
        this.allowInWorldDrops = builder.comment("Allow chickens to drop resources naturally in world.  Default: false").define("allowInWorldDrops", false);
        builder.pop();
        builder.push("Fake Player Interaction");
        this.allowFakeplayerBreeding = builder.comment("Allow Fakeplayer/automation of resource chicken breeding.  Default: true").define("allowFakeplayerBreeding", true);
        this.allowFakeplayerLootDrops = builder.comment("Allow Fakeplayer kills to produce loot drops.  Default: true").define("allowFakeplayerLootDrops", true);
        builder.pop();
        builder.push("All Chickens");
        this.allowShearingChickens = builder.comment("Allow shearing of chickens/ducks to get feathers.  Default: true").define("allowShearingChickens", true);
        this.analyseChickens = builder.comment("Chickens must be analyzed before breeding or laying drops.  Default: false  N/I").define("analyseChickens", false);
        builder.pop();
        this.COMMON = builder.build();
        builder = new ForgeConfigSpec.Builder();
        builder.push("Chickens");
        this.renderLabels = builder.comment("Render Nest labels for named chickens.  Default: true").define("renderLabels", true);
        this.renderItems = builder.comment("Render item drops in the Nest.  Default: true").define("renderItems", true);
        this.renderJEIAnim = builder.comment("Animate chickens in JEI.  Default: false  WIP: lighting?").define("renderJEIAnim", false);
        this.allowEventTextures = builder.comment("Allow chicken textures to change on special days.  Default: true").define("allowEventTextures", true);
        this.renderNestContentsIconsOnly = builder.comment(new String[]{"Only show icons of the Nest contents in WAILA/Jade.  Default: false", "true will show Icons and Descriptions"}).define("renderNestContentsIconsOnly", false);
        builder.pop();
        this.CLIENT = builder.build();
    }
}

