/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.entity.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.json.ChickenData;

public class AnimalNet
extends Item {
    public AnimalNet() {
        super(new Item.Properties().m_41491_(ResourceChickens.TAB).m_41503_(16));
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack itemStack, Player playerIn, @NotNull LivingEntity entityIn, @NotNull InteractionHand handIn) {
        if (playerIn.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("entityCaptured")) {
            return InteractionResult.CONSUME;
        }
        ChickenData chickenData = null;
        if (entityIn instanceof ResourceChickenEntity) {
            chickenData = ((ResourceChickenEntity)entityIn).chickenData;
            if (chickenData.name.equals("grave")) {
                return InteractionResult.CONSUME;
            }
            if (chickenData.name.equals("angry")) {
                return InteractionResult.CONSUME;
            }
        } else {
            if (entityIn.m_6095_().m_20674_() == MobCategory.MONSTER) {
                return InteractionResult.CONSUME;
            }
            if (entityIn instanceof Player) {
                return InteractionResult.CONSUME;
            }
        }
        CompoundTag compoundStack = itemStack.m_41784_();
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("id", EntityType.m_20613_((EntityType)entityIn.m_6095_()).toString());
        entityIn.m_20240_(compound);
        compound.m_128473_("Motion");
        compound.m_128473_("Rotation");
        compound.m_128473_("Pos");
        compoundStack.m_128405_("CustomModelData", 1);
        compoundStack.m_128365_("entityCaptured", (Tag)compound);
        if (entityIn instanceof ResourceChickenEntity) {
            compoundStack.m_128359_("entityDescription", chickenData.displayName.getString());
        } else {
            compoundStack.m_128359_("entityDescription", entityIn.m_7755_().getString());
        }
        playerIn.m_21008_(handIn, itemStack);
        playerIn.m_36346_();
        playerIn.f_19853_.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        entityIn.m_142687_(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Entity entity;
        if (context.m_43723_() == null) {
            return InteractionResult.CONSUME;
        }
        if (context.m_43723_().f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        CompoundTag compound = context.m_43722_().m_41737_("entityCaptured");
        if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_() == initBlocks.NEST_BLOCK.get()) {
            BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
            if (!(blockEntity instanceof NestTileEntity)) return InteractionResult.CONSUME;
            NestTileEntity tile = (NestTileEntity)blockEntity;
            if (tile.entityCaptured != null && compound == null) {
                context.m_43722_().m_41784_().m_128405_("CustomModelData", 1);
                tile.entityCaptured.m_128405_("EggLayTime", tile.eggLayTime);
                tile.entityCaptured.m_128405_("Age", tile.chickenAge);
                context.m_43722_().m_41784_().m_128365_("entityCaptured", (Tag)tile.entityCaptured);
                context.m_43722_().m_41784_().m_128359_("entityDescription", tile.entityDescription);
                tile.entityRemove(true);
                context.m_43725_().m_5594_(null, context.m_43723_().m_142538_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                context.m_43723_().m_36346_();
            } else {
                if (tile.entityCaptured != null || compound == null) return InteractionResult.CONSUME;
                ChickenData chickenData = initRegistry.getChickenDataFromLongID(compound.m_128461_("id"));
                if (chickenData == null) return InteractionResult.CONSUME;
                tile.entitySet(compound, context.m_43722_().m_41784_().m_128461_("entityDescription"), true);
                context.m_43725_().m_5594_(null, context.m_43723_().m_142538_(), context.m_43725_().f_46441_.nextBoolean() ? SoundEvents.f_11752_ : (chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.f_11750_), SoundSource.BLOCKS, 1.0f, 1.0f);
                context.m_43722_().m_41749_("entityCaptured");
                context.m_43722_().m_41749_("entityDescription");
                context.m_43722_().m_41749_("CustomModelData");
                context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), player -> player.m_21190_(context.m_43724_()));
            }
            ((ServerLevel)context.m_43725_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)initItems.NEST_BLOCK_ITEM.get()).m_40614_().m_49966_()), (double)context.m_8083_().m_123341_() + 0.5, (double)context.m_8083_().m_123342_() + 0.2, (double)context.m_8083_().m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
            return InteractionResult.SUCCESS;
        }
        if (compound == null) {
            return InteractionResult.CONSUME;
        }
        EntityType et = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(compound.m_128461_("id")));
        if (et == null || (entity = et.m_20615_(context.m_43725_())) == null) return InteractionResult.CONSUME;
        BlockPos pos = context.m_8083_().m_141952_(context.m_43719_().m_122436_());
        int yPos = pos.m_123342_();
        if (context.m_43719_() != Direction.UP) {
            yPos = (int)((double)yPos + 0.5);
        }
        entity.m_20258_(compound);
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)yPos, (double)pos.m_123343_() + 0.5);
        context.m_43725_().m_7967_(entity);
        context.m_43722_().m_41749_("entityCaptured");
        context.m_43722_().m_41749_("entityDescription");
        context.m_43722_().m_41749_("CustomModelData");
        context.m_43725_().m_5594_(null, context.m_43723_().m_142538_(), SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, 1.0f);
        context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), player -> player.m_21190_(context.m_43724_()));
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, worldIn, tooltip, tooltipFlag);
        CompoundTag compound = itemStack.m_41737_("entityCaptured");
        if (compound != null) {
            MutableComponent name;
            tooltip.add((Component)new TextComponent(itemStack.m_41784_().m_128461_("entityDescription")));
            if (compound.m_128425_("CustomName", 8) && (name = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"))) != null) {
                tooltip.add((Component)name.m_130940_(ChatFormatting.ITALIC));
            }
            if (compound.m_128471_("analyzed")) {
                tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.growth", new Object[]{compound.m_128451_("growth")}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.gain", new Object[]{compound.m_128451_("gain")}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)new TranslatableComponent("tip.resourcechickens.strength", new Object[]{compound.m_128451_("strength")}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

