/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;

public class LiquidEgg
extends EggItem {
    private final Fluid fluidType;

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        FluidHandlerItemStack fluidHandlerItemStack = new FluidHandlerItemStack(stack, 1000){

            @Nonnull
            public ItemStack getContainer() {
                return ItemStack.f_41583_;
            }

            @Nonnull
            public FluidStack getFluid() {
                return new FluidStack(LiquidEgg.this.fluidType, 1000);
            }

            public int getTanks() {
                return 1;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return false;
            }

            public boolean canFillFluidType(FluidStack fluid) {
                return false;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (maxDrain < 1000) {
                    return FluidStack.EMPTY;
                }
                return super.drain(maxDrain, action);
            }
        };
        fluidHandlerItemStack.fill(new FluidStack(this.fluidType, 1000), IFluidHandler.FluidAction.EXECUTE);
        return fluidHandlerItemStack;
    }

    public LiquidEgg(Fluid p_i49025_1_) {
        super(new Item.Properties().m_41491_(ResourceChickens.TAB).m_41487_(16));
        this.fluidType = p_i49025_1_;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        BlockPos blockPos2;
        BlockHitResult blockHitResult;
        ItemStack itemStack = playerIn.m_21120_(handIn);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)playerIn, (Level)worldIn, (ItemStack)itemStack, (HitResult)(blockHitResult = LiquidEgg.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos blockPos1 = blockPos.m_142300_(direction);
        BlockState blockState = worldIn.m_8055_(blockPos);
        BlockPos blockPos3 = blockPos2 = this.canBlockContainFluid(worldIn, blockPos, blockState) ? blockPos : blockPos1;
        if (worldIn.m_6042_().m_63951_() && this.fluidType.m_205067_(FluidTags.f_13131_)) {
            worldIn.m_5594_(null, blockPos2, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.f_46441_.nextFloat() - worldIn.f_46441_.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)blockPos2.m_123341_() + Math.random(), (double)blockPos2.m_123342_() + Math.random(), (double)blockPos2.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
            if (!playerIn.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)worldIn.m_5776_());
        }
        if (worldIn.m_46597_(blockPos2, this.fluidType.m_76145_().m_76188_())) {
            if (playerIn instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)playerIn, blockPos2, itemStack);
            }
            this.playEmptySound(playerIn, (LevelAccessor)worldIn, blockPos2);
            if (!playerIn.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)worldIn.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    private boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, this.fluidType);
    }

    protected void playEmptySound(@Nullable Player p_40696_, LevelAccessor p_40697_, BlockPos p_40698_) {
        SoundEvent emptySound = this.fluidType.getAttributes().getEmptySound();
        if (emptySound == null) {
            emptySound = this.fluidType.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        p_40697_.m_5594_(p_40696_, p_40698_, emptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
        p_40697_.m_142346_((Entity)p_40696_, GameEvent.f_157769_, p_40698_);
    }
}

