/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import wallywhip.resourcechickens.entity.AngryChickenEntity;
import wallywhip.resourcechickens.entity.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initChickenConfigs;
import wallywhip.resourcechickens.init.initConfigs;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.json.ResourceChickenData;

public class ResourceChickens
implements ModInitializer {
    public static final String MOD_ID = "resourcechickens";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final class_1761 CREATIVE_TAB = FabricItemGroupBuilder.build((class_2960)new class_2960("resourcechickens", "tab"), () -> new class_1799((class_1935)initItems.EGG_DUCK));
    public static final initConfigs CONFIG = initConfigs.getOrCreateInstance();
    public static final class_2960 DUCK_EGG_SPAWN_PACKET = new class_2960("resourcechickens", "duck_egg_spawn_packet");
    public static final class_2960 FOOLISH_LOC = new class_2960("resourcechickens:textures/entity/vanilla/chicken_fool.png");
    public static final class_2960[] FESTIVE_LOC = new class_2960[]{new class_2960("resourcechickens:textures/entity/vanilla/chicken_fest1.png"), new class_2960("resourcechickens:textures/entity/vanilla/chicken_fest2.png")};
    public static boolean isFestive = false;
    public static boolean isFoolish = false;

    public void onInitialize() {
        initItems.register();
        initBlocks.register();
        initTiles.register();
        initSounds.register();
        initRegistry.register();
        initChickenConfigs.loadConfigs();
        if (ResourceChickens.CONFIG.allowFestiveTextures) {
            LocalDate date = LocalDate.now();
            int dd = date.getDayOfMonth();
            int mm = date.getMonthValue();
            isFestive = dd > 20 && mm == 12;
            isFoolish = dd == 1 && mm == 4;
        } else {
            isFoolish = false;
            isFestive = false;
        }
        initRegistry.DATA.forEach((id, chickenData) -> {
            if (id.equals("angry")) {
                FabricDefaultAttributeRegistry.register(chickenData.entityType, (class_5132.class_5133)AngryChickenEntity.createChickenAttributes(id));
            } else {
                FabricDefaultAttributeRegistry.register(chickenData.entityType, (class_5132.class_5133)ResourceChickenEntity.createChickenAttributes(id));
            }
        });
        class_5458.field_25933.forEach(biome -> {
            class_2960 biomeID = class_5458.field_25933.method_10221(biome);
            if (biomeID != null) {
                String biomeString = biomeID.toString();
                initRegistry.DATA.forEach((id, chickenData) -> {
                    if (chickenData.spawnNaturally) {
                        if (chickenData.biomesWhitelist != null && !chickenData.biomesWhitelist.isEmpty()) {
                            for (JsonElement w : chickenData.biomesWhitelist) {
                                if (!w.getAsString().equals(biomeString)) continue;
                                BiomeModifications.addSpawn((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{biome.method_8688()}), (class_1311)chickenData.spawnType, chickenData.entityType, (int)chickenData.spawnWeight, (int)1, (int)2);
                                break;
                            }
                        } else if (chickenData.biomesBlacklist != null && !chickenData.biomesBlacklist.isEmpty()) {
                            for (JsonElement b : chickenData.biomesBlacklist) {
                                if (!b.getAsString().equals(biomeString)) continue;
                                BiomeModifications.addSpawn((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{biome.method_8688()}), (class_1311)chickenData.spawnType, chickenData.entityType, (int)chickenData.spawnWeight, (int)1, (int)2);
                                break;
                            }
                        } else {
                            List spawns = biome.method_30966().method_31004(class_1311.field_6294).method_34994();
                            if (spawns.stream().anyMatch(tag -> tag.field_9389 == class_1299.field_6132)) {
                                BiomeModifications.addSpawn((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{biome.method_8688()}), (class_1311)chickenData.spawnType, chickenData.entityType, (int)chickenData.spawnWeight, (int)1, (int)2);
                            }
                        }
                    }
                });
            }
        });
        AtomicInteger iid = new AtomicInteger();
        class_5458.field_25933.forEach(biome -> {
            List spawns = biome.method_30966().method_31004(class_1311.field_6294).method_34994();
            if (spawns.stream().anyMatch(tag -> tag.field_9389 == class_1299.field_6132)) {
                iid.getAndIncrement();
                class_2960 chicken_id = new class_2960(MOD_ID, "chicken_remove" + iid);
                BiomeModifications.create((class_2960)chicken_id).add(ModificationPhase.REMOVALS, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{biome.method_8688()}), context -> context.getSpawnSettings().removeSpawnsOfEntityType(class_1299.field_6132));
            }
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, serverWorld) -> {
            if (entity.method_5864() == class_1299.field_6132) {
                ResourceChickenEntity entity2;
                entity.method_5650(class_1297.class_5529.field_26999);
                ResourceChickenData rcd = initRegistry.DATA.get("chicken");
                if (rcd != null && rcd.entityType != null && (entity2 = (ResourceChickenEntity)rcd.entityType.method_5883((class_1937)serverWorld)) != null) {
                    class_2487 nbt = entity.method_5647(new class_2487());
                    nbt.method_10551("Dimension");
                    nbt.method_10551("UUID");
                    entity2.method_5651(nbt);
                    serverWorld.method_8649((class_1297)entity2);
                }
            }
        });
    }

    public static int calcNewEggLayTime(Random r, ResourceChickenData chickenData, int growth) {
        if (chickenData.eggLayTime == 0) {
            return 0;
        }
        int egg = r.nextInt(chickenData.eggLayTime) + chickenData.eggLayTime;
        return (int)Math.max(1.0f, (float)egg * (10.0f - (float)growth + 1.0f) / 10.0f);
    }

    public static int calcDropQuantity(int gain) {
        if (gain < 5) {
            return 1;
        }
        if (gain < 10) {
            return 2;
        }
        return 3;
    }

    public static List<class_1799> calcDrops(int gain, ResourceChickenData chickenData, int fortune) {
        Random r;
        class_1799 itemStack;
        ArrayList<class_1799> lst = new ArrayList<class_1799>();
        if (!chickenData.dropItemItem.equals("") && !(itemStack = ResourceChickens.getDropItem(chickenData.dropItemItem)).method_7960()) {
            if (chickenData.dropItemNBT != null) {
                itemStack.method_7980(chickenData.dropItemNBT.method_10553());
            }
            int dropQuantity = ResourceChickens.calcDropQuantity(gain) + fortune;
            if (itemStack.method_7946()) {
                itemStack.method_7939(dropQuantity);
                lst.add(itemStack);
            } else {
                for (int a = 0; a < dropQuantity; ++a) {
                    class_1799 itm = itemStack.method_7972();
                    lst.add(itm);
                }
            }
        }
        if ((r = new Random()).nextInt(8) == 0) {
            lst.add(chickenData.hasTrait == 1 ? new class_1799((class_1935)initItems.FEATHER_DUCK) : new class_1799((class_1935)class_1802.field_8153));
        }
        return lst;
    }

    public static String formatTime(int milli) {
        int secs = milli / 20;
        int mins = secs / 60;
        int hours = mins / 60;
        if (hours == 0) {
            return String.format("%02d:%02d", mins, secs % 60);
        }
        return String.format("%02d:%02d:%02d", hours, mins, secs % 60);
    }

    public static class_1799 getDropItem(String dropItem) {
        class_1799 itemStack = class_1799.field_8037;
        if (dropItem.startsWith("items:")) {
            Iterator tag = class_2378.field_11142.method_40286(class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(dropItem.substring(6)))).iterator();
            if (tag.hasNext()) {
                itemStack = new class_1799((class_6880)tag.next());
            }
        } else if (dropItem.startsWith("blocks:")) {
            Iterator tag = class_2378.field_11146.method_40286(class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960(dropItem.substring(7)))).iterator();
            if (tag.hasNext()) {
                itemStack = new class_1799((class_1935)((class_6880)tag.next()).comp_349());
            }
        } else {
            itemStack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(dropItem)));
        }
        return itemStack;
    }

    public static class_2960 getTexture(ResourceChickenEntity entityIn) {
        if (isFestive && entityIn.chickenData.name.equals("chicken")) {
            long l = entityIn.method_5667().getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && entityIn.chickenData.name.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return entityIn.chickenData.chickenTexture;
    }

    public static class_2960 getTexture(ResourceChickenData chickenData, UUID uuid) {
        if (isFestive && chickenData.name.equals("chicken")) {
            long l = uuid.getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && chickenData.name.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return chickenData.chickenTexture;
    }
}

