/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1428;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.json.ResourceChickenData;

public class NestTileEntity
extends class_2586
implements class_1263 {
    public final class_2371<class_1799> STORED_ITEMS = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public ResourceChickenData chickenData = null;
    public class_2487 entityCaptured = null;
    public class_2561 entityDescription = null;
    public class_5250 entityCustomName = null;
    public class_2960 chickenTexture = null;
    public int eggLayTime;
    public int chickenAge;
    public int chickenGrowth;
    public int chickenGain;
    public int chickenStrength;

    public NestTileEntity(class_2338 blockPos, class_2680 blockState) {
        super(initTiles.NEST_BLOCK_TILE, blockPos, blockState);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.STORED_ITEMS.clear();
        class_1262.method_5429((class_2487)compound, this.STORED_ITEMS);
        if (compound.method_10545("entityCaptured")) {
            this.entitySet(compound.method_10562("entityCaptured"), compound.method_10558("entityDescription"), false);
        } else {
            this.entityRemove(false);
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        class_1262.method_5427((class_2487)compound, this.STORED_ITEMS, (boolean)true);
        if (this.entityCaptured != null) {
            this.entityCaptured.method_10569("EggLayTime", this.eggLayTime);
            this.entityCaptured.method_10569("Age", this.chickenAge);
            compound.method_10566("entityCaptured", (class_2520)this.entityCaptured);
            compound.method_10582("entityDescription", this.entityDescription.getString());
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, NestTileEntity tileEntity) {
        if (tileEntity.entityCaptured == null) {
            return;
        }
        if (tileEntity.chickenData.eggLayTime == 0) {
            return;
        }
        boolean isDirty = false;
        if (tileEntity.chickenAge < 0) {
            ++tileEntity.chickenAge;
            if (tileEntity.chickenAge >= 0) {
                world.method_8396(null, pos, world.field_9229.nextBoolean() ? class_3417.field_15219 : (tileEntity.chickenData.hasTrait == 1 ? initSounds.DUCK_AMBIENT : class_3417.field_14871), class_3419.field_15245, 1.0f, 1.0f);
                ((class_3218)world).method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.2, (double)pos.method_10260() + 0.5, 20, 0.3, 0.2, 0.3, 0.0);
                tileEntity.eggLayTime = ResourceChickens.calcNewEggLayTime(world.field_9229, tileEntity.chickenData, tileEntity.chickenGrowth);
                isDirty = true;
                tileEntity.sendRenderUpdates();
            }
        }
        if (tileEntity.chickenAge >= 0 && !((class_1799)tileEntity.STORED_ITEMS.get(3)).method_7960()) {
            --tileEntity.eggLayTime;
            if (tileEntity.eggLayTime == 0) {
                tileEntity.eggLayTime = ResourceChickens.calcNewEggLayTime(world.field_9229, tileEntity.chickenData, tileEntity.chickenGrowth);
                ((class_1799)tileEntity.STORED_ITEMS.get(3)).method_7934(1);
                isDirty = true;
                List<class_1799> DROPS = ResourceChickens.calcDrops(tileEntity.chickenGain, tileEntity.chickenData, 0);
                class_1263 outputINV = class_2614.method_11250((class_1937)world, (class_2338)pos.method_10074());
                if (outputINV != null) {
                    int slot;
                    for (slot = 0; slot < 3; ++slot) {
                        tileEntity.STORED_ITEMS.set(slot, (Object)class_2614.method_11260((class_1263)tileEntity, (class_1263)outputINV, (class_1799)((class_1799)tileEntity.STORED_ITEMS.get(slot)), null));
                    }
                    for (slot = 0; slot < DROPS.size(); ++slot) {
                        DROPS.set(slot, class_2614.method_11260((class_1263)tileEntity, (class_1263)outputINV, (class_1799)DROPS.get(slot), null));
                    }
                }
                DROPS.forEach(tileEntity::insertItemAnySlot);
                if (ResourceChickens.CONFIG.renderNestItems) {
                    tileEntity.sendRenderUpdates();
                }
            }
        }
        if (isDirty) {
            tileEntity.method_5431();
        }
    }

    public void entityRemove(boolean sendUpdates) {
        this.chickenAge = 0;
        this.chickenGrowth = 0;
        this.chickenGain = 0;
        this.chickenStrength = 0;
        this.eggLayTime = 0;
        this.chickenData = null;
        this.entityCaptured = null;
        this.entityDescription = null;
        this.entityCustomName = null;
        this.method_5431();
        if (sendUpdates) {
            this.sendRenderUpdates();
        }
    }

    public void entitySet(class_2487 compound, String desc, boolean sendUpdates) {
        class_5250 name;
        this.entityCaptured = compound.method_10553();
        this.entityDescription = new class_2585(desc);
        this.chickenData = initRegistry.getChickenDataFromID(this.entityCaptured.method_10558("id"));
        this.chickenTexture = ResourceChickens.getTexture(this.chickenData, compound.method_25926("UUID"));
        if (compound.method_10545("CustomName") && (name = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"))) != null) {
            this.entityCustomName = name.method_27692(class_124.field_1056);
        }
        this.eggLayTime = compound.method_10550("EggLayTime");
        this.chickenAge = compound.method_10550("Age");
        this.chickenGrowth = compound.method_10550("growth");
        this.chickenGain = compound.method_10550("gain");
        this.chickenStrength = compound.method_10550("strength");
        this.method_5431();
        if (sendUpdates) {
            this.sendRenderUpdates();
        }
    }

    public void sendRenderUpdates() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void entitySetCustomName(class_2487 compound) {
        if (this.entityCaptured != null) {
            if (compound != null && compound.method_10573("Name", 8)) {
                try {
                    String name = compound.method_10558("Name");
                    class_5250 text = class_2561.class_2562.method_10877((String)name);
                    if (text != null) {
                        this.entityCaptured.method_10582("CustomName", name);
                        this.entityCustomName = text.method_27692(class_124.field_1056);
                        this.method_5431();
                        return;
                    }
                }
                catch (JsonParseException e) {
                    compound.method_10551("Name");
                }
            }
            this.entityCaptured.method_10551("CustomName");
            this.entityCustomName = null;
            this.method_5431();
        }
    }

    public int method_5439() {
        return this.STORED_ITEMS.size();
    }

    public boolean method_5442() {
        return this.STORED_ITEMS.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.STORED_ITEMS.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot == 3) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = class_1262.method_5430(this.STORED_ITEMS, (int)slot, (int)amount);
        if (ResourceChickens.CONFIG.renderNestItems) {
            this.sendRenderUpdates();
        }
        return itemStack;
    }

    public class_1799 method_5441(int slot) {
        if (slot == 3) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = class_1262.method_5428(this.STORED_ITEMS, (int)slot);
        if (ResourceChickens.CONFIG.renderNestItems) {
            this.sendRenderUpdates();
        }
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.STORED_ITEMS.set(slot, (Object)stack);
        if (ResourceChickens.CONFIG.renderNestItems) {
            this.sendRenderUpdates();
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.STORED_ITEMS.clear();
        if (ResourceChickens.CONFIG.renderNestItems) {
            this.sendRenderUpdates();
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return slot == 3 && class_1428.field_6742.method_8093(stack);
    }

    private void insertItemAnySlot(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        if (!stack.method_7946()) {
            for (int slot = 0; slot < 3; ++slot) {
                class_1799 existing = (class_1799)this.STORED_ITEMS.get(slot);
                if (!existing.method_7960()) continue;
                this.method_5447(slot, stack);
                return;
            }
        } else {
            class_1799 existing;
            int slot;
            for (slot = 0; slot < 3; ++slot) {
                int freeSpace;
                existing = (class_1799)this.STORED_ITEMS.get(slot);
                if (existing.method_7909() != stack.method_7909() || (freeSpace = existing.method_7914() - existing.method_7947()) <= 0) continue;
                int toInsert = Integer.min(freeSpace, stack.method_7947());
                existing.method_7933(toInsert);
                stack.method_7934(toInsert);
                if (stack.method_7947() != 0) continue;
                return;
            }
            for (slot = 0; slot < 3; ++slot) {
                existing = (class_1799)this.STORED_ITEMS.get(slot);
                if (!existing.method_7960()) continue;
                this.method_5447(slot, stack);
                return;
            }
        }
    }

    public boolean addToExistingSlot(class_1799 stack, int slot, boolean isCreative) {
        class_1799 itemStack = (class_1799)this.STORED_ITEMS.get(slot);
        if (itemStack.method_7960()) {
            this.method_5447(slot, stack.method_7972());
            if (!isCreative) {
                stack.method_7934(((class_1799)this.STORED_ITEMS.get(slot)).method_7947());
            }
            return true;
        }
        if (this.canCombine(itemStack, stack)) {
            int i = Math.min(this.method_5444(), itemStack.method_7914());
            int j = Math.min(stack.method_7947(), i - itemStack.method_7947());
            if (j > 0) {
                itemStack.method_7933(j);
                if (!isCreative) {
                    stack.method_7934(j);
                }
                return true;
            }
        }
        return false;
    }

    private boolean canCombine(class_1799 one, class_1799 two) {
        return one.method_7909() == two.method_7909() && class_1799.method_7975((class_1799)one, (class_1799)two);
    }
}

