/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.class_1311;
import net.minecraft.class_2522;
import net.minecraft.class_2585;
import wallywhip.resourcechickens.json.BaseSerializer;
import wallywhip.resourcechickens.json.ResourceChickenData;

public class Serializers {
    public static final BaseSerializer<ResourceChickenData> DATA = new BaseSerializer<ResourceChickenData>(){

        @Override
        public ResourceChickenData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            ResourceChickenData mt = new ResourceChickenData();
            mt.displayName = new class_2585(obj.get("displayName").getAsString());
            mt.eggLayTime = obj.get("eggLayTime").getAsInt();
            if (mt.eggLayTime < 0) {
                mt.eggLayTime = 0;
            }
            mt.canBreed = obj.get("canBreed").getAsBoolean();
            mt.dropItemItem = obj.get("dropItem").getAsString();
            String st = obj.get("dropItemNBT").getAsString();
            if (st.length() != 0) {
                try {
                    mt.dropItemNBT = new class_2522(new StringReader(st)).method_10727();
                }
                catch (CommandSyntaxException e) {
                    mt.dropItemNBT = null;
                }
            }
            mt.baseHealth = obj.get("baseHealth").getAsDouble();
            mt.baseSpeed = obj.get("baseSpeed").getAsDouble();
            mt.isFireImmune = obj.get("isFireImmune").getAsBoolean();
            mt.conversion = obj.get("conversion").getAsInt();
            if (mt.conversion < 0) {
                mt.conversion = 0;
            }
            mt.eggPrimaryColor = obj.get("eggColorForeground").getAsInt();
            mt.eggSecondaryColor = obj.get("eggColorBackground").getAsInt();
            mt.hasTrait = obj.get("hasTrait").getAsInt();
            JsonArray element = obj.getAsJsonArray("biomesWhitelist");
            if (element != null) {
                mt.biomesWhitelist = element;
            }
            if ((element = obj.getAsJsonArray("biomesBlacklist")) != null) {
                mt.biomesBlacklist = element;
            }
            mt.spawnNaturally = obj.get("spawnNaturally").getAsBoolean();
            mt.spawnType = obj.get("spawnType").getAsInt() == 0 ? class_1311.field_6302 : class_1311.field_6294;
            mt.spawnWeight = obj.get("spawnWeight").getAsInt();
            mt.spawnLight = Integer.parseInt(obj.get("spawnLight").getAsString());
            element = obj.getAsJsonArray("spawnBlocks");
            if (element != null) {
                mt.spawnBlocks = element;
            }
            mt.parentA = obj.get("parentA").getAsString();
            mt.parentB = obj.get("parentB").getAsString();
            mt.enabled = obj.get("enabled").getAsBoolean();
            return mt;
        }

        @Override
        public JsonElement serialize(ResourceChickenData src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("displayName", src.displayName.getString());
            obj.addProperty("dropItem", src.dropItemItem);
            obj.addProperty("dropItemNBT", src.dropItemNBT == null ? "" : src.dropItemNBT.toString());
            obj.addProperty("eggLayTime", (Number)src.eggLayTime);
            obj.addProperty("canBreed", Boolean.valueOf(src.canBreed));
            obj.addProperty("baseHealth", (Number)src.baseHealth);
            obj.addProperty("baseSpeed", (Number)src.baseSpeed);
            obj.addProperty("isFireImmune", Boolean.valueOf(src.isFireImmune));
            obj.addProperty("conversion", (Number)src.conversion);
            obj.addProperty("eggColorForeground", (Number)src.eggPrimaryColor);
            obj.addProperty("eggColorBackground", (Number)src.eggSecondaryColor);
            obj.addProperty("hasTrait", (Number)src.hasTrait);
            if (src.biomesWhitelist != null) {
                obj.add("biomesWhitelist", (JsonElement)src.biomesWhitelist);
            }
            if (src.biomesBlacklist != null) {
                obj.add("biomesBlacklist", (JsonElement)src.biomesBlacklist);
            }
            obj.addProperty("spawnNaturally", Boolean.valueOf(src.spawnNaturally));
            obj.addProperty("spawnWeight", (Number)src.spawnWeight);
            obj.addProperty("spawnType", (Number)src.spawnType.ordinal());
            obj.addProperty("spawnLight", (Number)src.spawnLight);
            if (src.spawnBlocks != null) {
                obj.add("spawnBlocks", (JsonElement)src.spawnBlocks);
            }
            obj.addProperty("parentA", src.parentA);
            obj.addProperty("parentB", src.parentB);
            obj.addProperty("enabled", Boolean.valueOf(src.enabled));
            return obj;
        }

        @Override
        public Type getType() {
            return ResourceChickenData.class;
        }
    };

    public static Gson initGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.setPrettyPrinting();
        gson.serializeNulls();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(DATA.getType(), DATA);
        return gson.create();
    }
}

