/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.rei;

import java.util.ArrayList;
import java.util.Collections;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.rei.breedCategory;
import wallywhip.resourcechickens.compat.rei.breedDisplay;
import wallywhip.resourcechickens.compat.rei.breedRecipe;
import wallywhip.resourcechickens.compat.rei.dropsCategory;
import wallywhip.resourcechickens.compat.rei.dropsDisplay;
import wallywhip.resourcechickens.compat.rei.dropsRecipe;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.json.ResourceChickenData;

public class ReiPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<dropsDisplay> REI_DROPS = CategoryIdentifier.of((class_2960)new class_2960("resourcechickens", "rei.drops"));
    public static final CategoryIdentifier<breedDisplay> REI_BREED = CategoryIdentifier.of((class_2960)new class_2960("resourcechickens", "rei.breed"));

    public String getPluginProviderName() {
        return "reiChickens";
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new dropsCategory());
        registry.add((DisplayCategory)new breedCategory());
    }

    public void registerDisplays(DisplayRegistry registry) {
        this.registerChickenDrops(registry);
        this.registerChickenBreed(registry);
    }

    private void registerChickenBreed(DisplayRegistry registry) {
        initRegistry.DATA.forEach((id, chickenData) -> {
            if (!chickenData.parentA.isEmpty() || !chickenData.parentB.isEmpty()) {
                ResourceChickenData parentA = initRegistry.getChickenDataFromID(chickenData.parentA);
                ResourceChickenData parentB = initRegistry.getChickenDataFromID(chickenData.parentB);
                if (parentA != null && parentB != null) {
                    registry.add((Display)new breedDisplay(new breedRecipe(new class_1799((class_1935)parentA.spawnEggItem), new class_1799((class_1935)parentB.spawnEggItem), new class_1799((class_1935)chickenData.spawnEggItem))));
                }
            }
        });
    }

    private void registerChickenDrops(DisplayRegistry registry) {
        initRegistry.DATA.forEach((id, chickenData) -> {
            ArrayList<class_1799> lst = new ArrayList<class_1799>();
            class_1799 itemStack = ResourceChickens.getDropItem(chickenData.dropItemItem);
            if (!itemStack.method_7960()) {
                if (chickenData.dropItemNBT != null) {
                    itemStack.method_7980(chickenData.dropItemNBT.method_10553());
                }
                lst.add(itemStack.method_7972());
            }
            lst.add(new class_1799((class_1935)(chickenData.hasTrait == 1 ? initItems.FEATHER_DUCK : class_1802.field_8153)));
            ArrayList<dropsRecipe> recipes = new ArrayList<dropsRecipe>();
            lst.forEach(itm -> recipes.add(new dropsRecipe(new class_1799((class_1935)chickenData.spawnEggItem), Collections.singletonList(itm))));
            recipes.forEach(rcp -> registry.add((Display)new dropsDisplay((dropsRecipe)rcp)));
        });
    }

    private static void addDescription(DisplayRegistry registry) {
    }
}

