/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.compat.ct;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.mrbysco.spoiled.registry.SpoilInfo;
import com.mrbysco.spoiled.registry.SpoilRegistry;

public class ActionRemoveSpoiling
implements IUndoableAction {
    public final String uniqueID;
    public final SpoilInfo oldSpoilData;

    public ActionRemoveSpoiling(String uniqueID) {
        this.uniqueID = uniqueID;
        this.oldSpoilData = SpoilRegistry.INSTANCE.getInfoFromID(uniqueID);
    }

    public void apply() {
        SpoilRegistry.INSTANCE.removeSpoiling(this.uniqueID);
    }

    public String describe() {
        if (SpoilRegistry.INSTANCE.containsID(this.uniqueID)) {
            return String.format("Spoiling with unique ID: " + this.uniqueID + " has been removed.", new Object[0]);
        }
        return String.format("Spoiling with unique ID: " + this.uniqueID + " could not be removed, ID does not exist", new Object[0]);
    }

    public void undo() {
        SpoilRegistry.INSTANCE.registerSpoiling(this.oldSpoilData);
    }

    public String describeUndo() {
        return String.format("Spoiling from <" + this.oldSpoilData.getFoodStack().func_77973_b().getRegistryName() + "> to <" + this.oldSpoilData.getSpoilStack().func_77973_b().getRegistryName() + "> has been added again, unique ID: " + this.oldSpoilData.getUniqueID(), new Object[0]);
    }
}

