/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.config;

import com.mrbysco.spoiled.Spoiled;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class SpoiledConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        Spoiled.LOGGER.debug("Loaded forge config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        Spoiled.LOGGER.debug("Forge config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> containerBlacklist;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server settings").push("Server");
            String[] containers = new String[]{"ShulkerBoxTileEntity"};
            this.containerBlacklist = builder.comment("A list of containers in which food does not spoil. To blacklist add the tileentity's class name").defineList("containerBlacklist", Arrays.asList(containers), o -> o instanceof String);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showPercentage;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.showPercentage = builder.comment("When enabled makes the food's tooltips show percentages").define("showPercentage", false);
            builder.pop();
        }
    }
}

