/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.handler;

import com.mrbysco.spoiled.config.SpoiledConfig;
import com.mrbysco.spoiled.registry.SpoilInfo;
import com.mrbysco.spoiled.registry.SpoilRegistry;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SpoilHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K && event.world.func_82737_E() % 20L == 0L) {
            World world = event.world;
            if (!world.field_175730_i.isEmpty()) {
                CopyOnWriteArrayList tickableTileEntities = new CopyOnWriteArrayList(world.field_175730_i);
                for (TileEntity te : tickableTileEntities) {
                    if (te == null || te.func_145837_r() || !te.func_145830_o() || !te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() || ((List)SpoiledConfig.SERVER.containerBlacklist.get()).contains(te.getClass().getSimpleName())) continue;
                    te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                        for (int i = 0; i < itemHandler.getSlots(); ++i) {
                            int getMaxTime;
                            int getOldTime;
                            CompoundNBT tag;
                            ItemStack stack = itemHandler.getStackInSlot(i);
                            if (!SpoilRegistry.INSTANCE.doesSpoil(stack)) continue;
                            this.updateSpoilingStack(stack);
                            if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty() || !(tag = stack.func_77978_p()).func_74764_b("spoiled:SpoilTimer") || !tag.func_74764_b("spoiled:SpoilMaxTime") || (getOldTime = tag.func_74762_e("spoiled:SpoilTimer")) < (getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime"))) continue;
                            this.spoilItemInTE((IItemHandler)itemHandler, i, stack);
                        }
                    });
                }
            }
        }
    }

    private void spoilItemInTE(IItemHandler itemHandler, int slot, ItemStack stack) {
        SpoilInfo info = SpoilRegistry.INSTANCE.getSpoilMap().get(stack.func_77973_b().getRegistryName());
        ItemStack spoiledStack = info.getSpoilStack().func_77946_l();
        spoiledStack.func_190920_e(stack.func_190916_E());
        stack.func_190918_g(stack.func_190916_E());
        itemHandler.insertItem(slot, spoiledStack, false);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % 20L == 0L && !event.player.field_71075_bZ.field_75098_d) {
            this.updateInventory(event.player);
        }
    }

    private void updateInventory(PlayerEntity player) {
        int invCount = player.field_71071_by.func_70302_i_();
        for (int i = 0; i < invCount; ++i) {
            int getMaxTime;
            CompoundNBT tag;
            int getOldTime;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !SpoilRegistry.INSTANCE.doesSpoil(stack)) continue;
            this.updateSpoilingStack(stack);
            if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty() || (getOldTime = (tag = stack.func_77978_p()).func_74762_e("spoiled:SpoilTimer")) < (getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime"))) continue;
            this.spoilItemForPlayer(player, stack);
        }
    }

    public void updateSpoilingStack(ItemStack stack) {
        SpoilInfo info = SpoilRegistry.INSTANCE.getSpoilMap().get(stack.func_77973_b().getRegistryName());
        if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("spoiled:SpoilTimer", 0);
            tag.func_74768_a("spoiled:SpoilMaxTime", info.getSpoilTime());
            stack.func_77982_d(tag);
        } else {
            int getMaxTime;
            int getOldTime;
            CompoundNBT tag = stack.func_77978_p();
            if (tag.func_74764_b("spoiled:SpoilTimer") && tag.func_74764_b("spoiled:SpoilMaxTime") && (getOldTime = tag.func_74762_e("spoiled:SpoilTimer")) < (getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime"))) {
                tag.func_74768_a("spoiled:SpoilTimer", ++getOldTime);
                stack.func_77982_d(tag);
            }
        }
    }

    public void spoilItemForPlayer(PlayerEntity player, ItemStack stack) {
        SpoilInfo info = SpoilRegistry.INSTANCE.getSpoilMap().get(stack.func_77973_b().getRegistryName());
        ItemStack spoiledStack = info.getSpoilStack().func_77946_l();
        spoiledStack.func_190920_e(stack.func_190916_E());
        stack.func_190918_g(64);
        if (player.func_191521_c(spoiledStack)) {
            ItemEntity itemEntity = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            itemEntity.func_92058_a(spoiledStack);
            player.field_70170_p.func_217376_c((Entity)itemEntity);
        }
    }
}

