/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.registry;

import com.google.common.collect.Maps;
import com.mrbysco.spoiled.registry.SpoilInfo;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class SpoilRegistry {
    public static SpoilRegistry INSTANCE = new SpoilRegistry();
    private Map<ResourceLocation, SpoilInfo> spoilMap = Maps.newHashMap();

    public static void initializeSpoiling() {
        INSTANCE.registerSpoiling(new SpoilInfo("apple", new ItemStack((IItemProvider)Items.field_151034_e), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("baked_potato", new ItemStack((IItemProvider)Items.field_151168_bH), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("beef", new ItemStack((IItemProvider)Items.field_151082_bd), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("beetroot", new ItemStack((IItemProvider)Items.field_185164_cV), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("beetroot_soup", new ItemStack((IItemProvider)Items.field_185165_cW), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("bread", new ItemStack((IItemProvider)Items.field_151025_P), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("carrot", new ItemStack((IItemProvider)Items.field_151172_bF), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("chicken", new ItemStack((IItemProvider)Items.field_151076_bf), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("chorus_fruit", new ItemStack((IItemProvider)Items.field_185161_cS), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cod", new ItemStack((IItemProvider)Items.field_196086_aW), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cooked_beef", new ItemStack((IItemProvider)Items.field_151083_be), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cooked_chicken", new ItemStack((IItemProvider)Items.field_151077_bg), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cooked_cod", new ItemStack((IItemProvider)Items.field_196102_ba), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cooked_mutton", new ItemStack((IItemProvider)Items.field_179557_bn), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cooked_porkchop", new ItemStack((IItemProvider)Items.field_151157_am), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cooked_rabbit", new ItemStack((IItemProvider)Items.field_179559_bp), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cooked_salmon", new ItemStack((IItemProvider)Items.field_196104_bb), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("cookie", new ItemStack((IItemProvider)Items.field_151106_aX), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("dried_kelp", new ItemStack((IItemProvider)Items.field_203180_bP), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("golden_apple", new ItemStack((IItemProvider)Items.field_151153_ao), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("golden_carrot", new ItemStack((IItemProvider)Items.field_151150_bK), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("honey_bottle", new ItemStack((IItemProvider)Items.field_226638_pX_), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("melon_slice", new ItemStack((IItemProvider)Items.field_151127_ba), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("mushroom_stew", new ItemStack((IItemProvider)Items.field_151009_A), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("mutton", new ItemStack((IItemProvider)Items.field_179561_bm), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("poisonous_potato", new ItemStack((IItemProvider)Items.field_151170_bI), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("porkchop", new ItemStack((IItemProvider)Items.field_151147_al), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("potato", new ItemStack((IItemProvider)Items.field_151174_bG), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("pufferfish", new ItemStack((IItemProvider)Items.field_196089_aZ), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("pumpkin_pie", new ItemStack((IItemProvider)Items.field_151158_bO), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("rabbit", new ItemStack((IItemProvider)Items.field_179558_bo), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("rabbit_stew", new ItemStack((IItemProvider)Items.field_179560_bq), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("salmon", new ItemStack((IItemProvider)Items.field_196087_aX), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("spider_eye", new ItemStack((IItemProvider)Items.field_151070_bp), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("suspicious_stew", new ItemStack((IItemProvider)Items.field_222115_pz), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("sweet_berries", new ItemStack((IItemProvider)Items.field_222112_pR), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
        INSTANCE.registerSpoiling(new SpoilInfo("tropical_fish", new ItemStack((IItemProvider)Items.field_196088_aY), new ItemStack((IItemProvider)Items.field_151078_bh), 1200));
    }

    public void registerSpoiling(SpoilInfo info) {
        if (!this.containsID(info.getUniqueID())) {
            this.spoilMap.put(info.getFoodStack().func_77973_b().getRegistryName(), info);
        }
    }

    public void removeSpoiling(SpoilInfo info) {
        this.removeSpoiling(info.getUniqueID());
    }

    public void removeSpoiling(String uniqueID) {
        if (this.containsID(uniqueID)) {
            for (Map.Entry<ResourceLocation, SpoilInfo> entry : this.spoilMap.entrySet()) {
                SpoilInfo value = entry.getValue();
                if (!value.getUniqueID().equals(uniqueID)) continue;
                this.spoilMap.remove(entry.getKey(), entry.getValue());
            }
        }
    }

    public void replaceSpoiling(SpoilInfo info) {
        if (this.containsID(info.getUniqueID())) {
            SpoilInfo oldInfo = this.getInfoFromID(info.getUniqueID());
            this.spoilMap.remove(oldInfo.getFoodStack().func_77973_b().getRegistryName(), oldInfo);
            this.spoilMap.put(info.getFoodStack().func_77973_b().getRegistryName(), info);
        }
    }

    public Map<ResourceLocation, SpoilInfo> getSpoilMap() {
        return this.spoilMap;
    }

    public boolean containsID(String uniqueID) {
        if (!this.spoilMap.isEmpty()) {
            for (Map.Entry<ResourceLocation, SpoilInfo> entry : this.spoilMap.entrySet()) {
                SpoilInfo value = entry.getValue();
                if (!value.getUniqueID().equals(uniqueID)) continue;
                return true;
            }
        }
        return false;
    }

    public SpoilInfo getInfoFromID(String uniqueID) {
        if (this.containsID(uniqueID)) {
            for (Map.Entry<ResourceLocation, SpoilInfo> entry : this.spoilMap.entrySet()) {
                SpoilInfo value = entry.getValue();
                if (!value.getUniqueID().equals(uniqueID)) continue;
                return value;
            }
        }
        return null;
    }

    public boolean doesSpoil(ItemStack stack) {
        return this.spoilMap.containsKey(stack.func_77973_b().getRegistryName());
    }
}

