/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.config;

import com.mrbysco.spoiled.Spoiled;
import com.mrbysco.spoiled.config.SpoiledConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;

public class SpoiledConfigCache {
    public static boolean showPercentage;
    public static Map<ResourceLocation, Double> containerModifier;
    public static long spoilRate;

    public static void refreshCache() {
        Spoiled.LOGGER.info("Refreshing config cache");
        showPercentage = (Boolean)SpoiledConfig.CLIENT.showPercentage.get();
        SpoiledConfigCache.generateContainerModifier((List)SpoiledConfig.COMMON.containerModifier.get());
        spoilRate = (long)((Integer)SpoiledConfig.COMMON.spoilRate.get()).intValue() * 20L;
    }

    public static ItemStack getDefaultSpoilItem() {
        String value = (String)SpoiledConfig.COMMON.defaultSpoilItem.get();
        if (value.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(value));
        if (item != null) {
            return new ItemStack((IItemProvider)item);
        }
        Spoiled.LOGGER.error("'defaultSpoilItem' couldn't be parsed, using default");
        return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(Items.field_151078_bh.getRegistryName()));
    }

    public static void generateContainerModifier(List<? extends String> configValues) {
        HashMap<ResourceLocation, Double> modifierMap = new HashMap<ResourceLocation, Double>();
        if (!configValues.isEmpty()) {
            for (String string : configValues) {
                if (!string.contains(",")) {
                    if (string.contains(":")) {
                        Spoiled.LOGGER.error(String.format("Invalid syntax '%s' found in 'containerModifier' config values, supplying default modifier of 0", string));
                        modifierMap.put(new ResourceLocation(string), 0.0);
                        continue;
                    }
                    Spoiled.LOGGER.error(String.format("Invalid syntax '%s' found in 'containerModifier' config values", string));
                    continue;
                }
                String[] values = string.split(",");
                if (values.length == 2) {
                    if (!values[0].contains(":")) {
                        Spoiled.LOGGER.error(String.format("Invalid resourcelocation syntax in 'containerModifier'. could not find \":\" in %s", string));
                        return;
                    }
                    ResourceLocation registry = new ResourceLocation(values[0]);
                    double modifier = NumberUtils.isParsable((String)values[1]) ? Double.parseDouble(values[1]) : -1.0;
                    modifierMap.put(registry, modifier);
                    continue;
                }
                Spoiled.LOGGER.error(String.format("Tried looking for 2 values in 'containerModifier' but found more making the config value %s invalid", string));
            }
        }
        containerModifier = modifierMap;
    }
}

