/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.datagen;

import com.google.gson.JsonObject;
import com.mrbysco.spoiled.datagen.SpoilRecipeBuilder;
import com.mrbysco.spoiled.recipe.condition.InitializeSpoilingCondition;
import com.mrbysco.spoiled.util.SpoiledTags;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpoiledDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new Recipes(generator));
            generator.func_200390_a((IDataProvider)new SpoiledItemTags(generator, new BlockTagsProvider(generator, "spoiled", helper), helper));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new Language(generator));
        }
    }

    public static class SpoiledItemTags
    extends ItemTagsProvider {
        public SpoiledItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagsProvider, "spoiled", existingFileHelper);
        }

        protected void func_200432_c() {
            ArrayList<Item> blacklist = new ArrayList<Item>();
            blacklist.add(Items.field_151078_bh);
            blacklist.add(Items.field_196100_at);
            this.addModFood(SpoiledTags.FOODS_VANILLA, "minecraft", blacklist);
        }

        private void addModFood(ITag.INamedTag<Item> tag, String modID, List<Item> blacklist) {
            for (Item item : ForgeRegistries.ITEMS) {
                if (blacklist.contains(item) || !item.func_219971_r() || !item.getRegistryName().func_110624_b().equals(modID)) continue;
                this.func_240522_a_(tag).func_240532_a_((Object)item);
            }
            this.func_240522_a_(SpoiledTags.FOODS).func_240531_a_(tag);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "spoiled", "en_us");
        }

        protected void addTranslations() {
            this.add("spoiled.spoiling", "Spoiling progress: ");
            this.add("spoiled.spoiling.0", "Fresh");
            this.add("spoiled.spoiling.25", "");
            this.add("spoiled.spoiling.50", "Stale");
            this.add("spoiled.spoiling.75", "Stale");
            this.add("spoiled.spoiling.100", "Rotten");
            this.add("spoiled:tileentity.list.message", "A list of Tile Entities has been output into the log");
        }
    }

    private static class Recipes
    extends RecipeProvider {
        private final String folder = "spoiling/";
        private final String toRotten = "_to_rotten_flesh";

        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            this.makeConditionalRecipe(consumer, "vanilla", Ingredient.func_199805_a(SpoiledTags.FOODS_VANILLA));
        }

        private void makeConditionalRecipe(Consumer<IFinishedRecipe> consumer, String name, Ingredient ingredient) {
            ConditionalRecipe.builder().addCondition((ICondition)new InitializeSpoilingCondition()).addRecipe(SpoilRecipeBuilder.spoilRecipe(ingredient, (IItemProvider)Items.field_151078_bh)::build).build(consumer, "spoiled", "spoiling/" + name + "_to_rotten_flesh");
        }

        protected void func_208310_b(DirectoryCache cache, JsonObject advancementJson, Path path) {
        }
    }
}

