/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.handler;

import com.mrbysco.spoiled.config.SpoiledConfig;
import com.mrbysco.spoiled.config.SpoiledConfigCache;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.recipe.SpoiledRecipes;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class SpoilHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K && event.world.func_82737_E() % SpoiledConfigCache.spoilRate == 0L) {
            ServerWorld world = (ServerWorld)event.world;
            if (!world.field_175730_i.isEmpty()) {
                CopyOnWriteArrayList tileEntities = new CopyOnWriteArrayList(world.field_147482_g);
                for (TileEntity te : tileEntities) {
                    boolean spoilFlag;
                    if (te == null || te.func_145837_r() || !te.func_145830_o() || !world.isAreaLoaded(te.func_174877_v(), 1) || !te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) continue;
                    ResourceLocation location = te.func_200662_C().getRegistryName();
                    double spoilRate = 1.0;
                    if (location != null && SpoiledConfigCache.containerModifier.containsKey(location)) {
                        spoilRate = SpoiledConfigCache.containerModifier.get(location);
                    }
                    if (!(spoilFlag = spoilRate > 0.0 && world.field_73012_v.nextDouble() <= spoilRate)) continue;
                    IItemHandler itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
                    if (itemHandler instanceof SidedInvWrapper) {
                        itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).orElse(null);
                    }
                    if (itemHandler == null || itemHandler.getSlots() <= 0) continue;
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        int getMaxTime;
                        int getOldTime;
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        Inventory inventory = new Inventory(new ItemStack[]{stack});
                        int slot = i;
                        SpoilRecipe recipe = world.func_199532_z().func_215371_a(SpoiledRecipes.SPOIL_RECIPE_TYPE, (IInventory)inventory, (World)world).orElse(null);
                        if (recipe == null) continue;
                        this.updateSpoilingStack(stack, recipe);
                        CompoundNBT tag = stack.func_196082_o();
                        if (!tag.func_74764_b("spoiled:SpoilTimer") || !tag.func_74764_b("spoiled:SpoilMaxTime") || (getOldTime = tag.func_74762_e("spoiled:SpoilTimer")) < (getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime"))) continue;
                        this.spoilItemInHandler(itemHandler, slot, stack, recipe);
                    }
                }
            }
            if (((Boolean)SpoiledConfig.COMMON.spoilEntityContainers.get()).booleanValue()) {
                ArrayList entityList = new ArrayList();
                world.func_241136_z_().forEach(entityList::add);
                for (Entity entity : entityList) {
                    if (!(entity instanceof IInventory) || !entity.func_70089_S()) continue;
                    IInventory containerEntity = (IInventory)entity;
                    this.updateContainer((World)world, entity, containerEntity);
                }
            }
        }
    }

    private void spoilItemInHandler(IItemHandler itemHandler, int slot, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.func_77571_b().func_77946_l();
        int oldStackCount = stack.func_190916_E();
        stack.func_190920_e(0);
        if (!spoiledStack.func_190926_b()) {
            spoiledStack.func_190920_e(oldStackCount);
            itemHandler.insertItem(slot, spoiledStack, false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % SpoiledConfigCache.spoilRate == 0L && !event.player.field_71075_bZ.field_75098_d) {
            this.updateInventory(event.player);
        }
    }

    private void updateInventory(PlayerEntity player) {
        World world = player.field_70170_p;
        int invCount = player.field_71071_by.func_70302_i_();
        for (int i = 0; i < invCount; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    if (itemHandler.getSlots() > 0) {
                        for (int j = 0; j < itemHandler.getSlots(); ++j) {
                            int slot = j;
                            ItemStack nestedStack = itemHandler.getStackInSlot(slot);
                            if (nestedStack.func_190926_b()) continue;
                            Inventory inventory = new Inventory(new ItemStack[]{nestedStack});
                            world.func_199532_z().func_215371_a(SpoiledRecipes.SPOIL_RECIPE_TYPE, (IInventory)inventory, world).ifPresent(recipe -> {
                                int getMaxTime;
                                int getOldTime;
                                this.updateSpoilingStack(nestedStack, (SpoilRecipe)recipe);
                                CompoundNBT tag = nestedStack.func_196082_o();
                                if (tag.func_74764_b("spoiled:SpoilTimer") && tag.func_74764_b("spoiled:SpoilMaxTime") && (getOldTime = tag.func_74762_e("spoiled:SpoilTimer")) >= (getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime"))) {
                                    this.spoilItemInHandler((IItemHandler)itemHandler, slot, nestedStack, (SpoilRecipe)recipe);
                                }
                            });
                        }
                    }
                });
                continue;
            }
            Inventory inventory = new Inventory(new ItemStack[]{stack});
            world.func_199532_z().func_215371_a(SpoiledRecipes.SPOIL_RECIPE_TYPE, (IInventory)inventory, world).ifPresent(recipe -> {
                int getMaxTime;
                int getOldTime;
                this.updateSpoilingStack(stack, (SpoilRecipe)recipe);
                CompoundNBT tag = stack.func_196082_o();
                if (tag.func_74764_b("spoiled:SpoilTimer") && tag.func_74764_b("spoiled:SpoilMaxTime") && (getOldTime = tag.func_74762_e("spoiled:SpoilTimer")) >= (getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime"))) {
                    this.spoilItemForPlayer(player, stack, (SpoilRecipe)recipe);
                }
            });
        }
    }

    public void spoilItemForPlayer(PlayerEntity player, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.func_77571_b().func_77946_l();
        int oldStackCount = stack.func_190916_E();
        stack.func_190920_e(0);
        if (!spoiledStack.func_190926_b()) {
            spoiledStack.func_190920_e(oldStackCount);
            if (!player.func_191521_c(spoiledStack)) {
                ItemEntity itemEntity = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                itemEntity.func_92058_a(spoiledStack);
                player.field_70170_p.func_217376_c((Entity)itemEntity);
            }
        }
    }

    private void updateContainer(World level, Entity entity, IInventory container) {
        int invCount = container.func_70302_i_();
        for (int i = 0; i < invCount; ++i) {
            int getMaxTime;
            int getOldTime;
            ItemStack stack = container.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    if (itemHandler.getSlots() > 0) {
                        for (int j = 0; j < itemHandler.getSlots(); ++j) {
                            int getMaxTime;
                            int getOldTime;
                            int slot = j;
                            ItemStack nestedStack = itemHandler.getStackInSlot(slot);
                            if (nestedStack == null || nestedStack.func_190926_b()) continue;
                            Inventory inventory = new Inventory(new ItemStack[]{nestedStack});
                            SpoilRecipe recipe = level.func_199532_z().func_215371_a(SpoiledRecipes.SPOIL_RECIPE_TYPE, (IInventory)inventory, level).orElse(null);
                            if (recipe == null) continue;
                            this.updateSpoilingStack(nestedStack, recipe);
                            CompoundNBT tag = nestedStack.func_196082_o();
                            if (!tag.func_74764_b("spoiled:SpoilTimer") || !tag.func_74764_b("spoiled:SpoilMaxTime") || (getOldTime = tag.func_74762_e("spoiled:SpoilTimer")) < (getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime"))) continue;
                            this.spoilItemInHandler((IItemHandler)itemHandler, slot, nestedStack, recipe);
                        }
                    }
                });
                continue;
            }
            Inventory inventory = new Inventory(new ItemStack[]{stack});
            SpoilRecipe recipe = level.func_199532_z().func_215371_a(SpoiledRecipes.SPOIL_RECIPE_TYPE, (IInventory)inventory, level).orElse(null);
            if (recipe == null) continue;
            this.updateSpoilingStack(stack, recipe);
            CompoundNBT tag = stack.func_196082_o();
            if (!tag.func_74764_b("spoiled:SpoilTimer") || !tag.func_74764_b("spoiled:SpoilMaxTime") || (getOldTime = tag.func_74762_e("spoiled:SpoilTimer")) < (getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime"))) continue;
            this.spoilItemForEntity(container, entity, stack, recipe);
        }
    }

    public void spoilItemForEntity(IInventory container, Entity entity, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.func_77571_b().func_77946_l();
        int oldStackCount = stack.func_190916_E();
        stack.func_190920_e(0);
        if (!spoiledStack.func_190926_b()) {
            spoiledStack.func_190920_e(oldStackCount);
            int freeSlot = this.getFreeSlot(container);
            if (freeSlot != -1) {
                container.func_70299_a(freeSlot, spoiledStack);
            } else {
                ItemEntity itemEntity = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), spoiledStack);
                entity.field_70170_p.func_217376_c((Entity)itemEntity);
            }
        }
    }

    private int getFreeSlot(IInventory container) {
        for (int i = 0; i < container.func_70302_i_(); ++i) {
            if (!container.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public void updateSpoilingStack(ItemStack stack, SpoilRecipe recipe) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.isEmpty()) {
            if (!tag.func_74764_b("spoiled:SpoilTimer")) {
                tag.func_74768_a("spoiled:SpoilTimer", 0);
            }
            if (!tag.func_74764_b("spoiled:SpoilMaxTime")) {
                tag.func_74768_a("spoiled:SpoilMaxTime", recipe.getSpoilTime());
            }
            stack.func_77982_d(tag);
        } else if (tag.func_74764_b("spoiled:SpoilTimer") && tag.func_74764_b("spoiled:SpoilMaxTime")) {
            int getOldTime = tag.func_74762_e("spoiled:SpoilTimer");
            int getMaxTime = tag.func_74762_e("spoiled:SpoilMaxTime");
            if (getMaxTime != recipe.getSpoilTime()) {
                tag.func_74768_a("spoiled:SpoilMaxTime", recipe.getSpoilTime());
            }
            if (getOldTime < getMaxTime) {
                tag.func_74768_a("spoiled:SpoilTimer", ++getOldTime);
                stack.func_77982_d(tag);
            }
        }
    }
}

