/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.handler;

import com.mrbysco.spoiled.config.SpoiledConfigCache;
import com.mrbysco.spoiled.mixin.ChunkMapAccessor;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.recipe.SpoiledRecipes;
import com.mrbysco.spoiled.util.InventoryHelper;
import com.mrbysco.spoiled.util.SingularInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class SpoilHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        Level level;
        List<BlockPos> blockEntityPositions;
        if (event.phase == TickEvent.Phase.END && !event.world.f_46443_ && event.world.m_46467_() % SpoiledConfigCache.spoilRate == 0L && !(blockEntityPositions = this.getBlockEntityPositions(level = event.world)).isEmpty()) {
            for (BlockPos pos : blockEntityPositions) {
                boolean spoilFlag;
                BlockEntity be;
                if (!level.isAreaLoaded(pos, 1) || (be = level.m_7702_(pos)) == null || be.m_58901_() || !be.m_58898_() || !be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) continue;
                ResourceLocation location = be.m_58903_().getRegistryName();
                double spoilRate = 1.0;
                if (location != null && SpoiledConfigCache.containerModifier.containsKey(location)) {
                    spoilRate = SpoiledConfigCache.containerModifier.get(location);
                }
                if (!(spoilFlag = spoilRate > 0.0 && level.f_46441_.nextDouble() <= spoilRate)) continue;
                IItemHandler itemHandler = (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
                if (itemHandler instanceof SidedInvWrapper) {
                    itemHandler = (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).orElse(null);
                }
                if (itemHandler == null || itemHandler.getSlots() <= 0) continue;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    int getMaxTime;
                    int getOldTime;
                    ItemStack stack = itemHandler.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    SingularInventory inventory = InventoryHelper.createSingularInventory(stack);
                    int slot = i;
                    SpoilRecipe recipe = level.m_7465_().m_44015_(SpoiledRecipes.SPOIL_RECIPE_TYPE, (Container)inventory, level).orElse(null);
                    if (recipe == null) continue;
                    this.updateSpoilingStack(stack, recipe);
                    CompoundTag tag = stack.m_41784_();
                    if (!tag.m_128441_("spoiled:SpoilTimer") || !tag.m_128441_("spoiled:SpoilMaxTime") || (getOldTime = tag.m_128451_("spoiled:SpoilTimer")) < (getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime"))) continue;
                    this.spoilItemInItemhandler(itemHandler, slot, stack, recipe);
                }
            }
        }
    }

    public List<BlockPos> getBlockEntityPositions(Level level) {
        ChunkSource source = level.m_7726_();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        ChunkSource chunkSource = source;
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            for (ChunkHolder chunk : ((ChunkMapAccessor)cache.f_8325_).callGetChunks()) {
                ChunkAccess access;
                LevelChunk levelChunk = chunk.m_140085_();
                if (levelChunk == null || (access = chunk.m_140089_()) == null) continue;
                positions.addAll(access.m_5928_());
            }
        }
        return positions;
    }

    private void spoilItemInItemhandler(IItemHandler itemHandler, int slot, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.m_8043_().m_41777_();
        int oldStackCount = stack.m_41613_();
        stack.m_41764_(0);
        if (!spoiledStack.m_41619_()) {
            spoiledStack.m_41764_(oldStackCount);
            itemHandler.insertItem(slot, spoiledStack, false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_ && event.player.f_19853_.m_46467_() % SpoiledConfigCache.spoilRate == 0L && !event.player.m_150110_().f_35937_) {
            this.updateInventory(event.player);
        }
    }

    private void updateInventory(Player player) {
        Level world = player.f_19853_;
        int invCount = player.m_150109_().m_6643_();
        for (int i = 0; i < invCount; ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    if (itemHandler.getSlots() > 0) {
                        for (int j = 0; j < itemHandler.getSlots(); ++j) {
                            int slot = j;
                            ItemStack nestedStack = itemHandler.getStackInSlot(slot);
                            if (nestedStack.m_41619_()) continue;
                            SingularInventory inventory = InventoryHelper.createSingularInventory(nestedStack);
                            world.m_7465_().m_44015_(SpoiledRecipes.SPOIL_RECIPE_TYPE, (Container)inventory, world).ifPresent(recipe -> {
                                int getMaxTime;
                                int getOldTime;
                                this.updateSpoilingStack(nestedStack, (SpoilRecipe)recipe);
                                CompoundTag tag = nestedStack.m_41784_();
                                if (tag.m_128441_("spoiled:SpoilTimer") && tag.m_128441_("spoiled:SpoilMaxTime") && (getOldTime = tag.m_128451_("spoiled:SpoilTimer")) >= (getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime"))) {
                                    this.spoilItemInItemhandler((IItemHandler)itemHandler, slot, nestedStack, (SpoilRecipe)recipe);
                                }
                            });
                        }
                    }
                });
                continue;
            }
            SingularInventory inventory = InventoryHelper.createSingularInventory(stack);
            world.m_7465_().m_44015_(SpoiledRecipes.SPOIL_RECIPE_TYPE, (Container)inventory, world).ifPresent(recipe -> {
                int getMaxTime;
                int getOldTime;
                this.updateSpoilingStack(stack, (SpoilRecipe)recipe);
                CompoundTag tag = stack.m_41784_();
                if (tag.m_128441_("spoiled:SpoilTimer") && tag.m_128441_("spoiled:SpoilMaxTime") && (getOldTime = tag.m_128451_("spoiled:SpoilTimer")) >= (getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime"))) {
                    this.spoilItemForPlayer(player, stack, (SpoilRecipe)recipe);
                }
            });
        }
    }

    public void updateSpoilingStack(ItemStack stack, SpoilRecipe recipe) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128456_()) {
            if (!tag.m_128441_("spoiled:SpoilTimer")) {
                tag.m_128405_("spoiled:SpoilTimer", 0);
            }
            if (!tag.m_128441_("spoiled:SpoilMaxTime")) {
                tag.m_128405_("spoiled:SpoilMaxTime", recipe.getSpoilTime());
            }
            stack.m_41751_(tag);
        } else if (tag.m_128441_("spoiled:SpoilTimer") && tag.m_128441_("spoiled:SpoilMaxTime")) {
            int getOldTime = tag.m_128451_("spoiled:SpoilTimer");
            int getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime");
            if (getMaxTime != recipe.getSpoilTime()) {
                tag.m_128405_("spoiled:SpoilMaxTime", recipe.getSpoilTime());
            }
            if (getOldTime < getMaxTime) {
                tag.m_128405_("spoiled:SpoilTimer", ++getOldTime);
                stack.m_41751_(tag);
            }
        }
    }

    public void spoilItemForPlayer(Player player, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.m_8043_().m_41777_();
        int oldStackCount = stack.m_41613_();
        stack.m_41764_(0);
        if (!spoiledStack.m_41619_()) {
            spoiledStack.m_41764_(oldStackCount);
            if (!player.m_36356_(spoiledStack)) {
                ItemEntity itemEntity = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), spoiledStack);
                player.f_19853_.m_7967_((Entity)itemEntity);
            }
        }
    }
}

