/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.spoiled.config.SpoiledConfig;
import com.mrbysco.spoiled.config.SpoiledConfigCache;
import com.mrbysco.spoiled.recipe.SpoiledRecipes;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SpoilRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int spoilTime;

    public SpoilRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack stack, int spoilTime) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = stack;
        this.spoilTime = spoilTime;
    }

    public RecipeType<?> m_6671_() {
        return SpoiledRecipes.SPOIL_RECIPE_TYPE;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.ingredient.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container inventory) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getSpoilTime() {
        return this.spoilTime;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SpoiledRecipes.SPOILING_SERIALIZER.get();
    }

    public static class SerializerSpoilRecipe
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SpoilRecipe> {
        public SpoilRecipe fromJson(ResourceLocation recipeId, JsonObject jsonObject) {
            ItemStack itemstack;
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            if (jsonObject.has("result")) {
                if (jsonObject.get("result").isJsonObject()) {
                    itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
                } else {
                    String s1 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
                    ResourceLocation resourcelocation = new ResourceLocation(s1);
                    itemstack = new ItemStack((ItemLike)Registry.f_122827_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
                }
            } else {
                itemstack = SpoiledConfigCache.getDefaultSpoilItem();
            }
            int spoilTime = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"spoiltime", (int)((Integer)SpoiledConfig.COMMON.defaultSpoilTime.get()));
            return new SpoilRecipe(recipeId, s, ingredient, itemstack, spoilTime);
        }

        @Nullable
        public SpoilRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            int spoilTime = buffer.m_130242_();
            return new SpoilRecipe(recipeId, s, ingredient, itemstack, spoilTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, SpoilRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.m_130130_(recipe.spoilTime);
        }
    }
}

