/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.config;

import com.mrbysco.spoiled.Spoiled;
import com.mrbysco.spoiled.config.SpoiledConfigCache;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SpoiledConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec serverSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Spoiled.LOGGER.debug("Loaded Spoiled's config file {}", (Object)configEvent.getConfig().getFileName());
        SpoiledConfigCache.refreshCache();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Spoiled.LOGGER.debug("Spoiled's config just got changed on the file system!");
        SpoiledConfigCache.refreshCache();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showPercentage;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.showPercentage = builder.comment("When enabled makes the food's tooltips show percentages").define("showPercentage", false);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> containerModifier;
        public final ForgeConfigSpec.IntValue spoilRate;
        public final ForgeConfigSpec.BooleanValue initializeSpoiling;
        public final ForgeConfigSpec.IntValue defaultSpoilTime;
        public final ForgeConfigSpec.ConfigValue<String> defaultSpoilItem;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            String[] containers = new String[]{"minecraft:shulker_box,0"};
            this.containerModifier = builder.comment("Determines the spoilrate in specific containers [Syntax: tileentity:spoil_rate]\nExamples: \"minecraft:shulker_box,0\" would make shulker boxes not spoil food\n\"cookingforblockheads:fridge,0.2\" would make a cooking for blockheads fridge spoil at 20% of the usual spoilrate").defineList("containerModifier", Arrays.asList(containers), o -> o instanceof String);
            this.spoilRate = builder.comment("Defines the default amount of seconds in between which the spoiling updates, if this is changed you should update the 'defaultSpoilTime' to accommodate for the extra time [default: 10]").defineInRange("spoilRate", 10, 1, Integer.MAX_VALUE);
            this.initializeSpoiling = builder.comment("When enabled Spoiled initializes spoiling for all vanilla food").define("initializeSpoiling", true);
            this.defaultSpoilTime = builder.comment("Defines the default amount of spoilTime (in second) that is used to initialize Spoiling when 'initializeSpoiling' is enabled").defineInRange("defaultSpoilTime", 120, 1, Integer.MAX_VALUE);
            this.defaultSpoilItem = builder.comment("Defines the item the foods vanilla foods will turn into when spoiled (if empty it will clear the spoiling item) [default: 'minecraft:rotten_flesh']").define("defaultSpoilItem", (Object)"minecraft:rotten_flesh");
            builder.pop();
        }
    }
}

