/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mrbysco.spoiled.Spoiled;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SpoiledCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"spoiled");
        ((LiteralArgumentBuilder)root.requires(commandSource -> commandSource.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").then(Commands.m_82127_((String)"blockentity").executes(SpoiledCommands::listBlockEntities))).then(Commands.m_82127_((String)"food").executes(SpoiledCommands::listFood)));
        dispatcher.register(root);
    }

    private static int listBlockEntities(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        MutableComponent text = new TranslatableComponent("spoiled.command.blockentity_list.message").m_130940_(ChatFormatting.YELLOW);
        source.m_81354_((Component)text, true);
        ArrayList keys = new ArrayList(ForgeRegistries.BLOCK_ENTITIES.getKeys());
        Spoiled.LOGGER.info("List of Block Entities requested by " + source.m_81368_() + ":");
        keys.forEach(t -> Spoiled.LOGGER.info(t.toString()));
        return 0;
    }

    private static int listFood(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        MutableComponent text = new TranslatableComponent("spoiled.command.food_list.message").m_130940_(ChatFormatting.YELLOW);
        source.m_81354_((Component)text, true);
        ArrayList foodItems = new ArrayList(ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_41472_()).collect(Collectors.toList()));
        List<ResourceLocation> keys = foodItems.stream().map(item -> ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item)).collect(Collectors.toList());
        Spoiled.LOGGER.info("List of Foods requested by " + source.m_81368_() + ":");
        keys.forEach(t -> Spoiled.LOGGER.info(t.toString()));
        return 0;
    }
}

