/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.compat.jei;

import com.google.common.collect.Lists;
import com.mrbysco.spoiled.compat.jei.category.SpoilCategory;
import com.mrbysco.spoiled.config.SpoiledConfig;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.recipe.SpoiledRecipes;
import com.mrbysco.spoiled.util.SpoilHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.plugins.vanilla.crafting.CategoryRecipeValidator;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = new ResourceLocation("spoiled", "main");
    public static final ResourceLocation SPOILING = new ResourceLocation("spoiled", "spoiling");
    @Nullable
    private IRecipeCategory<SpoilRecipe> spoilCategory;

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42583_), new RecipeType[]{SpoilCategory.TYPE});
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.spoilCategory = new SpoilCategory(guiHelper);
        iRecipeCategoryArray[0] = this.spoilCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ErrorUtil.checkNotNull(this.spoilCategory, (String)"spoilCategory");
        registration.addRecipes(SpoilCategory.TYPE, this.getVatRecipes(this.spoilCategory));
    }

    public List<SpoilRecipe> getVatRecipes(IRecipeCategory<SpoilRecipe> spoilCategory) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (((Boolean)SpoiledConfig.COMMON.spoilEverything.get()).booleanValue()) {
            ArrayList recipes = Lists.newArrayList();
            ForgeRegistries.ITEMS.getValues().forEach(item -> {
                SpoilRecipe recipe = SpoilHelper.getSpoilRecipe((Level)level, new ItemStack((ItemLike)item));
                if (recipe != null) {
                    recipes.add(recipe);
                }
            });
            return recipes;
        }
        CategoryRecipeValidator validator = new CategoryRecipeValidator(spoilCategory, 1);
        return JEICompat.getValidHandledRecipes(level.m_7465_(), (net.minecraft.world.item.crafting.RecipeType)SpoiledRecipes.SPOIL_RECIPE_TYPE.get(), validator);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> getValidHandledRecipes(RecipeManager recipeManager, net.minecraft.world.item.crafting.RecipeType<T> recipeType, CategoryRecipeValidator<T> validator) {
        return recipeManager.m_44013_(recipeType).stream().filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r)).toList();
    }
}

