/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.spoiled.compat.jei.JEICompat;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SpoilCategory
implements IRecipeCategory<SpoilRecipe> {
    public static final RecipeType<SpoilRecipe> TYPE = RecipeType.create((String)"spoiled", (String)"spoil_recipe", SpoilRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;
    private final IDrawableStatic slotDrawable;

    public SpoilCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(140, 40);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42583_));
        this.title = new TranslatableComponent("spoiled.gui.jei.category.spoiling");
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public ResourceLocation getUid() {
        return JEICompat.SPOILING;
    }

    public RecipeType<SpoilRecipe> getRecipeType() {
        return TYPE;
    }

    public Class<? extends SpoilRecipe> getRecipeClass() {
        return SpoilRecipe.class;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpoilRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 14).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 14).addItemStack(recipe.m_8043_());
    }

    public void draw(SpoilRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
        this.slotDrawable.draw(stack, 9, 13);
        stack.m_85836_();
        stack.m_85837_(1.0, 0.0, 0.0);
        Font font = Minecraft.m_91087_().f_91062_;
        TranslatableComponent component = new TranslatableComponent("spoiled.gui.jei.spoil_time", new Object[]{recipe.getSpoilTime()});
        font.m_92889_(stack, (Component)component, 0.0f, 0.0f, 8);
        stack.m_85849_();
        this.slotDrawable.draw(stack, 112, 13);
    }
}

