/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.config;

import com.mrbysco.spoiled.Spoiled;
import com.mrbysco.spoiled.config.SpoiledConfigCache;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SpoiledConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec serverSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Spoiled.LOGGER.debug("Loaded Spoiled's config file {}", (Object)configEvent.getConfig().getFileName());
        SpoiledConfigCache.refreshCache();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Spoiled.LOGGER.debug("Spoiled's config just got changed on the file system!");
        SpoiledConfigCache.refreshCache();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showPercentage;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.showPercentage = builder.comment("When enabled makes the food's tooltips show percentages").define("showPercentage", false);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> containerModifier;
        public final ForgeConfigSpec.IntValue spoilRate;
        public final ForgeConfigSpec.BooleanValue initializeSpoiling;
        public final ForgeConfigSpec.BooleanValue mergeSpoilingFood;
        public final ForgeConfigSpec.BooleanValue spoilEverything;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> spoilEverythingBlacklist;
        public final ForgeConfigSpec.IntValue defaultSpoilTime;
        public final ForgeConfigSpec.ConfigValue<String> defaultSpoilItem;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            String[] containers = new String[]{"minecraft:shulker_box,0"};
            this.containerModifier = builder.comment("Determines the spoilrate in specific containers [Syntax: tileentity:spoil_rate]\nExamples: \"minecraft:shulker_box,0\" would make shulker boxes not spoil food\n\"cookingforblockheads:fridge,0.2\" would make a cooking for blockheads fridge spoil at 20% of the usual spoilrate").defineListAllowEmpty(List.of("containerModifier"), () -> List.of(containers), o -> o instanceof String);
            this.spoilRate = builder.comment("Defines the default total amount of spoiling updates for each food item \n(For example, a defaultSpoilTime of 40 means any default food item will have 40 total updates before it spoils. \nThis can be altered when custom food spoiling is set using a datapack) [default: 30]").defineInRange("spoilRate", 30, 1, Integer.MAX_VALUE);
            this.initializeSpoiling = builder.comment("When enabled Spoiled initializes spoiling for all vanilla food [default: true]").define("initializeSpoiling", true);
            this.mergeSpoilingFood = builder.comment("When enabled enables a special recipe to merge spoiling food together [default: false]").define("mergeSpoilingFood", false);
            this.spoilEverything = builder.comment("When enabled Spoiled makes every edible item spoil into the specified Spoil Item (This overwrites json spoiling completely) [default: false]").define("spoilEverything", false);
            String[] spoilBlacklist = new String[]{"minecraft:rotten_flesh", "minecraft:enchanted_golden_apple"};
            this.spoilEverythingBlacklist = builder.comment("Defines a list of items that you do not want to spoil when 'spoilEverything' is enabled").defineListAllowEmpty(List.of("spoilEverythingBlacklist"), () -> List.of(spoilBlacklist), o -> o instanceof String);
            this.defaultSpoilTime = builder.comment("Defines the total amount of spoiling updates that is used by the default initialized spoiling when 'initializeSpoiling' is enabled \n(If the 'spoilRate' is 10 and the 'defaultSpoilTime' is set to 20 then the food will spoil after 20 * 10 seconds = 200 seconds) [default: 40]").defineInRange("defaultSpoilTime", 40, 1, Integer.MAX_VALUE);
            this.defaultSpoilItem = builder.comment("Defines the item the foods vanilla foods will turn into when spoiled (if empty it will clear the spoiling item) [default: 'minecraft:rotten_flesh']").define("defaultSpoilItem", (Object)"minecraft:rotten_flesh");
            builder.pop();
        }
    }
}

