/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.datagen;

import com.google.gson.JsonObject;
import com.mrbysco.spoiled.datagen.SpoilRecipeBuilder;
import com.mrbysco.spoiled.recipe.SpoiledRecipes;
import com.mrbysco.spoiled.recipe.condition.InitializeSpoilingCondition;
import com.mrbysco.spoiled.recipe.condition.MergeRecipeCondition;
import com.mrbysco.spoiled.util.SpoiledTags;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpoiledDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new Recipes(generator));
            generator.m_123914_((DataProvider)new SpoiledItemTags(generator, new BlockTagsProvider(generator, "spoiled", helper), helper));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new Language(generator));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        private final String folder = "spoiling/";
        private final String toRotten = "_to_rotten_flesh";

        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
            this.makeConditionalRecipe(consumer, "vanilla", Ingredient.m_204132_(SpoiledTags.FOODS_VANILLA));
            ConditionalRecipe.builder().addCondition((ICondition)new MergeRecipeCondition()).addRecipe(c -> SpecialRecipeBuilder.m_126357_((SimpleRecipeSerializer)((SimpleRecipeSerializer)SpoiledRecipes.STACK_FOOD_SERIALIZER.get())).m_126359_(c, new ResourceLocation("spoiled", "merge_food").toString())).build(consumer, new ResourceLocation("spoiled", "merge_food"));
        }

        private void makeConditionalRecipe(Consumer<FinishedRecipe> consumer, String name, Ingredient ingredient) {
            ConditionalRecipe.builder().addCondition((ICondition)new InitializeSpoilingCondition()).addRecipe(SpoilRecipeBuilder.spoilRecipe(ingredient, (ItemLike)Items.f_42583_)::build).build(consumer, "spoiled", "spoiling/" + name + "_to_rotten_flesh");
        }

        protected void m_126013_(HashCache cache, JsonObject advancementJson, Path path) {
        }
    }

    public static class SpoiledItemTags
    extends ItemTagsProvider {
        public SpoiledItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagsProvider, "spoiled", existingFileHelper);
        }

        protected void m_6577_() {
            this.addModFood(SpoiledTags.FOODS_VANILLA, "minecraft", List.of(Items.f_42583_, Items.f_42437_));
        }

        private void addModFood(TagKey<Item> tag, String modID, List<Item> blacklist) {
            for (Item item : ForgeRegistries.ITEMS) {
                if (blacklist.contains(item) || !item.m_41472_() || !item.getRegistryName().m_135827_().equals(modID)) continue;
                this.m_206424_(tag).m_126582_((Object)item);
            }
            this.m_206424_(SpoiledTags.FOODS).m_206428_(tag);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "spoiled", "en_us");
        }

        protected void addTranslations() {
            this.add("spoiled.spoiling", "Spoiling progress: ");
            this.add("spoiled.spoiling.0", "Fresh");
            this.add("spoiled.spoiling.25", "");
            this.add("spoiled.spoiling.50", "Stale");
            this.add("spoiled.spoiling.75", "Stale");
            this.add("spoiled.spoiling.100", "Rotten");
            this.add("spoiled.gui.jei.category.spoiling", "Spoiling");
            this.add("spoiled.gui.jei.spoil_time", "Spoil Time: %s");
            this.add("spoiled.command.blockentity_list.message", "A list of Block Entities has been output into the log");
            this.add("spoiled.command.food_list.message", "A list of Food has been output into the log");
        }
    }
}

