/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.handler;

import com.google.common.collect.Lists;
import com.mrbysco.spoiled.config.SpoiledConfigCache;
import com.mrbysco.spoiled.mixin.RandomizableContainerBlockEntityAccessor;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.util.ChunkHelper;
import com.mrbysco.spoiled.util.SpoilHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SpoilHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && event.haveTime() && event.world.m_46467_() % SpoiledConfigCache.spoilRate == 0L) {
            ServerLevel level = (ServerLevel)event.world;
            List<BlockPos> blockEntityPositions = ChunkHelper.getBlockEntityPositions((Level)level);
            if (!blockEntityPositions.isEmpty()) {
                for (BlockPos pos : blockEntityPositions) {
                    IItemHandler itemHandler;
                    boolean spoilFlag;
                    RandomizableContainerBlockEntity randomizeInventory;
                    BlockEntity be;
                    if (!level.isAreaLoaded(pos, 1) || (be = level.m_7702_(pos)) == null || be.m_58901_() || !be.m_58898_() || !be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) continue;
                    if (be instanceof RandomizableContainerBlockEntity && ((RandomizableContainerBlockEntityAccessor)(randomizeInventory = (RandomizableContainerBlockEntity)be)).getLootTable() != null) {
                        return;
                    }
                    ResourceLocation location = be.m_58903_().getRegistryName();
                    double spoilRate = 1.0;
                    if (location != null && SpoiledConfigCache.containerModifier.containsKey(location)) {
                        spoilRate = SpoiledConfigCache.containerModifier.get(location);
                    }
                    if (!(spoilFlag = spoilRate == 1.0 || spoilRate > 0.0 && level.f_46441_.nextDouble() <= spoilRate) || (itemHandler = (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) == null || itemHandler.getSlots() <= 0) continue;
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        int getMaxTime;
                        int getOldTime;
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        if (stack == null || stack.m_41619_()) continue;
                        int slot = i;
                        SpoilRecipe recipe = SpoilHelper.getSpoilRecipe((Level)level, stack);
                        if (recipe == null) continue;
                        this.updateSpoilingStack(stack, recipe);
                        CompoundTag tag = stack.m_41784_();
                        if (!tag.m_128441_("spoiled:SpoilTimer") || !tag.m_128441_("spoiled:SpoilMaxTime") || (getOldTime = tag.m_128451_("spoiled:SpoilTimer")) < (getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime"))) continue;
                        this.spoilItemInHandler(itemHandler, slot, stack, recipe);
                    }
                }
            }
            ArrayList entityList = Lists.newArrayList();
            level.m_8583_().forEach(entityList::add);
            for (Entity entity : entityList) {
                if (!(entity instanceof Container)) continue;
                Container containerEntity = (Container)entity;
                if (!entity.m_6084_()) continue;
                this.updateContainer((Level)level, entity, containerEntity);
            }
        }
    }

    private void spoilItemInHandler(IItemHandler itemHandler, int slot, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.m_8043_().m_41777_();
        int oldStackCount = stack.m_41613_();
        stack.m_41764_(0);
        if (!spoiledStack.m_41619_()) {
            spoiledStack.m_41764_(oldStackCount);
            itemHandler.insertItem(slot, spoiledStack, false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_ && event.player.f_19853_.m_46467_() % SpoiledConfigCache.spoilRate == 0L && !event.player.m_150110_().f_35937_) {
            this.updateInventory(event.player);
        }
    }

    private void updateInventory(Player player) {
        Level level = player.f_19853_;
        int invCount = player.m_150109_().m_6643_();
        for (int i = 0; i < invCount; ++i) {
            int getMaxTime;
            int getOldTime;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    if (itemHandler.getSlots() > 0) {
                        for (int j = 0; j < itemHandler.getSlots(); ++j) {
                            int getMaxTime;
                            int getOldTime;
                            SpoilRecipe recipe;
                            int slot = j;
                            ItemStack nestedStack = itemHandler.getStackInSlot(slot);
                            if (nestedStack == null || nestedStack.m_41619_() || (recipe = SpoilHelper.getSpoilRecipe(level, nestedStack)) == null) continue;
                            this.updateSpoilingStack(nestedStack, recipe);
                            CompoundTag tag = nestedStack.m_41784_();
                            if (!tag.m_128441_("spoiled:SpoilTimer") || !tag.m_128441_("spoiled:SpoilMaxTime") || (getOldTime = tag.m_128451_("spoiled:SpoilTimer")) < (getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime"))) continue;
                            this.spoilItemInHandler((IItemHandler)itemHandler, slot, nestedStack, recipe);
                        }
                    }
                });
                continue;
            }
            SpoilRecipe recipe = SpoilHelper.getSpoilRecipe(level, stack);
            if (recipe == null) continue;
            this.updateSpoilingStack(stack, recipe);
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("spoiled:SpoilTimer") || !tag.m_128441_("spoiled:SpoilMaxTime") || (getOldTime = tag.m_128451_("spoiled:SpoilTimer")) < (getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime"))) continue;
            this.spoilItemForPlayer(player, stack, recipe);
        }
    }

    public void spoilItemForPlayer(Player player, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.m_8043_().m_41777_();
        int oldStackCount = stack.m_41613_();
        stack.m_41764_(0);
        if (!spoiledStack.m_41619_()) {
            spoiledStack.m_41764_(oldStackCount);
            if (!player.m_36356_(spoiledStack)) {
                ItemEntity itemEntity = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), spoiledStack);
                player.f_19853_.m_7967_((Entity)itemEntity);
            }
        }
    }

    private void updateContainer(Level level, Entity entity, Container container) {
        int invCount = container.m_6643_();
        for (int i = 0; i < invCount; ++i) {
            int getMaxTime;
            int getOldTime;
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    if (itemHandler.getSlots() > 0) {
                        for (int j = 0; j < itemHandler.getSlots(); ++j) {
                            int getMaxTime;
                            int getOldTime;
                            SpoilRecipe recipe;
                            int slot = j;
                            ItemStack nestedStack = itemHandler.getStackInSlot(slot);
                            if (nestedStack == null || nestedStack.m_41619_() || (recipe = SpoilHelper.getSpoilRecipe(level, nestedStack)) == null) continue;
                            this.updateSpoilingStack(nestedStack, recipe);
                            CompoundTag tag = nestedStack.m_41784_();
                            if (!tag.m_128441_("spoiled:SpoilTimer") || !tag.m_128441_("spoiled:SpoilMaxTime") || (getOldTime = tag.m_128451_("spoiled:SpoilTimer")) < (getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime"))) continue;
                            this.spoilItemInHandler((IItemHandler)itemHandler, slot, nestedStack, recipe);
                        }
                    }
                });
                continue;
            }
            SpoilRecipe recipe = SpoilHelper.getSpoilRecipe(level, stack);
            if (recipe == null) continue;
            this.updateSpoilingStack(stack, recipe);
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("spoiled:SpoilTimer") || !tag.m_128441_("spoiled:SpoilMaxTime") || (getOldTime = tag.m_128451_("spoiled:SpoilTimer")) < (getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime"))) continue;
            this.spoilItemForEntity(container, entity, stack, recipe);
        }
    }

    public void spoilItemForEntity(Container container, Entity entity, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.m_8043_().m_41777_();
        int oldStackCount = stack.m_41613_();
        stack.m_41764_(0);
        if (!spoiledStack.m_41619_()) {
            spoiledStack.m_41764_(oldStackCount);
            int freeSlot = this.getFreeSlot(container);
            if (freeSlot != -1) {
                container.m_6836_(freeSlot, spoiledStack);
            } else {
                ItemEntity itemEntity = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), spoiledStack);
                entity.f_19853_.m_7967_((Entity)itemEntity);
            }
        }
    }

    private int getFreeSlot(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!container.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void updateSpoilingStack(ItemStack stack, SpoilRecipe recipe) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128456_()) {
            if (!tag.m_128441_("spoiled:SpoilTimer")) {
                tag.m_128405_("spoiled:SpoilTimer", 0);
            }
            if (!tag.m_128441_("spoiled:SpoilMaxTime")) {
                tag.m_128405_("spoiled:SpoilMaxTime", recipe.getSpoilTime());
            }
            stack.m_41751_(tag);
        } else if (tag.m_128441_("spoiled:SpoilTimer") && tag.m_128441_("spoiled:SpoilMaxTime")) {
            int getOldTime = tag.m_128451_("spoiled:SpoilTimer");
            int getMaxTime = tag.m_128451_("spoiled:SpoilMaxTime");
            if (getMaxTime != recipe.getSpoilTime()) {
                tag.m_128405_("spoiled:SpoilMaxTime", recipe.getSpoilTime());
            }
            if (getOldTime < getMaxTime) {
                tag.m_128405_("spoiled:SpoilTimer", ++getOldTime);
                stack.m_41751_(tag);
            }
        }
    }
}

