/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.recipe;

import com.google.common.collect.Lists;
import com.mrbysco.spoiled.recipe.SpoiledRecipes;
import com.mrbysco.spoiled.util.SpoilHelper;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class StackFoodRecipe
extends CustomRecipe {
    public StackFoodRecipe(ResourceLocation location) {
        super(location);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack = container.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            list.add(itemstack);
            if (list.size() <= 1) continue;
            ItemStack stack1 = (ItemStack)list.get(0);
            if (itemstack.m_41720_() == stack1.m_41720_() && this.totalUnderMax(itemstack, stack1) && SpoilHelper.isSpoiling(stack1)) continue;
            return false;
        }
        return list.size() == 2;
    }

    public ItemStack assemble(CraftingContainer container) {
        ItemStack stack2;
        ItemStack stack1;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack = container.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            list.add(itemstack);
            if (list.size() <= 1) continue;
            ItemStack stack12 = (ItemStack)list.get(0);
            if (itemstack.m_41720_() == stack12.m_41720_() && SpoilHelper.isSpoiling(stack12)) continue;
            return ItemStack.f_41583_;
        }
        if (list.size() == 2 && (stack1 = (ItemStack)list.get(0)).m_41656_(stack2 = (ItemStack)list.get(1)) && SpoilHelper.isSpoiling(stack1) && this.totalUnderMax(stack1, stack2)) {
            int spoil1 = SpoilHelper.getSpoilTime(stack1);
            int spoil2 = SpoilHelper.getSpoilTime(stack2);
            int averageSpoil = (int)((double)(spoil1 + spoil2) / 2.0);
            ItemStack stackCopy = stack1.m_41777_();
            int combinedCount = stack1.m_41613_() + stack2.m_41613_();
            stackCopy.m_41764_(combinedCount);
            SpoilHelper.setSpoilTime(stackCopy, averageSpoil);
            return stackCopy;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            container.m_6836_(i, ItemStack.f_41583_);
        }
        return super.m_7457_((Container)container);
    }

    public boolean totalUnderMax(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41613_() + stack2.m_41613_() <= stack1.m_41741_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SpoiledRecipes.STACK_FOOD_SERIALIZER.get();
    }
}

