/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.client.entity.animation;

import com.cursedcauldron.unvotedandshelved.client.entity.animation.Animation;
import com.cursedcauldron.unvotedandshelved.client.entity.animation.Keyframe;
import com.cursedcauldron.unvotedandshelved.client.entity.animation.Transformation;
import com.cursedcauldron.unvotedandshelved.mixin.access.ModelPartAccessor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_3532;
import net.minecraft.class_5597;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class AnimationHelper {
    public static void animate(class_5597<?> model, Animation animation, long runningTime, float speed, class_1160 animationProgress) {
        float runningSeconds = AnimationHelper.getRunningSeconds(animation, runningTime);
        for (Map.Entry<String, List<Transformation>> entry : animation.boneAnimations().entrySet()) {
            Optional<class_630> optional = AnimationHelper.getModelParts(model, entry.getKey());
            List<Transformation> transformations = entry.getValue();
            optional.ifPresent(part -> transformations.forEach(transformation -> {
                Keyframe[] keyframes = transformation.keyframes();
                int start = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, index -> runningSeconds <= keyframes[index].timestamp()) - 1);
                int end = Math.min(keyframes.length - 1, start + 1);
                Keyframe startFrame = keyframes[start];
                Keyframe endFrame = keyframes[end];
                float current = runningSeconds - startFrame.timestamp();
                float delta = class_3532.method_15363((float)(current / (endFrame.timestamp() - startFrame.timestamp())), (float)0.0f, (float)1.0f);
                endFrame.interpolation().apply(animationProgress, delta, keyframes, start, end, speed);
                transformation.target().apply((class_630)part, animationProgress);
            }));
        }
    }

    private static Optional<class_630> getModelParts(class_5597<?> model, String key) {
        return model.method_32008().method_32088().filter(part -> ((ModelPartAccessor)part).getChildren().containsKey(key)).findFirst().map(part -> part.method_32086(key));
    }

    private static float getRunningSeconds(Animation animation, long runningTime) {
        float time = (float)runningTime / 1000.0f;
        return animation.looping() ? time % animation.lengthInSeconds() : time;
    }

    public static class_1160 translate(float x, float y, float z) {
        return new class_1160(x, -y, z);
    }

    public static class_1160 rotation(float x, float y, float z) {
        float f = (float)Math.PI / 180;
        return new class_1160(x * f, y * f, z * f);
    }

    public static class_1160 scale(double x, double y, double z) {
        return new class_1160((float)x - 1.0f, (float)y - 1.0f, (float)z - 1.0f);
    }
}

