/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.config;

import com.cursedcauldron.unvotedandshelved.config.FeatureScreen;
import com.cursedcauldron.unvotedandshelved.config.options.UnvotedBooleanConfigOption;
import com.cursedcauldron.unvotedandshelved.core.UnvotedAndShelved;
import com.cursedcauldron.unvotedandshelved.core.registries.USBlocks;
import com.cursedcauldron.unvotedandshelved.core.registries.USItems;
import com.cursedcauldron.unvotedandshelved.mixin.access.ItemAccessor;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.config.option.EnumConfigOption;
import com.terraformersmc.modmenu.config.option.StringSetConfigOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;

public class UnvotedConfigManager {
    private static File file;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "unvotedandshelved.json");
    }

    public static void updateItemCategory() {
        if (FeatureScreen.COPPER_GOLEM.getValue()) {
            ((ItemAccessor)USItems.FROZEN_COPPER_GOLEM_ITEM).setCategory(class_1761.field_7914);
        } else {
            ((ItemAccessor)USItems.FROZEN_COPPER_GOLEM_ITEM).setCategory(null);
        }
        if (FeatureScreen.GLARE.getValue()) {
            ((ItemAccessor)USItems.GLARE_SPAWN_EGG).setCategory(class_1761.field_7932);
            ((ItemAccessor)USItems.GLOWBERRY_DUST_BOTTLE).setCategory(class_1761.field_7928);
        } else {
            ((ItemAccessor)USItems.GLARE_SPAWN_EGG).setCategory(null);
            ((ItemAccessor)USItems.GLOWBERRY_DUST_BOTTLE).setCategory(null);
        }
        if (FeatureScreen.COPPER_BUTTONS.getValue()) {
            ((ItemAccessor)USBlocks.COPPER_BUTTON.method_8389()).setCategory(class_1761.field_7914);
            ((ItemAccessor)USBlocks.EXPOSED_COPPER_BUTTON.method_8389()).setCategory(class_1761.field_7914);
            ((ItemAccessor)USBlocks.WEATHERED_COPPER_BUTTON.method_8389()).setCategory(class_1761.field_7914);
            ((ItemAccessor)USBlocks.OXIDIZED_COPPER_BUTTON.method_8389()).setCategory(class_1761.field_7914);
            ((ItemAccessor)USBlocks.WAXED_COPPER_BUTTON.method_8389()).setCategory(class_1761.field_7914);
            ((ItemAccessor)USBlocks.WAXED_EXPOSED_COPPER_BUTTON.method_8389()).setCategory(class_1761.field_7914);
            ((ItemAccessor)USBlocks.WAXED_WEATHERED_COPPER_BUTTON.method_8389()).setCategory(class_1761.field_7914);
            ((ItemAccessor)USBlocks.WAXED_OXIDIZED_COPPER_BUTTON.method_8389()).setCategory(class_1761.field_7914);
        } else {
            ((ItemAccessor)USBlocks.COPPER_BUTTON.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.EXPOSED_COPPER_BUTTON.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WEATHERED_COPPER_BUTTON.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.OXIDIZED_COPPER_BUTTON.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WAXED_COPPER_BUTTON.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WAXED_EXPOSED_COPPER_BUTTON.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WAXED_WEATHERED_COPPER_BUTTON.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WAXED_OXIDIZED_COPPER_BUTTON.method_8389()).setCategory(null);
        }
        if (FeatureScreen.COPPER_PILLARS.getValue()) {
            ((ItemAccessor)USBlocks.COPPER_PILLAR.method_8389()).setCategory(class_1761.field_7931);
            ((ItemAccessor)USBlocks.EXPOSED_COPPER_PILLAR.method_8389()).setCategory(class_1761.field_7931);
            ((ItemAccessor)USBlocks.WEATHERED_COPPER_PILLAR.method_8389()).setCategory(class_1761.field_7931);
            ((ItemAccessor)USBlocks.OXIDIZED_COPPER_PILLAR.method_8389()).setCategory(class_1761.field_7931);
            ((ItemAccessor)USBlocks.WAXED_COPPER_PILLAR.method_8389()).setCategory(class_1761.field_7931);
            ((ItemAccessor)USBlocks.WAXED_EXPOSED_COPPER_PILLAR.method_8389()).setCategory(class_1761.field_7931);
            ((ItemAccessor)USBlocks.WAXED_WEATHERED_COPPER_PILLAR.method_8389()).setCategory(class_1761.field_7931);
            ((ItemAccessor)USBlocks.WAXED_OXIDIZED_COPPER_PILLAR.method_8389()).setCategory(class_1761.field_7931);
        } else {
            ((ItemAccessor)USBlocks.COPPER_PILLAR.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.EXPOSED_COPPER_PILLAR.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WEATHERED_COPPER_PILLAR.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.OXIDIZED_COPPER_PILLAR.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WAXED_COPPER_PILLAR.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WAXED_EXPOSED_COPPER_PILLAR.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WAXED_WEATHERED_COPPER_PILLAR.method_8389()).setCategory(null);
            ((ItemAccessor)USBlocks.WAXED_OXIDIZED_COPPER_PILLAR.method_8389()).setCategory(null);
        }
    }

    public static void initializeConfig() {
        UnvotedConfigManager.load();
    }

    private static void load() {
        UnvotedConfigManager.prepareConfigFile();
        UnvotedConfigManager.updateItemCategory();
        try {
            if (!file.exists()) {
                UnvotedConfigManager.save();
            }
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                JsonObject json = new JsonParser().parse((Reader)br).getAsJsonObject();
                for (Field field : FeatureScreen.class.getDeclaredFields()) {
                    Type generic;
                    JsonPrimitive jsonPrimitive;
                    Object option;
                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                    if (StringSetConfigOption.class.isAssignableFrom(field.getType())) {
                        JsonArray jsonArray = json.getAsJsonArray(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonArray == null) continue;
                        option = (StringSetConfigOption)field.get(null);
                        ConfigOptionStorage.setStringSet((String)option.getKey(), Sets.newHashSet((Iterable)jsonArray).stream().map(JsonElement::getAsString).collect(Collectors.toSet()));
                        continue;
                    }
                    if (UnvotedBooleanConfigOption.class.isAssignableFrom(field.getType())) {
                        jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonPrimitive == null || !jsonPrimitive.isBoolean()) continue;
                        option = (UnvotedBooleanConfigOption)field.get(null);
                        ConfigOptionStorage.setBoolean((String)((UnvotedBooleanConfigOption)option).getKey(), (boolean)jsonPrimitive.getAsBoolean());
                        continue;
                    }
                    if (!EnumConfigOption.class.isAssignableFrom(field.getType()) || !(field.getGenericType() instanceof ParameterizedType) || (jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT))) == null || !jsonPrimitive.isString() || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                    EnumConfigOption option2 = (EnumConfigOption)field.get(null);
                    Enum found = null;
                    for (Enum value : (Enum[])((Class)generic).getEnumConstants()) {
                        if (!value.name().toLowerCase(Locale.ROOT).equals(jsonPrimitive.getAsString())) continue;
                        found = value;
                        break;
                    }
                    if (found == null) continue;
                    ConfigOptionStorage.setEnumTypeless((String)option2.getKey(), found);
                }
            }
        }
        catch (FileNotFoundException | IllegalAccessException e) {
            System.err.println("Couldn't load Unvoted & Shelved configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        UnvotedConfigManager.prepareConfigFile();
        UnvotedConfigManager.updateItemCategory();
        JsonObject config = new JsonObject();
        try {
            for (Field field : FeatureScreen.class.getDeclaredFields()) {
                Type generic;
                UnvotedBooleanConfigOption option;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                if (UnvotedBooleanConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (UnvotedBooleanConfigOption)field.get(null);
                    config.addProperty(field.getName().toLowerCase(Locale.ROOT), Boolean.valueOf(ConfigOptionStorage.getBoolean((String)option.getKey())));
                    continue;
                }
                if (StringSetConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (StringSetConfigOption)field.get(null);
                    JsonArray array = new JsonArray();
                    ConfigOptionStorage.getStringSet((String)option.getKey()).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                    config.add(field.getName().toLowerCase(Locale.ROOT), (JsonElement)array);
                    continue;
                }
                if (!EnumConfigOption.class.isAssignableFrom(field.getType()) || !(field.getGenericType() instanceof ParameterizedType) || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                EnumConfigOption option2 = (EnumConfigOption)field.get(null);
                config.addProperty(field.getName().toLowerCase(Locale.ROOT), ConfigOptionStorage.getEnumTypeless((String)option2.getKey(), (Class)((Class)generic)).name().toLowerCase(Locale.ROOT));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String jsonString = UnvotedAndShelved.GSON.toJson((JsonElement)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Unvoted & Shelved configuration file");
            e.printStackTrace();
        }
    }
}

