/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.common.entity;

import com.cursedcauldron.unvotedandshelved.common.entity.FrozenCopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.common.entity.ai.copper_golem.CopperGolemBrain;
import com.cursedcauldron.unvotedandshelved.core.registries.USEntities;
import com.cursedcauldron.unvotedandshelved.core.registries.USMemoryModules;
import com.cursedcauldron.unvotedandshelved.core.registries.USPoses;
import com.cursedcauldron.unvotedandshelved.core.registries.USSounds;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1427;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_7094;

public class CopperGolemEntity
extends class_1427 {
    protected static final ImmutableList<class_4149<? extends class_4148<? super CopperGolemEntity>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469);
    protected static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS, USMemoryModules.COPPER_GOLEM_HEADSPIN_TICKS, USMemoryModules.COPPER_BUTTON);
    private static final class_2940<Integer> STAGE = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> WAXED = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 walkingAnimation = new class_7094();
    public final class_7094 headSpinAnimation = new class_7094();
    public final class_7094 headSpinSlowerAnimation = new class_7094();
    public final class_7094 headSpinSlowestAnimation = new class_7094();
    public final class_7094 buttonAnimation = new class_7094();
    public final class_7094 buttonSlowerAnimation = new class_7094();
    public final class_7094 buttonSlowestAnimation = new class_7094();
    public final class_7094 buttonUpAnimation = new class_7094();
    public final class_7094 buttonUpSlowerAnimation = new class_7094();
    public final class_7094 buttonUpSlowestAnimation = new class_7094();
    public final class_7094 buttonDownAnimation = new class_7094();
    public final class_7094 buttonDownSlowerAnimation = new class_7094();
    public final class_7094 buttonDownSlowestAnimation = new class_7094();

    public CopperGolemEntity(class_1299<? extends class_1427> type, class_1937 world) {
        super(type, world);
        this.field_6013 = 1.0f;
    }

    protected class_4095.class_5303<CopperGolemEntity> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return CopperGolemBrain.create((class_4095<CopperGolemEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<CopperGolemEntity> method_18868() {
        return super.method_18868();
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return entityDimensions.field_18068 * (this.method_6109() ? 0.3f : 0.6f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STAGE, (Object)0);
        this.field_6011.method_12784(WAXED, (Object)false);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setStage(Stage.BY_ID[tag.method_10550("Stage")]);
        this.setWaxed(tag.method_10577("Waxed"));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Stage", this.getStage().getId());
        tag.method_10556("Waxed", this.isWaxed());
    }

    protected void method_5958() {
        this.field_6002.method_16107().method_15396("copperGolemBrain");
        this.method_18868().method_19542((class_3218)this.field_6002, (class_1309)this);
        this.field_6002.method_16107().method_15407();
        this.field_6002.method_16107().method_15396("copperGolemActivityUpdate");
        CopperGolemBrain.updateActivity(this);
        this.field_6002.method_16107().method_15407();
        super.method_5958();
    }

    public void method_5674(class_2940<?> data) {
        if (field_18064.equals(data)) {
            this.method_18376();
            if (this.getStage() == Stage.UNAFFECTED) {
                if (this.isInPose(USPoses.HEAD_SPIN.get())) {
                    this.headSpinAnimation.method_41322(this.field_6012);
                } else {
                    this.headSpinAnimation.method_41325();
                    this.headSpinSlowerAnimation.method_41325();
                    this.headSpinSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON.get())) {
                    this.buttonAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonAnimation.method_41325();
                    this.buttonSlowerAnimation.method_41325();
                    this.buttonSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_UP.get())) {
                    this.buttonUpAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonUpAnimation.method_41325();
                    this.buttonUpSlowerAnimation.method_41325();
                    this.buttonUpSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_DOWN.get())) {
                    this.buttonDownAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonDownAnimation.method_41325();
                    this.buttonDownSlowerAnimation.method_41325();
                    this.buttonDownSlowestAnimation.method_41325();
                }
            } else if (this.getStage() == Stage.EXPOSED) {
                if (this.isInPose(USPoses.HEAD_SPIN.get())) {
                    this.headSpinSlowerAnimation.method_41322(this.field_6012);
                } else {
                    this.headSpinAnimation.method_41325();
                    this.headSpinSlowerAnimation.method_41325();
                    this.headSpinSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON.get())) {
                    this.buttonSlowerAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonAnimation.method_41325();
                    this.buttonSlowerAnimation.method_41325();
                    this.buttonSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_UP.get())) {
                    this.buttonUpSlowerAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonUpAnimation.method_41325();
                    this.buttonUpSlowerAnimation.method_41325();
                    this.buttonUpSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_DOWN.get())) {
                    this.buttonDownSlowerAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonDownAnimation.method_41325();
                    this.buttonDownSlowerAnimation.method_41325();
                    this.buttonDownSlowestAnimation.method_41325();
                }
            } else {
                if (this.isInPose(USPoses.HEAD_SPIN.get())) {
                    this.headSpinSlowestAnimation.method_41322(this.field_6012);
                } else {
                    this.headSpinAnimation.method_41325();
                    this.headSpinSlowerAnimation.method_41325();
                    this.headSpinSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON.get())) {
                    this.buttonSlowestAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonAnimation.method_41325();
                    this.buttonSlowerAnimation.method_41325();
                    this.buttonSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_UP.get())) {
                    this.buttonUpSlowestAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonUpAnimation.method_41325();
                    this.buttonUpSlowerAnimation.method_41325();
                    this.buttonUpSlowestAnimation.method_41325();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_DOWN.get())) {
                    this.buttonDownSlowestAnimation.method_41322(this.field_6012);
                } else {
                    this.buttonDownAnimation.method_41325();
                    this.buttonDownSlowerAnimation.method_41325();
                    this.buttonDownSlowestAnimation.method_41325();
                }
            }
        }
        super.method_5674(data);
    }

    private boolean isInPose(class_4050 pose) {
        return this.method_18376() == pose;
    }

    public Stage getStage() {
        return Stage.BY_ID[(Integer)this.field_6011.method_12789(STAGE)];
    }

    public void setStage(Stage stage) {
        this.field_6011.method_12778(STAGE, (Object)stage.getId());
        switch (stage) {
            case UNAFFECTED: {
                this.method_5996(class_5134.field_23719).method_6192(0.5);
                break;
            }
            case EXPOSED: {
                this.method_5996(class_5134.field_23719).method_6192(0.375);
                break;
            }
            case WEATHERED: {
                this.method_5996(class_5134.field_23719).method_6192(0.25);
            }
        }
    }

    public boolean isWaxed() {
        return (Boolean)this.field_6011.method_12789(WAXED);
    }

    public void setWaxed(boolean waxed) {
        this.field_6011.method_12778(WAXED, (Object)waxed);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23718, 1.0);
    }

    private boolean shouldWalk() {
        return this.field_5952 && this.method_18798().method_37268() > 1.0E-6 && !this.method_5816();
    }

    protected int method_6130(int i) {
        return i;
    }

    public void method_5773() {
        if (this.field_6002.method_8608()) {
            if (this.shouldWalk()) {
                this.walkingAnimation.method_41324(this.field_6012);
            } else {
                this.walkingAnimation.method_41325();
            }
        }
        super.method_5773();
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_20414) && !this.isWaxed()) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.setWaxed(true);
            this.field_6002.method_8444(player, 3003, this.method_24515(), 0);
            this.method_32875(class_5712.field_28725, (class_1297)this);
            return class_1269.field_5812;
        }
        if (stack.method_7909() instanceof class_1743) {
            if (this.isWaxed()) {
                this.setWaxed(false);
                this.field_6002.method_8396(player, this.method_24515(), class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
                this.field_6002.method_8444(player, 3004, this.method_24515(), 0);
                this.method_32875(class_5712.field_28725, (class_1297)this);
            } else if (this.getStage() != Stage.UNAFFECTED) {
                stack.method_7956(1, (class_1309)player, e -> e.method_20236(hand));
                this.setStage(Stage.values()[this.getStage().getId() - 1]);
                this.field_6002.method_8396(player, this.method_24515(), class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                this.field_6002.method_8444(player, 3005, this.method_24515(), 0);
                this.method_32875(class_5712.field_28725, (class_1297)this);
            } else {
                return class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        if (this.method_6032() < this.method_6063() && stack.method_31574(class_1802.field_27022)) {
            this.method_6025(5.0f);
            float f1 = 1.4f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f;
            this.method_5783(USSounds.COPPER_GOLEM_REPAIR, 0.5f, f1);
            this.method_32875(class_5712.field_28725, (class_1297)this);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            return class_1269.method_29236((boolean)this.field_6002.method_8608());
        }
        return super.method_5992(player, hand);
    }

    public <T extends class_1308> void convertToFrozen(class_1299<T> entityType, boolean bl) {
        if (!this.method_31481()) {
            FrozenCopperGolemEntity mob = (FrozenCopperGolemEntity)entityType.method_5883(this.field_6002);
            assert (mob != null);
            mob.method_5719((class_1297)this);
            mob.method_5702(class_2183.class_2184.field_9851, this.method_5720());
            mob.method_5636(this.method_36454());
            mob.method_5847(this.method_5791());
            if (this.method_16914()) {
                mob.method_5665(this.method_5797());
            }
            if (this.method_5947()) {
                mob.method_5971();
            }
            mob.method_5684(this.method_5655());
            if (bl) {
                mob.method_5952(this.method_5936());
                for (class_1304 equipmentSlot : class_1304.values()) {
                    class_1799 itemStack = this.method_6118(equipmentSlot);
                    if (itemStack.method_7960()) continue;
                    mob.method_5673(equipmentSlot, itemStack.method_7972());
                    mob.method_5946(equipmentSlot, this.method_5929(equipmentSlot));
                    itemStack.method_7939(0);
                }
            }
            this.field_6002.method_8649((class_1297)mob);
            if (this.method_5765()) {
                class_1297 entity = this.method_5854();
                this.method_5848();
                if (entity != null) {
                    mob.method_5873(entity, true);
                }
            }
            this.method_31472();
        }
    }

    public void method_6007() {
        super.method_6007();
        if (!this.field_6002.method_8608()) {
            float randomChance;
            float chance = this.field_5974.method_43057();
            if (chance < 3.4290553E-11f) {
                this.method_5783(USSounds.CHINESE_RIP_OFF_WINNIE_THE_POOH, 1.0f, 1.0f);
            }
            if (this.getStage() == Stage.OXIDIZED) {
                this.convertToFrozen(USEntities.FROZEN_COPPER_GOLEM, true);
            }
            if (!this.isWaxed() && this.getStage() != Stage.OXIDIZED && (randomChance = this.field_5974.method_43057()) < 3.429055E-5f && this.getStage() != Stage.OXIDIZED) {
                this.setStage(Stage.values()[this.getStage().getId() + 1]);
            }
        }
    }

    protected class_3414 method_6011(class_1282 source) {
        return USSounds.COPPER_GOLEM_HIT;
    }

    protected class_3414 method_6002() {
        return USSounds.COPPER_GOLEM_DEATH;
    }

    protected class_3414 getStepSound() {
        return USSounds.COPPER_GOLEM_WALK;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getStepSound(), 0.5f, 1.0f);
    }

    public static enum Stage {
        UNAFFECTED(0, "unaffected", USSounds.HEAD_SPIN),
        EXPOSED(1, "exposed", USSounds.HEAD_SPIN_SLOWER),
        WEATHERED(2, "weathered", USSounds.HEAD_SPIN_SLOWEST),
        OXIDIZED(3, "oxidized", null);

        public static final Stage[] BY_ID;
        private final int id;
        private final String name;
        private final class_3414 soundEvent;

        private Stage(int id, String name, class_3414 soundEvent) {
            this.id = id;
            this.name = name;
            this.soundEvent = soundEvent;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public class_3414 getSoundEvent() {
            return this.soundEvent;
        }

        static {
            BY_ID = (Stage[])Arrays.stream(Stage.values()).sorted(Comparator.comparingInt(Stage::getId)).toArray(Stage[]::new);
        }
    }
}

