/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities;

import com.cursedcauldron.unvotedandshelved.entities.CopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.init.USEntityTypes;
import com.cursedcauldron.unvotedandshelved.init.USItems;
import com.cursedcauldron.unvotedandshelved.mixin.access.ThrownTridentAccessor;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FrozenCopperGolemEntity
extends AbstractGolem {
    private static final EntityDimensions MARKER_DIMENSIONS = new EntityDimensions(0.0f, 0.0f, true);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.f_20529_.m_20680_().m_20388_(0.5f);
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.m_135353_(FrozenCopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Predicate<Entity> RIDABLE_MINECARTS = entity -> entity instanceof AbstractMinecart && ((AbstractMinecart)entity).m_6064_() == AbstractMinecart.Type.RIDEABLE;
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private boolean invisible;
    public long lastHit;

    public FrozenCopperGolemEntity(EntityType<? extends FrozenCopperGolemEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 0.0f;
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_6034_(x, y, z);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.m_20068_();
    }

    public boolean m_6142_() {
        return super.m_6142_() && this.hasPhysics();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLIENT_FLAGS, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    public boolean m_20151_() {
        return this.m_8077_();
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), RIDABLE_MINECARTS);
        for (Entity entity : list) {
            if (!(this.m_20280_(entity) <= 0.2)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec3, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof AxeItem) {
            this.convertBack((EntityType)USEntityTypes.COPPER_GOLEM.get(), true);
            this.m_146859_(GameEvent.f_157771_, this.m_146901_());
            this.f_19853_.m_5594_(player, this.m_142538_(), SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.f_19853_.m_5898_(player, 3005, this.m_142538_(), 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public <T extends Mob> T convertBack(EntityType<T> entityType, boolean bl) {
        if (this.m_146910_()) {
            return null;
        }
        CopperGolemEntity mob = (CopperGolemEntity)entityType.m_20615_(this.f_19853_);
        assert (mob != null);
        mob.m_20359_((Entity)this);
        mob.m_146926_(this.f_19860_);
        mob.m_146922_(this.f_19859_);
        mob.m_5618_(this.f_20884_);
        mob.m_5616_(this.m_6080_());
        mob.m_6863_(this.m_6162_());
        mob.m_21557_(this.m_21525_());
        mob.setStage(CopperGolemEntity.Stage.WEATHERED);
        if (this.m_8077_()) {
            mob.m_6593_(this.m_7770_());
            mob.m_20340_(this.m_20151_());
        }
        if (this.m_21532_()) {
            mob.m_21530_();
        }
        mob.m_20331_(this.m_20147_());
        if (bl) {
            mob.m_21553_(this.m_21531_());
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack itemStack = this.m_6844_(equipmentSlot);
                if (itemStack.m_41619_()) continue;
                mob.m_8061_(equipmentSlot, itemStack.m_41777_());
                mob.m_21409_(equipmentSlot, this.m_21519_(equipmentSlot));
                itemStack.m_41764_(0);
            }
        }
        this.f_19853_.m_7967_((Entity)mob);
        if (this.m_20159_()) {
            Entity entity = this.m_20202_();
            this.m_8127_();
            mob.m_7998_(entity, true);
        }
        this.m_146870_();
        return (T)((Object)mob);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        ThrownTrident trident;
        if (this.f_19853_.f_46443_ || this.m_146910_()) {
            return false;
        }
        if (DamageSource.f_19317_.equals(damageSource)) {
            this.m_6074_();
            return false;
        }
        if (this.m_6673_(damageSource) || this.invisible || this.isMarker()) {
            return false;
        }
        if (damageSource.m_19372_()) {
            this.brokenByAnything(damageSource);
            this.m_6074_();
            return false;
        }
        if (DamageSource.f_19305_.equals(damageSource)) {
            if (this.m_6060_()) {
                this.causeDamage(damageSource, 0.15f);
            } else {
                this.m_20254_(5);
            }
            return false;
        }
        if (DamageSource.f_19307_.equals(damageSource) && this.m_21223_() > 0.5f) {
            this.causeDamage(damageSource, 4.0f);
            return false;
        }
        boolean bl = damageSource.m_7640_() instanceof AbstractArrow && !(damageSource.m_7640_() instanceof ThrownTrident);
        boolean bl2 = bl && ((AbstractArrow)damageSource.m_7640_()).m_36796_() > 0;
        boolean bl3 = "player".equals(damageSource.m_19385_());
        if (!bl3 && !bl) {
            return false;
        }
        Entity entity = damageSource.m_7640_();
        if (entity instanceof ThrownTrident && EnchantmentHelper.m_44936_((ItemStack)((ThrownTridentAccessor)(trident = (ThrownTrident)entity)).getTridentItem()) && this.f_19853_.m_45527_(this.m_142538_())) {
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
            lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)this.m_142538_()));
            lightningBolt.m_20879_(damageSource.m_7639_() instanceof ServerPlayer ? (ServerPlayer)damageSource.m_7639_() : null);
            this.f_19853_.m_7967_((Entity)lightningBolt);
            this.m_5496_(SoundEvents.f_12521_, 5.0f, 1.0f);
        }
        if (damageSource.m_7639_() instanceof Player && !((Player)damageSource.m_7639_()).m_150110_().f_35938_) {
            return false;
        }
        if (damageSource.m_19390_()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.m_6074_();
            return bl2;
        }
        long l = this.f_19853_.m_46467_();
        if (l - this.lastHit <= 5L || bl) {
            this.brokenByPlayer(damageSource);
            this.showBreakingParticles();
            this.m_6074_();
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)32);
            this.m_146852_(GameEvent.f_157808_, damageSource.m_7639_());
            this.lastHit = l;
        }
        return true;
    }

    public void m_7822_(byte b) {
        if (b == 32) {
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144120_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.f_19853_.m_46467_();
            }
        } else {
            super.m_7822_(b);
        }
    }

    public boolean m_6783_(double d) {
        double d2;
        double e = this.m_142469_().m_82309_() * 4.0;
        if (Double.isNaN(e) || e == 0.0) {
            e = 4.0;
        }
        return d < d2 * (e *= 64.0);
    }

    private void showBreakingParticles() {
        if (this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152501_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource damageSource, float f) {
        float f2;
        float g = this.m_21223_();
        g -= f;
        if (f2 <= 0.5f) {
            this.brokenByAnything(damageSource);
            this.m_6074_();
        } else {
            this.m_21153_(g);
            this.m_146852_(GameEvent.f_157808_, damageSource.m_7639_());
        }
    }

    private void brokenByPlayer(DamageSource damageSource) {
        Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (ItemStack)new ItemStack((ItemLike)USItems.FROZEN_COPPER_GOLEM_ITEM.get()));
        this.brokenByAnything(damageSource);
    }

    public final void brokenByAnything(DamageSource damageSource) {
        ItemStack itemStack;
        int i;
        this.playBrokenSound();
        this.m_6668_(damageSource);
        for (i = 0; i < this.handItems.size(); ++i) {
            itemStack = (ItemStack)this.handItems.get(i);
            if (itemStack.m_41619_()) continue;
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_().m_7494_(), (ItemStack)itemStack);
            this.handItems.set(i, (Object)ItemStack.f_41583_);
        }
        for (i = 0; i < this.armorItems.size(); ++i) {
            itemStack = (ItemStack)this.armorItems.get(i);
            if (itemStack.m_41619_()) continue;
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_().m_7494_(), (ItemStack)itemStack);
            this.armorItems.set(i, (Object)ItemStack.f_41583_);
        }
    }

    private void playBrokenSound() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144117_, this.m_5720_(), 1.0f, 1.0f);
    }

    protected float m_5632_(float f, float g) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * (this.m_6162_() ? 0.5f : 0.9f);
    }

    public double m_6049_() {
        return this.isMarker() ? 0.0 : (double)0.1f;
    }

    public void m_7023_(Vec3 vec3) {
        if (!this.hasPhysics()) {
            return;
        }
        super.m_7023_(vec3);
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        this.convertBack((EntityType)USEntityTypes.COPPER_GOLEM.get(), true);
        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144060_, SoundSource.BLOCKS, 2.0f, 0.5f + this.f_19796_.nextFloat() * 0.2f, false);
        this.f_19853_.m_46796_(3004, this.m_142538_(), 0);
    }

    public void m_5618_(float f) {
        this.f_20884_ = this.f_19859_ = f;
        this.f_20886_ = this.f_20885_ = f;
    }

    public void m_5616_(float f) {
        this.f_20884_ = this.f_19859_ = f;
        this.f_20886_ = this.f_20885_ = f;
    }

    protected void m_8034_() {
        this.m_6842_(this.invisible);
    }

    public void m_6842_(boolean bl) {
        this.invisible = bl;
        super.m_6842_(bl);
    }

    public boolean m_6162_() {
        return this.isSmall();
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_6128_() {
        return this.m_20145_();
    }

    public PushReaction m_7752_() {
        if (this.isMarker()) {
            return PushReaction.IGNORE;
        }
        return super.m_7752_();
    }

    public boolean isSmall() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public boolean isMarker() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_6087_() {
        return super.m_6087_() && !this.isMarker();
    }

    public boolean m_7313_(Entity entity) {
        return entity instanceof Player && !this.f_19853_.m_7966_((Player)entity, this.m_142538_());
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_144121_, SoundEvents.f_144121_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_144120_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_144117_;
    }

    public boolean m_5801_() {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (DATA_CLIENT_FLAGS.equals(entityDataAccessor)) {
            this.m_6210_();
            this.f_19850_ = !this.isMarker();
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean m_5789_() {
        return false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean bl) {
        if (bl) {
            return MARKER_DIMENSIONS;
        }
        return this.m_6162_() ? BABY_DIMENSIONS : this.m_6095_().m_20680_();
    }

    public Vec3 m_7371_(float f) {
        if (this.isMarker()) {
            AABB aABB = this.getDimensionsMarker(false).m_20393_(this.m_20182_());
            BlockPos blockPos = this.m_142538_();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockPos2 : BlockPos.m_121940_((BlockPos)new BlockPos(aABB.f_82288_, aABB.f_82289_, aABB.f_82290_), (BlockPos)new BlockPos(aABB.f_82291_, aABB.f_82292_, aABB.f_82293_))) {
                int j = Math.max(this.f_19853_.m_45517_(LightLayer.BLOCK, blockPos2), this.f_19853_.m_45517_(LightLayer.SKY, blockPos2));
                if (j == 15) {
                    return Vec3.m_82512_((Vec3i)blockPos2);
                }
                if (j <= i) continue;
                i = j;
                blockPos = blockPos2.m_7949_();
            }
            return Vec3.m_82512_((Vec3i)blockPos);
        }
        return super.m_7371_(f);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)USItems.FROZEN_COPPER_GOLEM_ITEM.get());
    }

    public boolean m_142065_() {
        return !this.m_20145_() && !this.isMarker();
    }
}

