/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities;

import com.cursedcauldron.unvotedandshelved.entities.ai.glare.GlareBrain;
import com.cursedcauldron.unvotedandshelved.init.USBlocks;
import com.cursedcauldron.unvotedandshelved.init.USMemoryModules;
import com.cursedcauldron.unvotedandshelved.init.USParticleTypes;
import com.cursedcauldron.unvotedandshelved.init.USSoundEvents;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlareEntity
extends AgeableMob
implements FlyingAnimal {
    protected static final ImmutableList<SensorType<? extends Sensor<? super GlareEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26812_);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_MODULES = ImmutableList.of((Object)((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()), (Object)((MemoryModuleType)USMemoryModules.GRUMPY_TICKS.get()), (Object)((MemoryModuleType)USMemoryModules.DARK_TICKS_REMAINING.get()), (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26383_);
    private static final EntityDataAccessor<Boolean> GRUMPY = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHINY = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FINDING_DARKNESS = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GRUMPY_TICKS = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GLOWBERRIES_GIVEN = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GlareEntity(EntityType<? extends AgeableMob> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 5, true);
        this.f_21365_ = new LookControl((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor serverLevelAccessor, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (spawnGroupData == null) {
            spawnGroupData = new AgeableMob.AgeableMobGroupData(false);
        }
        this.setShiny(this.m_21187_().nextInt(100) == 1);
        return spawnGroupData;
    }

    protected Brain.Provider<GlareEntity> m_5490_() {
        return Brain.m_21923_(MEMORY_MODULES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return GlareBrain.create((Brain<GlareEntity>)this.m_5490_().m_22073_(dynamic));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GRUMPY, (Object)false);
        this.f_19804_.m_135372_(SHINY, (Object)false);
        this.f_19804_.m_135372_(FINDING_DARKNESS, (Object)false);
        this.f_19804_.m_135372_(GRUMPY_TICKS, (Object)0);
        this.f_19804_.m_135372_(GLOWBERRIES_GIVEN, (Object)0);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_6274_().m_21874_((MemoryModuleType)USMemoryModules.GIVEN_GLOWBERRY.get());
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("IsGrumpy", this.isGrumpy());
        nbt.m_128379_("IsShiny", this.isShiny());
        nbt.m_128405_("GrumpyTicks", this.getGrumpyTick());
        if (this.f_20939_.m_21952_((MemoryModuleType)USMemoryModules.DARK_TICKS_REMAINING.get()).isPresent()) {
            nbt.m_128405_("FindDarknessTicks", ((Integer)this.f_20939_.m_21952_((MemoryModuleType)USMemoryModules.DARK_TICKS_REMAINING.get()).get()).intValue());
        }
        if (this.f_20939_.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).isPresent()) {
            nbt.m_128405_("GlowberriesGiven", ((Integer)this.f_20939_.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).get()).intValue());
        }
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setGrumpy(nbt.m_128471_("IsGrumpy"));
        this.setShiny(nbt.m_128471_("IsShiny"));
        this.setGrumpyTick(nbt.m_128451_("GrumpyTicks"));
        this.setGlowberries(nbt.m_128451_("GlowberriesGiven"));
    }

    public boolean m_142592_() {
        return this.f_19853_.m_8055_(this.m_142538_()).m_60795_();
    }

    public float m_5610_(@NotNull BlockPos pos, LevelReader world) {
        return world.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    public Brain<GlareEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("glareBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("glareActivityUpdate");
        GlareBrain.updateActivities(this);
        this.f_19853_.m_46473_().m_7238_();
        if (!this.m_21525_()) {
            Optional ticksRemaining = this.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.DARK_TICKS_REMAINING.get());
            this.setFindingDarkness(ticksRemaining.isPresent() && (Integer)ticksRemaining.get() > 0);
        }
    }

    public void setGrumpy(boolean isGrumpy) {
        this.f_19804_.m_135381_(GRUMPY, (Object)isGrumpy);
    }

    public void setShiny(boolean isShiny) {
        this.f_19804_.m_135381_(SHINY, (Object)isShiny);
    }

    public boolean isGrumpy() {
        return (Boolean)this.f_19804_.m_135370_(GRUMPY);
    }

    public boolean isShiny() {
        return (Boolean)this.f_19804_.m_135370_(SHINY);
    }

    public void setFindingDarkness(boolean findingDarkness) {
        this.f_19804_.m_135381_(FINDING_DARKNESS, (Object)findingDarkness);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected PathNavigation m_6037_(@NotNull Level world) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, world){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        navigator.m_26440_(false);
        navigator.m_7008_(true);
        navigator.m_26443_(true);
        return navigator;
    }

    private void updateGrumpy(Level level) {
        if (!level.m_5776_()) {
            int skyLight = this.f_19853_.m_7445_();
            if (skyLight > 0) {
                this.setGrumpy(level.m_45517_(LightLayer.BLOCK, this.m_142538_()) == 0 && level.m_45517_(LightLayer.SKY, this.m_142538_()) >= 0 || level.m_45517_(LightLayer.BLOCK, this.m_142538_()) == 0 && level.m_46470_());
            } else {
                this.setGrumpy(level.m_45517_(LightLayer.BLOCK, this.m_142538_()) == 0 && level.m_45517_(LightLayer.SKY, this.m_142538_()) == 0 || level.m_45517_(LightLayer.BLOCK, this.m_142538_()) == 0 && level.m_46470_());
            }
        }
    }

    public void m_8107_() {
        int berryAmount;
        super.m_8107_();
        if (this.f_19853_.m_46467_() % 20L == 0L) {
            this.updateGrumpy(this.f_19853_);
        }
        if ((berryAmount = this.getGlowberries()) > 0) {
            this.m_21530_();
            this.setGlowberries(berryAmount);
            this.f_19853_.m_7106_((ParticleOptions)USParticleTypes.GLOWBERRY_DUST_PARTICLES.get(), this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
        }
        if (this.m_21523_()) {
            this.m_21530_();
            if (!this.m_20075_().m_60795_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
            }
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, @NotNull DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, @NotNull BlockState landedState, @NotNull BlockPos landedPosition) {
    }

    protected void m_203347_(@NotNull TagKey<Fluid> fluid) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }

    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult actionResult = super.m_6071_(player, hand);
        if (actionResult.m_19077_()) {
            return actionResult;
        }
        if (!this.f_19853_.f_46443_) {
            return GlareBrain.playerInteract(this, player, hand);
        }
        boolean bl = GlareBrain.isGlowBerry(player.m_21120_(hand));
        return bl ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected SoundEvent m_7515_() {
        return this.isGrumpy() ? (SoundEvent)USSoundEvents.GLARE_GRUMPY_IDLE.get() : (SoundEvent)USSoundEvents.GLARE_IDLE.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)USSoundEvents.GLARE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)USSoundEvents.GLARE_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_144191_;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_(this.getStepSound(), 0.5f, 1.0f);
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * (this.m_6162_() ? 0.4f : 0.7f);
    }

    private void setGrumpyTick(int ticks) {
        this.f_19804_.m_135381_(GRUMPY_TICKS, (Object)ticks);
    }

    public int getGrumpyTick() {
        return (Integer)this.f_19804_.m_135370_(GRUMPY_TICKS);
    }

    public void setLightblock(BlockPos pos) {
        BlockState blockState = ((Block)USBlocks.GLOWBERRY_DUST.get()).m_49966_();
        if (this.f_19853_.m_8055_(pos).m_60795_()) {
            this.f_19853_.m_46597_(pos, blockState);
            this.m_5496_((SoundEvent)USSoundEvents.GLOWBERRY_DUST_PLACE.get(), 1.0f, 1.0f);
        }
    }

    public void setGlowberries(int amount) {
        this.f_20939_.m_21879_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get(), (Object)amount);
        this.f_19804_.m_135381_(GLOWBERRIES_GIVEN, (Object)amount);
    }

    public int getGlowberries() {
        return (Integer)this.f_19804_.m_135370_(GLOWBERRIES_GIVEN);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel world, @NotNull AgeableMob entity) {
        return null;
    }
}

