/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities.ai.copper_golem;

import com.cursedcauldron.unvotedandshelved.entities.CopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.entities.ai.copper_golem.task.FindCopperButtonTask;
import com.cursedcauldron.unvotedandshelved.entities.ai.copper_golem.task.PressCopperButtonTask;
import com.cursedcauldron.unvotedandshelved.entities.ai.copper_golem.task.SpinHeadTask;
import com.cursedcauldron.unvotedandshelved.init.USActivities;
import com.cursedcauldron.unvotedandshelved.init.USMemoryModules;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class CopperGolemBrain {
    public static Brain<?> create(Brain<CopperGolemEntity> brain) {
        CopperGolemBrain.addCoreActivities(brain);
        CopperGolemBrain.addIdleActivities(brain);
        CopperGolemBrain.addHeadSpinActivity(brain);
        CopperGolemBrain.addCopperButtonActivities(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<CopperGolemEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(0.45f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get()), (Object)new CountDownCooldownTicks((MemoryModuleType)USMemoryModules.COPPER_GOLEM_HEADSPIN_TICKS.get())));
    }

    private static void addIdleActivities(Brain<CopperGolemEntity> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(0.4f), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(0.4f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get()), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addCopperButtonActivities(Brain<CopperGolemEntity> brain) {
        brain.m_21903_((Activity)USActivities.PRESS_COPPER_BUTTON.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new FindCopperButtonTask())), (Object)Pair.of((Object)1, (Object)((Object)new PressCopperButtonTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addHeadSpinActivity(Brain<CopperGolemEntity> brain) {
        brain.m_21903_((Activity)USActivities.HEAD_SPIN.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new SpinHeadTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)USMemoryModules.COPPER_GOLEM_HEADSPIN_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(CopperGolemEntity entity) {
        entity.m_6274_().m_21926_((List)ImmutableList.of((Object)((Activity)USActivities.PRESS_COPPER_BUTTON.get()), (Object)((Activity)USActivities.HEAD_SPIN.get()), (Object)Activity.f_37979_));
    }
}

