/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities.ai.copper_golem.task;

import com.cursedcauldron.unvotedandshelved.block.CopperButtonBlock;
import com.cursedcauldron.unvotedandshelved.entities.CopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.init.USMemoryModules;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.pathfinder.Path;

public class FindCopperButtonTask
extends Behavior<CopperGolemEntity> {
    private BlockPos copperPosPublic;
    private BlockPos copperPosBelowPublic;

    public FindCopperButtonTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26381_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get()), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel world, CopperGolemEntity entity) {
        return entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get()).isEmpty() && entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get()).isEmpty();
    }

    protected boolean canStillUse(ServerLevel world, CopperGolemEntity entity, long p_22547_) {
        return entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get()).isEmpty() && entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get()).isEmpty();
    }

    protected void start(ServerLevel level, CopperGolemEntity entity, long p_22542_) {
        BlockPos copperPos = this.getCopperPos(entity, level);
        if (copperPos != null) {
            this.copperPosPublic = copperPos;
            BlockPos copperPosBelow = this.getCopperPos(entity, level).m_7495_();
            if (copperPosBelow != null) {
                this.copperPosBelowPublic = copperPosBelow;
            }
        }
    }

    protected void tick(ServerLevel level, CopperGolemEntity entity, long l) {
        if (this.copperPosPublic != null && this.copperPosBelowPublic != null) {
            BlockPos copperPos = this.copperPosPublic;
            BlockPos copperPosBelow = this.copperPosBelowPublic;
            BehaviorUtils.m_22617_((LivingEntity)entity, (BlockPos)copperPos, (float)0.4f, (int)1);
            Path button = entity.m_21573_().m_7864_(copperPos, 1);
            Path buttonBelow = entity.m_21573_().m_7864_(copperPosBelow, 1);
            if (button != null && button.m_77403_()) {
                entity.m_21573_().m_26536_(button, 0.4);
                if (entity.m_142538_().m_123314_((Vec3i)copperPos, 2.0) && entity.f_19853_.m_8055_(copperPos).m_60734_() instanceof CopperButtonBlock) {
                    entity.m_6274_().m_21879_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get(), (Object)copperPos);
                    this.copperPosPublic = copperPos;
                }
            } else if (buttonBelow != null && buttonBelow.m_77403_()) {
                entity.m_21573_().m_26536_(button, 0.4);
                if (entity.m_142538_().m_123314_((Vec3i)copperPos, 2.0) && entity.f_19853_.m_8055_(copperPos).m_60734_() instanceof CopperButtonBlock) {
                    entity.m_6274_().m_21879_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get(), (Object)copperPos);
                    this.copperPosPublic = copperPos;
                }
            } else {
                entity.m_6274_().m_21936_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get());
                entity.m_6274_().m_21879_((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get(), (Object)UniformInt.m_146622_((int)120, (int)240).m_142270_(level.m_5822_()));
            }
        }
    }

    public BlockPos getCopperPos(CopperGolemEntity entity, ServerLevel level) {
        int radius = 16;
        ArrayList possibles = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    BlockPos pos = new BlockPos(entity.m_20185_() + (double)x, entity.m_20186_() + (double)y, entity.m_20189_() + (double)z);
                    if (!(entity.f_19853_.m_8055_(pos).m_60734_() instanceof CopperButtonBlock)) continue;
                    possibles.add(pos);
                }
            }
        }
        if (possibles.isEmpty()) {
            entity.m_6274_().m_21879_((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get(), (Object)UniformInt.m_146622_((int)120, (int)240).m_142270_(level.m_5822_()));
            return null;
        }
        return (BlockPos)possibles.get(entity.m_21187_().nextInt(possibles.size()));
    }
}

